/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import vmm3d.core.Complex;
import vmm3d.core.IntegerParam;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.ComplexVector3D;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.WeierstrassMinimalSurface;

public class CatenoidEnneper
extends WeierstrassMinimalSurface {
    private IntegerParam exponent = new IntegerParam("vmm3d.surface.parametric.CatenoidEnneper.MainEx", 2);
    private RealParamAnimateable aa = new RealParamAnimateable("vmm3d.surface.parametric.CatenoidEnneper.CoeffA", 0.5, 0.0, 1.0);
    private int ex;
    private double a;
    private double r1;
    private double r2;
    private Complex q1;

    public CatenoidEnneper() {
        this.afp.reset(0.0, 0.0, 0.0);
        this.addParameter(this.aa);
        this.addParameter(this.exponent);
        this.setDefaultViewpoint(new Vector3D(-11.0, -17.0, 12.0));
        this.setDefaultWindow(-4.0, 4.0, -4.5, 3.5);
        this.uPatchCount.setValueAndDefault(8);
        this.vPatchCount.setValueAndDefault(18);
        this.umin.reset(-2.0);
        this.umax.reset(2.0);
        this.vmin.reset(0.0);
        this.vmax.reset(Math.PI * 2);
        this.canShowConjugateSurface = true;
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        double r = Math.exp(u);
        Complex z = new Complex(r * Math.cos(v), r * Math.sin(v));
        return z;
    }

    @Override
    protected Complex gauss(Complex z) {
        Complex w = new Complex(this.a * z.re, this.a * z.im);
        w.assignPow(w, this.ex);
        w.assignPlus(this.q1);
        w.assignTimes(this.r1);
        w.assignDivide(z);
        return w;
    }

    @Override
    protected Complex hPrime(Complex z) {
        return this.gauss(z).times(this.r2);
    }

    @Override
    protected Complex gaussTimesHPrime(Complex z) {
        Complex w = this.gauss(z);
        w.assignTimes(w);
        return w.times(this.r2);
    }

    @Override
    protected Complex gaussInverseTimesHPrime(Complex z) {
        return new Complex(this.r2, 0.0);
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.ex = this.exponent.getValue();
        this.a = this.aa.getValue();
        this.r1 = 1.0 / (3.0 + this.a * this.a);
        this.r2 = 0.4 / (1.0 + this.a * this.a * (double)this.ex / 2.0);
        this.q1 = new Complex(-3.0 + this.a, 0.0);
    }

    @Override
    protected ComplexVector3D getCenter() {
        return new ComplexVector3D(this.helperArray[(int)Math.floor(this.ucount / 2)][(int)Math.floor(this.vcount / 2)]);
    }
}

