/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface;

import java.awt.event.ActionEvent;
import vmm3d.actions.ActionList;
import vmm3d.actions.ActionRadioGroup;
import vmm3d.actions.ToggleAction;
import vmm3d.core.Exhibit;
import vmm3d.core.I18n;
import vmm3d.core.VMMSave;
import vmm3d.core3D.View3DLit;
import vmm3d.surface.Surface;

public class SurfaceView
extends View3DLit {
    protected ToggleAction omitULineAction = new ToggleAction(I18n.tr("vmm3d.surface.Surface.command.OmitUGridLines")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            SurfaceView.this.setShowUGridLines(!SurfaceView.this.showUGridLines);
        }
    };
    protected ToggleAction omitVLineAction = new ToggleAction(I18n.tr("vmm3d.surface.Surface.command.OmitVGridLines")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            SurfaceView.this.setShowVGridLines(!SurfaceView.this.showVGridLines);
        }
    };
    @VMMSave
    private boolean showUGridLines = true;
    @VMMSave
    private boolean showVGridLines = true;
    protected ActionRadioGroup gridSpacingSelect = new ActionRadioGroup(new String[]{I18n.tr("vmm3d.surface.Surface.command.GridSpacing.0"), I18n.tr("vmm3d.surface.Surface.command.GridSpacing.1"), I18n.tr("vmm3d.surface.Surface.command.GridSpacing.2"), I18n.tr("vmm3d.surface.Surface.command.GridSpacing.3"), I18n.tr("vmm3d.surface.Surface.command.GridSpacing.4"), I18n.tr("vmm3d.surface.Surface.command.GridSpacing.5")}){

        @Override
        public void optionSelected(int index) {
            SurfaceView.this.setGridSpacing(SurfaceView.this.standardGridSpacings[index]);
        }
    };
    @VMMSave
    private int gridSpacing;
    private int[] standardGridSpacings = new int[]{1, 2, 3, 6, 12, 0};

    public SurfaceView() {
        this.setGridSpacing(1);
        this.setAntialiased(true);
    }

    public void setGridSpacing(int gridSpacing) {
        if (gridSpacing < 0) {
            gridSpacing = 0;
        }
        if (this.gridSpacing == gridSpacing) {
            return;
        }
        this.gridSpacing = gridSpacing;
        for (int i = 0; i < this.standardGridSpacings.length; ++i) {
            if (gridSpacing != this.standardGridSpacings[i]) continue;
            this.gridSpacingSelect.setSelectedIndex(i);
            break;
        }
        this.forceRedraw();
    }

    public int getGridSpacing() {
        return this.gridSpacing;
    }

    public boolean getShowUGridLines() {
        return this.showUGridLines;
    }

    public void setShowUGridLines(boolean showUGridLines) {
        if (this.showUGridLines != showUGridLines) {
            this.showUGridLines = showUGridLines;
            this.omitULineAction.putValue("ToggleStatus", new Boolean(!showUGridLines));
            this.forceRedraw();
        }
    }

    public boolean getShowVGridLines() {
        return this.showVGridLines;
    }

    public void setShowVGridLines(boolean showVGridLines) {
        if (this.showVGridLines != showVGridLines) {
            this.showVGridLines = showVGridLines;
            this.omitVLineAction.putValue("ToggleStatus", new Boolean(!showVGridLines));
            this.forceRedraw();
        }
    }

    @Override
    public ActionList getActions() {
        ActionList commands = super.getActions();
        ActionList list = new ActionList(I18n.tr("vmm3d.surface.Surface.command.GridSpacing"));
        list.add(this.gridSpacingSelect);
        list.add(null);
        list.add(this.omitULineAction);
        list.add(this.omitVLineAction);
        commands.add(list);
        return commands;
    }

    @Override
    public void setExhibit(Exhibit exhibit) {
        super.setExhibit(exhibit);
        if (exhibit != null && exhibit instanceof Surface) {
            this.setOrientation(((Surface)exhibit).getDefaultOrientation());
        }
    }
}

