/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.pseudospherical;

import vmm3d.core.Complex;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.pseudospherical.ComplexMatrix2D;
import vmm3d.pseudospherical.ComplexVector2D;
import vmm3d.surface.parametric.SurfaceParametric;

public class nSolitons
extends SurfaceParametric {
    Complex lambda;
    double xVar;
    double tVar;
    public RealParamAnimateable s = new RealParamAnimateable("s1", 1.0, 0.2, 1.0);
    public RealParamAnimateable s1 = new RealParamAnimateable("s2", 1.0, 0.2, 1.0);
    public RealParamAnimateable s2 = new RealParamAnimateable("s3", 1.0, 0.2, 1.0);
    public int solitonNum = 2;
    public double epsilon = 1.0E-7;
    public ComplexVector2D initVec = new ComplexVector2D(new Complex(1.0, 0.0), new Complex(1.0, 0.0));
    public ComplexVector2D initVec1 = new ComplexVector2D(new Complex(1.0, 0.0), new Complex(-5.0, 0.0));
    public ComplexVector2D initVec2 = new ComplexVector2D(new Complex(1.0, 0.0), new Complex(1.0, 0.0));
    public ComplexMatrix2D E0;
    public ComplexMatrix2D g1;
    public ComplexMatrix2D g2;
    public ComplexMatrix2D g3;
    public ComplexMatrix2D E1;
    public ComplexMatrix2D proj;
    public ComplexMatrix2D proj1;
    public ComplexMatrix2D proj2;
    public ComplexMatrix2D projPerp;
    public ComplexMatrix2D projPerp1;
    public ComplexMatrix2D projPerp2;
    public ComplexMatrix2D id;
    public ComplexMatrix2D g1Perp;
    public ComplexMatrix2D[][] E;
    public ComplexMatrix2D[][] g;

    public nSolitons() {
        int j;
        int i;
        this.lambda = new Complex(0.0, 1.0);
        this.E = new ComplexMatrix2D[4][6];
        for (i = 0; i <= 3; ++i) {
            for (j = 0; j < 6; ++j) {
                this.E[i][j] = new ComplexMatrix2D();
            }
        }
        this.g = new ComplexMatrix2D[4][5];
        for (i = 0; i <= 3; ++i) {
            for (j = 0; j < 5; ++j) {
                this.g[i][j] = new ComplexMatrix2D();
            }
        }
        this.E0 = new ComplexMatrix2D();
        this.getE0(this.xVar, this.s.getValue(), this.lambda);
        this.proj = ComplexMatrix2D.getProj(this.initVec);
        this.proj1 = ComplexMatrix2D.getProj(this.initVec1);
        this.proj2 = ComplexMatrix2D.getProj(this.initVec2);
        this.id = new ComplexMatrix2D();
        this.id.setMatrixEntry(Complex.ONE_C, 1, 1);
        this.id.setMatrixEntry(Complex.ZERO_C, 1, 2);
        this.id.setMatrixEntry(Complex.ZERO_C, 2, 1);
        this.id.setMatrixEntry(Complex.ONE_C, 2, 2);
        this.g1 = new ComplexMatrix2D();
        this.g2 = new ComplexMatrix2D();
        this.g3 = new ComplexMatrix2D();
    }

    public ComplexMatrix2D getProj(ComplexVector2D v) {
        return ComplexMatrix2D.getProj(v);
    }

    public void getg1(Complex lbda) {
        ComplexMatrix2D projPerp = this.id.subtract(this.proj);
        Complex i = new Complex(0.0, 1.0);
        i = i.times(2.0 * this.s.getValue()).dividedBy(lbda.minus(i.times(this.s.getValue())));
        this.g1.entries[1][1] = new Complex(i.times(projPerp.entries[1][1]).plus(1.0));
        this.g1.entries[1][2] = new Complex(i.times(projPerp.entries[1][2]));
        this.g1.entries[2][1] = new Complex(i.times(projPerp.entries[2][1]));
        this.g1.entries[2][2] = new Complex(i.times(projPerp.entries[2][2]).plus(1.0));
    }

    public void getg2(Complex lbda) {
        ComplexMatrix2D projPerp = this.id.subtract(this.proj1);
        Complex i = new Complex(0.0, 1.0);
        i = i.times(2.0 * this.s1.getValue()).dividedBy(lbda.minus(i.times(this.s1.getValue())));
        this.g2.entries[1][1] = new Complex(i.times(projPerp.entries[1][1]).plus(1.0));
        this.g2.entries[1][2] = new Complex(i.times(projPerp.entries[1][2]));
        this.g2.entries[2][1] = new Complex(i.times(projPerp.entries[2][1]));
        this.g2.entries[2][2] = new Complex(i.times(projPerp.entries[2][2]).plus(1.0));
    }

    public void getg3(Complex lbda) {
        ComplexMatrix2D projPerp = this.id.subtract(this.proj2);
        Complex i = new Complex(0.0, 1.0);
        i = i.times(2.0 * this.s2.getValue()).dividedBy(lbda.minus(i.times(this.s2.getValue())));
        this.g3.entries[1][1] = new Complex(i.times(projPerp.entries[1][1]).plus(1.0));
        this.g3.entries[1][2] = new Complex(i.times(projPerp.entries[1][2]));
        this.g3.entries[2][1] = new Complex(i.times(projPerp.entries[2][1]));
        this.g3.entries[2][2] = new Complex(i.times(projPerp.entries[2][2]).plus(1.0));
    }

    public void getE0(double x, double t, Complex lmbda) {
        Complex i = new Complex(0.0, 1.0);
        Complex i1 = new Complex(i.times(lmbda).times(x / 2.0 + t / 2.0));
        Complex i2 = new Complex(i.times(x / 2.0 - t / 2.0).dividedBy(lmbda));
        this.E0.entries[1][1] = i2.minus(i1).exponential();
        this.E0.entries[1][2] = new Complex(0.0, 0.0);
        this.E0.entries[2][1] = new Complex(0.0, 0.0);
        this.E0.entries[2][2] = i1.minus(i2).exponential();
    }

    public ComplexMatrix2D getg1Perp(Complex lbda) {
        ComplexMatrix2D g1Perp = new ComplexMatrix2D();
        ComplexMatrix2D prjPerp = this.id.subtract(this.projPerp);
        Complex i = new Complex(0.0, 1.0);
        i = i.times(2.0 * this.s.getValue()).dividedBy(lbda.minus(i.times(this.s.getValue())));
        g1Perp.entries[1][1] = new Complex(i.times(prjPerp.entries[1][1]).plus(1.0));
        g1Perp.entries[1][2] = new Complex(i.times(prjPerp.entries[1][2]));
        g1Perp.entries[2][1] = new Complex(i.times(prjPerp.entries[2][1]));
        g1Perp.entries[2][2] = new Complex(i.times(prjPerp.entries[2][2]).plus(1.0));
        return g1Perp;
    }

    public ComplexMatrix2D getg2Perp(Complex lbda) {
        ComplexMatrix2D g2Perp = new ComplexMatrix2D();
        ComplexMatrix2D prjPerp = this.id.subtract(this.projPerp1);
        Complex i = new Complex(0.0, 1.0);
        i = i.times(2.0 * this.s1.getValue()).dividedBy(lbda.minus(i.times(this.s1.getValue())));
        g2Perp.entries[1][1] = new Complex(i.times(prjPerp.entries[1][1]).plus(1.0));
        g2Perp.entries[1][2] = new Complex(i.times(prjPerp.entries[1][2]));
        g2Perp.entries[2][1] = new Complex(i.times(prjPerp.entries[2][1]));
        g2Perp.entries[2][2] = new Complex(i.times(prjPerp.entries[2][2]).plus(1.0));
        return g2Perp;
    }

    public ComplexMatrix2D getg3Perp(Complex lbda) {
        ComplexMatrix2D g3Perp = new ComplexMatrix2D();
        ComplexMatrix2D prjPerp = this.id.subtract(this.projPerp2);
        Complex i = new Complex(0.0, 1.0);
        i = i.times(2.0 * this.s2.getValue()).dividedBy(lbda.minus(i.times(this.s2.getValue())));
        g3Perp.entries[1][1] = new Complex(i.times(prjPerp.entries[1][1]).plus(1.0));
        g3Perp.entries[1][2] = new Complex(i.times(prjPerp.entries[1][2]));
        g3Perp.entries[2][1] = new Complex(i.times(prjPerp.entries[2][1]));
        g3Perp.entries[2][2] = new Complex(i.times(prjPerp.entries[2][2]).plus(1.0));
        return g3Perp;
    }

    public ComplexMatrix2D getgTilde(ComplexMatrix2D g, Complex lambda, double sVal) {
        Complex val = new Complex(0.0, sVal);
        ComplexMatrix2D perp = g.subtract(this.id).scalarMul(lambda.minus(val).dividedBy(new Complex(0.0, 2.0 * sVal)));
        perp = this.id.subtract(perp);
        return perp;
    }

    public ComplexMatrix2D getgPerp(ComplexMatrix2D E, double sVal, Complex lbda, ComplexVector2D v) {
        ComplexMatrix2D ret = new ComplexMatrix2D(E);
        ret = ret.conjugate().transpose();
        ret = ComplexMatrix2D.getProj(ret.vectMul(v));
        ret = this.id.subtract(ret);
        ComplexMatrix2D mat = new ComplexMatrix2D();
        Complex i = new Complex(0.0, 1.0);
        i = new Complex(i.times(2.0 * sVal).dividedBy(lbda.minus(i.times(sVal))));
        mat.entries[1][1] = i.times(new Complex(ret.entries[1][1])).plus(1.0);
        mat.entries[1][2] = i.times(new Complex(ret.entries[1][2]));
        mat.entries[2][1] = i.times(new Complex(ret.entries[2][1]));
        mat.entries[2][2] = i.times(new Complex(ret.entries[2][2])).plus(1.0);
        return mat;
    }

    public ComplexMatrix2D getNextE(ComplexMatrix2D En, ComplexMatrix2D En1, ComplexMatrix2D En2, ComplexMatrix2D proj, ComplexMatrix2D prPerp, double sVal) {
        ComplexMatrix2D nextE = new ComplexMatrix2D(proj.multiply(En));
        ComplexMatrix2D temp = new ComplexMatrix2D(this.id.subtract(proj));
        temp = temp.multiply(En1).multiply(this.id.subtract(prPerp));
        nextE = new ComplexMatrix2D(nextE.add(temp));
        temp = new ComplexMatrix2D(proj);
        temp = temp.scalarMul(new Complex(0.0, -2.0 * sVal));
        temp = temp.multiply(En1.subtract(En2).multiply(this.id.subtract(prPerp)).scalarMul(new Complex(1.0 / (2.0 * this.epsilon), 0.0)));
        nextE = nextE.add(temp);
        return nextE;
    }

    public ComplexMatrix2D getNextE1(ComplexMatrix2D En, ComplexMatrix2D En1, ComplexMatrix2D En2, ComplexMatrix2D prPerp, ComplexMatrix2D prPerp1, double sVal) {
        ComplexMatrix2D temp1 = this.proj.add(this.proj1).subtract(this.proj1.multiply(this.proj).scalarMul(new Complex(2.0, 0.0)));
        ComplexMatrix2D deriv = En1.subtract(En2).scalarMul(new Complex(1.0 / (2.0 * this.epsilon), 0.0));
        ComplexMatrix2D doubleDeriv = En1.add(En2).subtract(En.scalarMul(new Complex(2.0, 0.0))).scalarMul(new Complex(1.0 / (this.epsilon * this.epsilon), 0.0));
        ComplexMatrix2D temp2 = this.id.subtract(prPerp).add(this.id.subtract(prPerp1));
        ComplexMatrix2D temp3 = this.id.subtract(prPerp).multiply(this.id.subtract(prPerp1));
        ComplexMatrix2D temp4 = this.id.subtract(this.proj1).multiply(this.id.subtract(this.proj));
        temp4 = temp4.subtract(this.proj1.multiply(this.id.subtract(this.proj)));
        temp4 = temp4.subtract(this.id.subtract(this.proj1).multiply(this.proj));
        ComplexMatrix2D nextE1 = En.add(deriv.multiply(temp2).scalarMul(new Complex(0.0, -2.0 * sVal)));
        nextE1 = nextE1.add(doubleDeriv.multiply(temp3).scalarMul(new Complex(-2.0 * sVal * sVal, 0.0)));
        nextE1 = this.proj1.multiply(this.proj).multiply(nextE1);
        nextE1 = nextE1.add(temp1.multiply(En).multiply(temp2));
        nextE1 = nextE1.add(temp1.multiply(deriv).multiply(temp3).scalarMul(new Complex(0.0, -2.0 * sVal)));
        nextE1 = nextE1.add(temp4.multiply(En).multiply(temp3));
        return nextE1;
    }

    public ComplexMatrix2D firstSoliton(double x, double t) {
        this.getE0(x, t, new Complex(0.0, -this.s.getValue()));
        ComplexMatrix2D temp = new ComplexMatrix2D(this.E0);
        this.lambda = new Complex(1.0 + this.epsilon, 0.0);
        ComplexMatrix2D mat = new ComplexMatrix2D(this.getgPerp(temp, this.s.getValue(), this.lambda, this.initVec));
        this.projPerp = this.getgTilde(mat, this.lambda, this.s.getValue());
        this.getg1(this.lambda);
        this.getE0(x, t, this.lambda);
        this.E[0][0] = new ComplexMatrix2D(this.E0);
        this.g[0][0] = new ComplexMatrix2D(mat);
        ComplexMatrix2D ret = new ComplexMatrix2D(this.g1.multiply(this.E0.multiply(mat.conjugate().transpose())));
        this.E[1][0] = new ComplexMatrix2D(ret);
        this.lambda = new Complex(1.0 - this.epsilon, 0.0);
        mat = new ComplexMatrix2D(this.getgPerp(temp, this.s.getValue(), this.lambda, this.initVec));
        this.getg1(this.lambda);
        this.getE0(x, t, this.lambda);
        this.E[0][1] = new ComplexMatrix2D(this.E0);
        this.g[0][1] = new ComplexMatrix2D(mat);
        ComplexMatrix2D ret1 = new ComplexMatrix2D(this.g1.multiply(this.E0.multiply(mat.conjugate().transpose())));
        this.E[1][1] = new ComplexMatrix2D(ret1);
        ret = new ComplexMatrix2D(ret.subtract(ret1));
        ret = new ComplexMatrix2D(ret.scalarMul(new Complex(1.0 / (2.0 * this.epsilon), 0.0)));
        this.lambda = new Complex(1.0, 0.0);
        mat = new ComplexMatrix2D(this.getgPerp(temp, this.s.getValue(), this.lambda, this.initVec));
        this.getg1(this.lambda);
        this.getE0(x, t, this.lambda);
        this.E[0][2] = new ComplexMatrix2D(this.E0);
        this.g[0][2] = new ComplexMatrix2D(mat);
        ret1 = new ComplexMatrix2D(this.g1.multiply(this.E0.multiply(mat.conjugate().transpose())));
        this.E[1][2] = new ComplexMatrix2D(ret1);
        ret = ret.multiply(mat.multiply(this.E0.inverse().multiply(this.g1.conjugate().transpose())));
        return ret;
    }

    public void afterFirstSol(double x, double t) {
        this.getE0(x, t, new Complex(0.0, -this.s.getValue()));
        ComplexMatrix2D temp = new ComplexMatrix2D(this.E0);
        double tt = this.s.getValue();
        if (this.solitonNum == 2) {
            tt = this.s1.getValue();
        }
        if (this.solitonNum == 3) {
            tt = this.s2.getValue();
        }
        this.lambda = new Complex(0.0, -tt);
        this.getE0(x, t, this.lambda);
        this.E[0][5] = new ComplexMatrix2D(this.E0);
        this.lambda = new Complex(this.epsilon, -tt);
        this.getg1(this.lambda);
        this.getE0(x, t, this.lambda);
        ComplexMatrix2D mat = new ComplexMatrix2D(this.getgPerp(temp, tt, this.lambda, this.initVec));
        this.E[0][3] = new ComplexMatrix2D(this.E0);
        this.g[0][3] = new ComplexMatrix2D(mat);
        ComplexMatrix2D ret1 = new ComplexMatrix2D(this.g1.multiply(this.E0.multiply(mat.inverse())));
        this.E[1][3] = new ComplexMatrix2D(ret1);
        this.lambda = new Complex(-this.epsilon, -tt);
        this.getg1(this.lambda);
        this.getE0(x, t, this.lambda);
        mat = new ComplexMatrix2D(this.getgPerp(temp, tt, this.lambda, this.initVec));
        this.E[0][4] = new ComplexMatrix2D(this.E0);
        this.g[0][4] = new ComplexMatrix2D(mat);
        ret1 = new ComplexMatrix2D(this.g1.multiply(this.E0.multiply(mat.inverse())));
        this.E[1][4] = new ComplexMatrix2D(ret1);
        if (this.s.getValue() == this.s1.getValue()) {
            this.E[1][5] = this.getNextE(this.E[0][5], this.E[0][3], this.E[0][4], this.proj, this.projPerp, this.s.getValue());
        } else {
            this.lambda = new Complex(0.0, -this.s1.getValue());
            this.getg1(this.lambda);
            this.getE0(x, t, this.lambda);
            mat = new ComplexMatrix2D(this.getgPerp(temp, this.s.getValue(), this.lambda, this.initVec));
            this.E[1][5] = this.g1.multiply(this.E0).multiply(mat.inverse());
        }
        this.lambda = new Complex(1.0 + this.epsilon, 0.0);
        this.g[1][0] = this.getgPerp(this.E[1][5], this.s1.getValue(), this.lambda, this.initVec1);
        this.projPerp1 = this.getgTilde(this.g[1][0], this.lambda, this.s1.getValue());
        this.lambda = new Complex(1.0 - this.epsilon, 0.0);
        this.g[1][1] = this.getgPerp(this.E[1][5], this.s1.getValue(), this.lambda, this.initVec1);
        this.lambda = new Complex(1.0, 0.0);
        this.g[1][2] = this.getgPerp(this.E[1][5], this.s1.getValue(), this.lambda, this.initVec1);
        this.lambda = new Complex(this.epsilon, -tt);
        this.g[1][3] = this.getgPerp(this.E[1][5], tt, this.lambda, this.initVec1);
        this.lambda = new Complex(-this.epsilon, -tt);
        this.g[1][4] = this.getgPerp(this.E[1][5], tt, this.lambda, this.initVec1);
    }

    public ComplexMatrix2D iterate1(double x, double t) {
        ComplexMatrix2D mat;
        int num = 1;
        this.lambda = new Complex(1.0 + this.epsilon, 0.0);
        this.getg2(this.lambda);
        this.E[num + 1][0] = mat = new ComplexMatrix2D(this.g2.multiply(this.E[num][0].multiply(this.g[num][0].conjugate().transpose())));
        this.lambda = new Complex(1.0 - this.epsilon, 0.0);
        this.getg2(this.lambda);
        this.E[num + 1][1] = mat = new ComplexMatrix2D(this.g2.multiply(this.E[num][1].multiply(this.g[num][1].conjugate().transpose())));
        this.lambda = new Complex(1.0, 0.0);
        this.getg2(this.lambda);
        this.E[num + 1][2] = mat = new ComplexMatrix2D(this.g2.multiply(this.E[num][2].multiply(this.g[num][2].conjugate().transpose())));
        ComplexMatrix2D ret = new ComplexMatrix2D(this.E[num + 1][0]);
        ret = ret.subtract(this.E[num + 1][1]);
        ret = ret.multiply(this.E[num + 1][2].inverse());
        ret = ret.scalarMul(new Complex(1.0 / (2.0 * this.epsilon), 0.0));
        return ret;
    }

    public void afterIterate1(double x, double t) {
        ComplexMatrix2D mat;
        int num = 1;
        double tempVal = this.s2.getValue();
        if (this.s.getValue() == this.s1.getValue() && this.s1.getValue() == this.s2.getValue()) {
            this.s2.setValue(tempVal + 0.01);
        }
        this.lambda = new Complex(this.epsilon, -this.s2.getValue());
        this.getg2(this.lambda);
        this.E[num + 1][3] = mat = new ComplexMatrix2D(this.g2.multiply(this.E[num][3].multiply(this.g[num][3].inverse())));
        this.lambda = new Complex(-this.epsilon, -this.s2.getValue());
        this.getg2(this.lambda);
        this.E[num + 1][4] = mat = new ComplexMatrix2D(this.g2.multiply(this.E[num][4].multiply(this.g[num][4].inverse())));
        this.lambda = new Complex(0.0, -this.s2.getValue());
        if (this.s2.getValue() == this.s1.getValue() && this.s1.getValue() != this.s.getValue()) {
            this.getg1(this.lambda);
            this.getE0(x, t, this.lambda);
            mat = this.getg1Perp(this.lambda);
            ComplexMatrix2D temp1 = new ComplexMatrix2D(this.g1.multiply(this.E0).multiply(mat.inverse()));
            this.lambda = new Complex(this.epsilon, -this.s2.getValue());
            this.getg1(this.lambda);
            this.getE0(x, t, this.lambda);
            mat = this.getg1Perp(this.lambda);
            ComplexMatrix2D temp2 = new ComplexMatrix2D(this.g1.multiply(this.E0).multiply(mat.inverse()));
            this.lambda = new Complex(-this.epsilon, -this.s2.getValue());
            this.getg1(this.lambda);
            this.getE0(x, t, this.lambda);
            mat = this.getg1Perp(this.lambda);
            ComplexMatrix2D temp3 = new ComplexMatrix2D(this.g1.multiply(this.E0).multiply(mat.inverse()));
            this.E[num + 1][5] = this.getNextE(temp1, temp2, temp3, this.proj1, this.projPerp1, this.s2.getValue());
        } else if (this.s2.getValue() == this.s.getValue() && this.s.getValue() != this.s1.getValue()) {
            this.getE0(x, t, this.lambda);
            this.getg2(this.lambda);
            ComplexMatrix2D temp = new ComplexMatrix2D(this.getg2Perp(this.lambda));
            ComplexMatrix2D temp1 = new ComplexMatrix2D(this.E0);
            this.lambda = new Complex(this.epsilon, -this.s2.getValue());
            this.getE0(x, t, this.lambda);
            ComplexMatrix2D temp2 = new ComplexMatrix2D(this.E0);
            this.lambda = new Complex(-this.epsilon, -this.s2.getValue());
            this.getE0(x, t, this.lambda);
            ComplexMatrix2D temp3 = new ComplexMatrix2D(this.E0);
            mat = new ComplexMatrix2D(this.getNextE(temp1, temp2, temp3, this.proj, this.projPerp, this.s2.getValue()));
            this.E[num + 1][5] = this.g2.multiply(mat).multiply(temp.inverse());
        } else {
            this.getE0(x, t, this.lambda);
            ComplexMatrix2D temp = new ComplexMatrix2D(this.getg1Perp(this.lambda));
            ComplexMatrix2D temp1 = new ComplexMatrix2D(this.getg2Perp(this.lambda));
            this.getg1(this.lambda);
            this.getg2(this.lambda);
            this.E[num + 1][5] = this.g2.multiply(this.g1).multiply(this.E0).multiply(temp.inverse()).multiply(temp1.inverse());
        }
        this.lambda = new Complex(1.0 + this.epsilon, 0.0);
        this.g[num + 1][0] = this.getgPerp(this.E[num + 1][5], this.s2.getValue(), this.lambda, this.initVec2);
        this.projPerp2 = this.getgTilde(this.g[num + 1][0], this.lambda, this.s2.getValue());
        this.lambda = new Complex(1.0 - this.epsilon, 0.0);
        this.g[num + 1][1] = this.getgPerp(this.E[num + 1][5], this.s2.getValue(), this.lambda, this.initVec2);
        this.lambda = new Complex(1.0, 0.0);
        this.g[num + 1][2] = this.getgPerp(this.E[num + 1][5], this.s2.getValue(), this.lambda, this.initVec2);
        this.lambda = new Complex(this.epsilon, -this.s2.getValue());
        this.g[num + 1][3] = this.getgPerp(this.E[num + 1][5], this.s2.getValue(), this.lambda, this.initVec2);
        this.lambda = new Complex(-this.epsilon, -this.s2.getValue());
        this.g[num + 1][4] = this.getgPerp(this.E[num + 1][5], this.s2.getValue(), this.lambda, this.initVec2);
        this.s2.setValue(tempVal);
    }

    ComplexMatrix2D iterate2() {
        ComplexMatrix2D mat;
        int num = 2;
        this.lambda = new Complex(1.0 + this.epsilon, 0.0);
        this.getg3(this.lambda);
        this.E[num + 1][0] = mat = new ComplexMatrix2D(this.g3.multiply(this.E[num][0].multiply(this.g[num][0].conjugate().transpose())));
        this.lambda = new Complex(1.0 - this.epsilon, 0.0);
        this.getg3(this.lambda);
        this.E[num + 1][1] = mat = new ComplexMatrix2D(this.g3.multiply(this.E[num][1].multiply(this.g[num][1].conjugate().transpose())));
        this.lambda = new Complex(1.0, 0.0);
        this.getg3(this.lambda);
        this.E[num + 1][2] = mat = new ComplexMatrix2D(this.g3.multiply(this.E[num][2].multiply(this.g[num][2].conjugate().transpose())));
        ComplexMatrix2D ret = new ComplexMatrix2D(this.E[num + 1][0]);
        ret = ret.subtract(this.E[num + 1][1]);
        ret = ret.multiply(this.E[num + 1][2].inverse());
        ret = ret.scalarMul(new Complex(1.0 / (2.0 * this.epsilon), 0.0));
        return ret;
    }

    @Override
    public synchronized Vector3D surfacePoint(double x, double t) {
        return new Vector3D(0.0, 0.0, 0.0);
    }
}

