/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.planecurve.parametric;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.core.Decoration;
import vmm3d.core.Exhibit;
import vmm3d.core.Transform;
import vmm3d.core.VMMSave;
import vmm3d.core.View;
import vmm3d.planecurve.parametric.PlaneCurveParametric;

public class TangentAndNormalDecoration
extends Decoration {
    private PlaneCurveParametric curve;
    @VMMSave
    private double t = Double.NaN;

    public PlaneCurveParametric getCurve() {
        return this.curve;
    }

    public void setCurve(PlaneCurveParametric c) {
        this.curve = c;
    }

    public void setT(double t) {
        this.t = t;
        this.fireDecorationChangeEvent();
    }

    public double getT() {
        return this.t;
    }

    public void setIndex(int tIndex) {
        if (this.curve != null) {
            this.setT(this.curve.getT(tIndex));
        }
    }

    @Override
    public void doDraw(VectorGraphics g, View view, Transform limits) {
        if (this.curve == null && view != null) {
            Exhibit c = view.getExhibit();
            if (c instanceof PlaneCurveParametric) {
                this.curve = (PlaneCurveParametric)c;
            } else {
                return;
            }
        }
        if (Double.isNaN(this.t)) {
            return;
        }
        double x = this.curve.xValue(this.t);
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            return;
        }
        double y = this.curve.yValue(this.t);
        if (Double.isNaN(y) || Double.isInfinite(y)) {
            return;
        }
        double dx = this.curve.xDerivativeValue(this.t);
        if (Double.isNaN(dx) || Double.isInfinite(dx)) {
            return;
        }
        double dy = this.curve.yDerivativeValue(this.t);
        if (Double.isNaN(dy) || Double.isInfinite(dy)) {
            return;
        }
        double length = Math.sqrt(dx * dx + dy * dy);
        if (length == 0.0) {
            return;
        }
        dx = dx / length * 40.0 * limits.getPixelWidth();
        dy = dy / length * 40.0 * limits.getPixelHeight();
        Color saveColor = g.getColor();
        Stroke saveStroke = g.getStroke();
        g.setStroke((Stroke)new BasicStroke(2.0f * limits.getDefaultStrokeSize()));
        g.setColor(Color.red);
        g.draw((Shape)new Line2D.Double(x, y, x + dx, y + dy));
        g.setColor(Color.blue);
        g.draw((Shape)new Line2D.Double(x, y, x - dy, y + dx));
        g.setColor(saveColor);
        g.setStroke(saveStroke);
    }
}

