/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.planecurve.parametric;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.core.Complex;
import vmm3d.core.Decoration;
import vmm3d.core.Display;
import vmm3d.core.I18n;
import vmm3d.core.MouseTask;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.Transform;
import vmm3d.core.View;
import vmm3d.planecurve.parametric.ConicSection;
import vmm3d.planecurve.parametric.NormalBundleDecoration;

public class Parabola
extends ConicSection {
    private RealParamAnimateable focalLength = new RealParamAnimateable("vmm3d.planecurve.parametric.Parabola.FocalLength", 0.75, 0.5, 1.5);

    public Parabola() {
        this.tResolution.setValueAndDefault(192);
        this.tmin.setValueAndDefault(-8.0);
        this.tmax.setValueAndDefault(8.0);
        this.addParameter(this.focalLength);
        this.setDefaultWindow(-8.0, 8.0, -8.0, 8.0);
    }

    @Override
    public double xValue(double t) {
        return t * t / (4.0 * this.focalLength.getValue());
    }

    @Override
    public double yValue(double t) {
        return t;
    }

    @Override
    public double xDerivativeValue(double t) {
        return t / (2.0 * this.focalLength.getValue());
    }

    @Override
    public double yDerivativeValue(double t) {
        return 1.0;
    }

    @Override
    public double x2ndDerivativeValue(double t) {
        return 1.0 / (2.0 * this.focalLength.getValue());
    }

    @Override
    public double y2ndDerivativeValue(double t) {
        return 0.0;
    }

    @Override
    protected void drawFociAndDirectrix(VectorGraphics g, View view, Transform limits, double t) {
        double f = this.focalLength.getValue();
        Color saveColor = g.getColor();
        double width = Math.abs(limits.getXmax() - limits.getXmin());
        double crossSize = 3.0 * limits.getPixelWidth();
        g.setColor(Color.red);
        g.draw((Shape)new Line2D.Double(f - crossSize, -crossSize, f + crossSize, crossSize));
        g.draw((Shape)new Line2D.Double(f - crossSize, crossSize, f + crossSize, -crossSize));
        g.setColor(Color.blue);
        g.draw((Shape)new Line2D.Double(-f, limits.getYmin(), -f, limits.getYmax()));
        if (Double.isNaN(t)) {
            g.setColor(saveColor);
            return;
        }
        double x = t * t / (4.0 * f);
        double y = t;
        g.setColor(new Color(0, 150, 0));
        double dx = t / (2.0 * f);
        double dy = 1.0;
        g.draw((Shape)new Line2D.Double(x - width * dx, y - width * dy, x + width * dx, y + width * dy));
        g.setColor(Color.red);
        if (f > 0.0) {
            g.draw((Shape)new Line2D.Double(x, y, x + width, y));
        } else {
            g.draw((Shape)new Line2D.Double(x, y, x - width, y));
        }
        g.setColor(Color.magenta);
        g.draw((Shape)new Line2D.Double(x, y, -f, y));
        g.draw((Shape)new Line2D.Double(-f, y, f, 0.0));
        g.draw((Shape)new Line2D.Double(f, 0.0, x, y));
        view.drawString("F", f + limits.getPixelWidth(), 4.0 * limits.getPixelHeight());
        if (this.focalLength.getValue() > 0.0) {
            view.drawString("S", -f - 10.0 * limits.getPixelWidth(), y);
        } else {
            view.drawString("S", -f + 3.0 * limits.getPixelWidth(), y);
        }
        g.setColor(saveColor);
    }

    @Override
    public ActionList getActionsForView(final View view) {
        ActionList actions = super.getActionsForView(view);
        if (view == null) {
            return actions;
        }
        actions.add(null);
        actions.add(new AbstractActionVMM(I18n.tr("vmm3d.planecurve.parametric.Parabola.showNormalsWithMouse")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                view.getDisplay().installOneShotMouseTask(new ShowNormalsMouseTask(view));
            }
        });
        return actions;
    }

    private class NormalsThroughPoint
    extends Decoration {
        int x;
        int y;
        Line2D[] lines = new Line2D.Double[3];
        double[] params;
        Color darkGreen = new Color(0, 160, 0);

        private NormalsThroughPoint() {
        }

        void setPixel(int x, int y) {
            if (this.x == x && this.y == y) {
                return;
            }
            this.x = x;
            this.y = y;
            this.fireDecorationChangeEvent();
        }

        Complex[] solveCubic(double p, double q) {
            Complex[] roots = new Complex[3];
            double quarterDiscriminant = q * q / 4.0 - p * p * p;
            Complex halfDiscriminantSqrt = new Complex(quarterDiscriminant).integerRoot(2);
            Complex quadraticRoot = new Complex(q / 2.0).plus(halfDiscriminantSqrt);
            Complex xPlusV = quadraticRoot.integerRoot(3);
            Complex minusV = new Complex(p).dividedBy(xPlusV);
            roots[0] = xPlusV.plus(minusV);
            Complex w1 = Complex.polar(1.0, 2.0943951023931953);
            Complex w2 = Complex.polar(1.0, 4.1887902047863905);
            roots[1] = w1.times(xPlusV).plus(w2.times(minusV));
            roots[2] = w2.times(xPlusV).plus(w1.times(minusV));
            return roots;
        }

        @Override
        public void computeDrawData(View view, boolean needsRedraw, Transform previousLimits, Transform newLimits) {
            double xcoord = newLimits.getXmin() + (double)(this.x - newLimits.getX()) * newLimits.getPixelWidth();
            double ycoord = newLimits.getYmax() - (double)(this.y - newLimits.getY()) * newLimits.getPixelHeight();
            double normalLength = 10.0 * Math.abs(newLimits.getXmax() - newLimits.getXmin());
            double a = Parabola.this.focalLength.getValue();
            Complex[] roots = this.solveCubic(1.3333333333333333 * a * xcoord - 2.6666666666666665 * a * a, 8.0 * a * a * ycoord);
            for (int i = 0; i < 3; ++i) {
                if (Math.abs(roots[i].im) > 1.0E-5) {
                    this.lines[i] = null;
                    continue;
                }
                double x1 = Parabola.this.xValue(roots[i].re);
                double y1 = Parabola.this.yValue(roots[i].re);
                double dx = xcoord - x1;
                double dy = ycoord - y1;
                double length = Math.sqrt(dx * dx + dy * dy);
                this.lines[i] = new Line2D.Double(x1, y1, x1 + dx * normalLength / length, y1 + dy * normalLength / length);
            }
            this.params = (double[])(Math.abs(roots[0].im) > 1.0E-5 || Math.abs(roots[1].im) > 1.0E-5 || Math.abs(roots[2].im) > 1.0E-5 ? null : new double[]{roots[0].re, roots[1].re, roots[2].re});
        }

        @Override
        public void doDraw(VectorGraphics g, View view, Transform limits) {
            Color saveColor = g.getColor();
            if (this.lines[0] != null) {
                g.setColor(Color.red);
                g.draw((Shape)this.lines[0]);
            }
            if (this.lines[1] != null) {
                g.setColor(this.darkGreen);
                g.draw((Shape)this.lines[1]);
            }
            if (this.lines[2] != null) {
                g.setColor(Color.blue);
                g.draw((Shape)this.lines[2]);
            }
            if (this.params != null) {
                double scale = limits.getPixelWidth();
                if (Parabola.this.focalLength.getValue() < 0.0) {
                    scale = -scale;
                }
                double gap = limits.getPixelHeight();
                g.setColor(Color.red);
                g.draw((Shape)new Line2D.Double(-scale * 90.0, 0.0, -scale * 90.0, this.params[0]));
                g.setColor(this.darkGreen);
                g.draw((Shape)new Line2D.Double(-scale * 80.0, 0.0, -scale * 80.0, this.params[1]));
                g.setColor(Color.blue);
                g.draw((Shape)new Line2D.Double(-scale * 70.0, 0.0, -scale * 70.0, this.params[2]));
                double[] p = new double[]{Math.abs(this.params[0]), Math.abs(this.params[1]), Math.abs(this.params[2])};
                if (p[0] >= p[1] && p[0] >= p[2]) {
                    g.setColor(Color.red);
                    g.draw((Shape)new Line2D.Double(-scale * 150.0, 0.0, -scale * 150.0, p[0]));
                    g.setColor(this.darkGreen);
                    g.draw((Shape)new Line2D.Double(-scale * 145.0, 0.0, -scale * 145.0, p[1] - gap));
                    g.setColor(Color.blue);
                    g.draw((Shape)new Line2D.Double(-scale * 145.0, p[1] + gap, -scale * 145.0, p[1] + p[2]));
                } else if (p[1] >= p[0] && p[1] >= p[2]) {
                    g.setColor(this.darkGreen);
                    g.draw((Shape)new Line2D.Double(-scale * 150.0, 0.0, -scale * 150.0, p[1]));
                    g.setColor(Color.red);
                    g.draw((Shape)new Line2D.Double(-scale * 145.0, 0.0, -scale * 145.0, p[0] - gap));
                    g.setColor(Color.blue);
                    g.draw((Shape)new Line2D.Double(-scale * 145.0, p[0] + gap, -scale * 145.0, p[0] + p[2]));
                } else {
                    g.setColor(Color.blue);
                    g.draw((Shape)new Line2D.Double(-scale * 150.0, 0.0, -scale * 150.0, p[2]));
                    g.setColor(this.darkGreen);
                    g.draw((Shape)new Line2D.Double(-scale * 145.0, 0.0, -scale * 145.0, p[1] - gap));
                    g.setColor(Color.red);
                    g.draw((Shape)new Line2D.Double(-scale * 145.0, p[1] + gap, -scale * 145.0, p[1] + p[0]));
                }
            }
            g.setColor(saveColor);
        }
    }

    private class ShowNormalsMouseTask
    extends MouseTask {
        View view;
        NormalBundleDecoration backgroundDecoration;
        NormalsThroughPoint normals;
        boolean saveShowAxes;

        ShowNormalsMouseTask(View view) {
            this.normals = new NormalsThroughPoint();
            this.view = view;
        }

        @Override
        public void start(Display display, View view) {
            this.backgroundDecoration = new NormalBundleDecoration(Parabola.this);
            this.backgroundDecoration.setLayer(-2);
            this.backgroundDecoration.setNormalsColor(Color.lightGray);
            this.backgroundDecoration.setPointCount(Parabola.this.tResolution.getValue() + 1);
            this.backgroundDecoration.setEvoluteColor(new Color(0, 180, 180));
            this.backgroundDecoration.setShowEvolute(true);
            view.addDecoration(this.backgroundDecoration);
            this.saveShowAxes = view.getShowAxes();
            view.setShowAxes(true);
        }

        @Override
        public void finish(Display display, View view) {
            view.removeDecoration(this.backgroundDecoration);
            view.removeDecoration(this.normals);
            view.setShowAxes(this.saveShowAxes);
        }

        @Override
        public boolean doMouseDown(MouseEvent evt, Display display, View view, int width, int height) {
            this.normals = new NormalsThroughPoint();
            this.normals.setLayer(-1);
            this.normals.setPixel(evt.getX(), evt.getY());
            view.addDecoration(this.normals);
            return true;
        }

        @Override
        public void doMouseDrag(MouseEvent evt, Display display, View view, int width, int height) {
            this.normals.setPixel(evt.getX(), evt.getY());
        }

        @Override
        public Cursor getCursor(Display display, View view) {
            return Cursor.getPredefinedCursor(1);
        }
    }
}

