/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.planecurve.parametric;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.core.Decoration;
import vmm3d.core.Exhibit;
import vmm3d.core.Transform;
import vmm3d.core.VMMSave;
import vmm3d.core.View;
import vmm3d.planecurve.parametric.PlaneCurveParametric;

public class NormalBundleDecoration
extends Decoration {
    private PlaneCurveParametric curve;
    @VMMSave
    private int pointCt;
    private Line2D.Double[] unitNormals;
    private Line2D.Double[] evoluteNormals;
    private Line2D.Double[] lines;
    @VMMSave
    private boolean useUnitNormals = false;
    @VMMSave
    private boolean showEvolute = false;
    private boolean showEvoluteWithOsculatingCircle = false;
    @VMMSave
    private boolean showTwoParallelCurves = true;
    @VMMSave
    private double parallelCurveOffset = Double.NaN;
    @VMMSave
    private int osculatingCircleIndex = -1;
    private double maxNormalLength;
    @VMMSave
    private Color normalColor = Color.red;
    @VMMSave
    private Color evoluteColor = new Color(0, 200, 0);
    @VMMSave
    private Color osculatingCircleColor = Color.blue;
    @VMMSave
    private Color parallelCurveColor = new Color(60, 180, 180);
    @VMMSave
    private Color parallelCurveColor2 = new Color(200, 100, 100);

    public NormalBundleDecoration() {
    }

    public NormalBundleDecoration(PlaneCurveParametric curve) {
        this.curve = curve;
    }

    public PlaneCurveParametric getCurve() {
        return this.curve;
    }

    public void setCurve(PlaneCurveParametric c) {
        this.curve = c;
    }

    public void setPointCount(int pointCt) {
        if (pointCt < 0) {
            pointCt = 0;
        }
        if (this.pointCt != pointCt) {
            this.pointCt = pointCt;
            this.fireDecorationChangeEvent();
        }
    }

    public int getPointCount() {
        return this.pointCt;
    }

    public boolean getShowEvolute() {
        return this.showEvolute;
    }

    public void setShowEvolute(boolean show) {
        if (show != this.showEvolute) {
            this.showEvolute = show;
            this.fireDecorationChangeEvent();
        }
    }

    public double getParallelCurveOffset() {
        return this.parallelCurveOffset;
    }

    public void setParallelCurveOffset(double offset) {
        if (!(offset == this.parallelCurveOffset || Double.isNaN(offset) && Double.isNaN(this.parallelCurveOffset))) {
            this.parallelCurveOffset = offset;
            this.fireDecorationChangeEvent();
        }
    }

    public Color getNormalsColor() {
        return this.normalColor;
    }

    public void setNormalsColor(Color color) {
        if (color == null) {
            color = Color.red;
        }
        if (!color.equals(this.normalColor)) {
            this.normalColor = color;
            if (this.pointCt > 0) {
                this.fireDecorationChangeEvent();
            }
        }
    }

    public Color getEvoluteColor() {
        return this.evoluteColor;
    }

    public void setEvoluteColor(Color color) {
        if (color == null) {
            color = new Color(0, 200, 0);
        }
        if (!color.equals(this.evoluteColor)) {
            this.evoluteColor = color;
            if (this.showEvolute) {
                this.fireDecorationChangeEvent();
            }
        }
    }

    public Color getOsculatingCircleColor() {
        return this.osculatingCircleColor;
    }

    public void setOsculatingCircleColor(Color color) {
        if (color == null) {
            color = Color.blue;
        }
        if (!color.equals(this.osculatingCircleColor)) {
            this.osculatingCircleColor = color;
            if (this.osculatingCircleIndex >= 0) {
                this.fireDecorationChangeEvent();
            }
        }
    }

    public Color getParallelCurveColor() {
        return this.parallelCurveColor;
    }

    public void setParallelCurveColor(Color color) {
        if (color == null) {
            color = new Color(60, 180, 180);
        }
        if (!color.equals(this.parallelCurveColor)) {
            this.parallelCurveColor = color;
            if (!Double.isNaN(this.parallelCurveOffset)) {
                this.fireDecorationChangeEvent();
            }
        }
    }

    public Color getParallelCurveColor2() {
        return this.parallelCurveColor;
    }

    public void setParallelCurveColor2(Color color) {
        if (color == null) {
            color = new Color(200, 100, 100);
        }
        if (!color.equals(this.parallelCurveColor2)) {
            this.parallelCurveColor2 = color;
            if (!Double.isNaN(this.parallelCurveOffset) && this.showTwoParallelCurves) {
                this.fireDecorationChangeEvent();
            }
        }
    }

    public boolean getShowTwoParallelCurves() {
        return this.showTwoParallelCurves;
    }

    public void setShowTwoParallelCurves(boolean show) {
        if (show != this.showTwoParallelCurves) {
            this.showTwoParallelCurves = show;
            if (!Double.isNaN(this.parallelCurveOffset)) {
                this.fireDecorationChangeEvent();
            }
        }
    }

    public boolean getUseUnitNormals() {
        return this.useUnitNormals;
    }

    public int getOsculatingCircleIndex() {
        return this.osculatingCircleIndex;
    }

    public void setOsculatingCircleIndex(int i) {
        this.setOsculatingCircleIndex(i, false);
    }

    public void setOsculatingCircleIndex(int i, boolean showEvoluteSoFar) {
        if (i < 0) {
            i = -1;
        }
        if (i != this.osculatingCircleIndex || showEvoluteSoFar != this.showEvoluteWithOsculatingCircle) {
            this.osculatingCircleIndex = i;
            this.showEvoluteWithOsculatingCircle = showEvoluteSoFar;
            this.fireDecorationChangeEvent();
        }
    }

    public void setUseUnitNormals(boolean useUnitNormals) {
        if (useUnitNormals != this.useUnitNormals) {
            this.useUnitNormals = useUnitNormals;
            this.lines = useUnitNormals ? this.unitNormals : this.evoluteNormals;
            this.fireDecorationChangeEvent();
        }
    }

    public Line2D[] getUnitNormals() {
        return this.unitNormals;
    }

    @Override
    public void computeDrawData(View view, boolean exhibitNeedsRedraw, Transform previousLimits, Transform newLimits) {
        Exhibit c;
        if (!exhibitNeedsRedraw && !this.decorationNeedsRedraw) {
            return;
        }
        if (this.curve == null && view != null && (c = view.getExhibit()) instanceof PlaneCurveParametric) {
            this.curve = (PlaneCurveParametric)c;
        }
        int points = this.curve.getTResolution();
        this.unitNormals = new Line2D.Double[points + 1];
        this.evoluteNormals = new Line2D.Double[points + 1];
        this.maxNormalLength = newLimits.getPixelWidth() * 5000.0;
        for (int i = 0; i <= points; ++i) {
            double t = this.curve.getT(i);
            double x = this.curve.xValue(t);
            double y = this.curve.yValue(t);
            double dx = this.curve.xDerivativeValue(t);
            double dy = this.curve.yDerivativeValue(t);
            double dx2 = this.curve.x2ndDerivativeValue(t);
            double dy2 = this.curve.y2ndDerivativeValue(t);
            double length = Math.sqrt(dx * dx + dy * dy);
            double unit_dx = dx / length;
            double unit_dy = dy / length;
            if (Double.isNaN(x) || Double.isInfinite(x) || Double.isNaN(y) || Double.isInfinite(y) || Double.isNaN(unit_dx) || Double.isInfinite(unit_dx) || Double.isNaN(unit_dy) || Double.isInfinite(unit_dy)) continue;
            this.unitNormals[i] = new Line2D.Double(x, y, x - unit_dy, y + unit_dx);
            if (Double.isNaN(dx2) || Double.isInfinite(dx2) || Double.isNaN(dy2) || Double.isInfinite(dy2)) continue;
            double curvature = (dx * dy2 - dy * dx2) / (length * length * length);
            double radius = 1.0 / curvature;
            if (Math.abs(radius) > this.maxNormalLength) {
                radius = radius > 0.0 ? this.maxNormalLength : -this.maxNormalLength;
            }
            this.evoluteNormals[i] = new Line2D.Double(x, y, x - unit_dy * radius, y + unit_dx * radius);
        }
        this.lines = this.useUnitNormals ? this.unitNormals : this.evoluteNormals;
        this.decorationNeedsRedraw = false;
    }

    @Override
    public void doDraw(VectorGraphics g, View view, Transform limits) {
        int oci;
        Color saveColor = g.getColor();
        double maxJump = Math.max(limits.getXmax() - limits.getXmin(), limits.getYmax() - limits.getYmin()) / 4.0;
        int pointsToDraw = this.pointCt;
        if (pointsToDraw > this.curve.getTResolution()) {
            pointsToDraw = this.curve.getTResolution() + 1;
        }
        if (pointsToDraw > 0) {
            g.setColor(this.normalColor);
            for (int i = 0; i < pointsToDraw; ++i) {
                if (this.lines[i] == null) continue;
                g.draw((Shape)this.lines[i]);
            }
        }
        if ((oci = this.osculatingCircleIndex) > this.curve.getTResolution()) {
            oci = this.curve.getTResolution();
        }
        if (this.showEvolute || oci >= 0) {
            g.setColor(this.evoluteColor);
            double maxLength = 5000.0 * limits.getPixelWidth();
            double x = Double.NaN;
            double y = Double.NaN;
            int points = oci >= 0 ? oci + 1 : this.evoluteNormals.length;
            for (int i = 0; i < points; ++i) {
                double x1;
                double y1;
                double length = 0.0;
                if (this.evoluteNormals[i] == null) {
                    y1 = Double.NaN;
                    x1 = Double.NaN;
                } else {
                    x1 = this.evoluteNormals[i].getX2();
                    y1 = this.evoluteNormals[i].getY2();
                    length = Math.sqrt(Math.pow(x1 - this.evoluteNormals[i].getX1(), 2.0) + Math.pow(y1 - this.evoluteNormals[i].getY1(), 2.0));
                }
                if (!Double.isNaN(x) && !Double.isNaN(y) && !Double.isNaN(x1) && !Double.isNaN(y1) && Math.sqrt((x - x1) * (x - x1) + (y - y1) * (y - y1)) < maxJump && length <= maxLength) {
                    g.draw((Shape)new Line2D.Double(x, y, x1, y1));
                }
                x = x1;
                y = y1;
            }
        }
        if (oci >= 0 && this.evoluteNormals[oci] != null) {
            g.setColor(this.osculatingCircleColor);
            Line2D.Double v = this.evoluteNormals[oci];
            g.draw((Shape)v);
            double x = v.getX1();
            double y = v.getY1();
            double dx = v.getX2() - v.getX1();
            double dy = v.getY2() - v.getY1();
            double radius = Math.sqrt(dx * dx + dy * dy);
            g.draw((Shape)new Ellipse2D.Double(x + dx - radius, y + dy - radius, 2.0 * radius, 2.0 * radius));
        }
        if (!Double.isNaN(this.parallelCurveOffset) && !Double.isInfinite(this.parallelCurveOffset)) {
            double x1;
            int i;
            g.setColor(this.parallelCurveColor);
            double x = Double.NaN;
            double y = Double.NaN;
            for (i = 0; i < this.unitNormals.length; ++i) {
                double y1;
                if (this.unitNormals[i] == null) {
                    y1 = Double.NaN;
                    x1 = Double.NaN;
                } else {
                    Line2D.Double v = this.unitNormals[i];
                    x1 = v.getX1() + this.parallelCurveOffset * (v.getX2() - v.getX1());
                    y1 = v.getY1() + this.parallelCurveOffset * (v.getY2() - v.getY1());
                }
                if (!(Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(x1) || Double.isNaN(y1) || !(Math.abs(x - x1) + Math.abs(y - y1) <= maxJump))) {
                    g.draw((Shape)new Line2D.Double(x, y, x1, y1));
                }
                x = x1;
                y = y1;
            }
            if (this.showTwoParallelCurves) {
                g.setColor(this.parallelCurveColor2);
                x = Double.NaN;
                y = Double.NaN;
                for (i = 0; i < this.unitNormals.length; ++i) {
                    double y1;
                    if (this.unitNormals[i] == null) {
                        y1 = Double.NaN;
                        x1 = Double.NaN;
                    } else {
                        Line2D.Double v = this.unitNormals[i];
                        x1 = v.getX1() - this.parallelCurveOffset * (v.getX2() - v.getX1());
                        y1 = v.getY1() - this.parallelCurveOffset * (v.getY2() - v.getY1());
                    }
                    if (!(Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(x1) || Double.isNaN(y1) || !(Math.abs(x - x1) + Math.abs(y - y1) <= maxJump))) {
                        g.draw((Shape)new Line2D.Double(x, y, x1, y1));
                    }
                    x = x1;
                    y = y1;
                }
            }
        }
        g.setColor(saveColor);
    }
}

