/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.planecurve.parametric;

import vmm3d.core.RealParamAnimateable;
import vmm3d.planecurve.parametric.PlaneCurveParametric;

public class Limacon
extends PlaneCurveParametric {
    private RealParamAnimateable aa;
    private RealParamAnimateable bb;

    public Limacon() {
        this.tResolution.setValueAndDefault(200);
        this.aa = new RealParamAnimateable("aa", 0.5, 1.0, 1.0);
        this.bb = new RealParamAnimateable("bb", 0.5, 2.0, 0.5);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.tmin.setValueAndDefaultFromString("0");
        this.tmax.setValueAndDefaultFromString("2*pi");
        this.setDefaultWindow(-1.25, 1.25, -1.25, 1.25);
    }

    private static double sin(double t) {
        return Math.sin(t);
    }

    private static double cos(double t) {
        return Math.cos(t);
    }

    @Override
    public double xValue(double t) {
        double AA = this.aa.getValue();
        double BB = this.bb.getValue();
        return AA - (2.0 * AA * Limacon.cos(t - Math.PI) + BB) * Limacon.cos(t - Math.PI);
    }

    @Override
    public double yValue(double t) {
        double AA = this.aa.getValue();
        double BB = this.bb.getValue();
        return (2.0 * AA * Limacon.cos(t - Math.PI) + BB) * Limacon.sin(t - Math.PI);
    }
}

