/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.planecurve.parametric;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Line2D;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.Transform;
import vmm3d.core.View;
import vmm3d.planecurve.parametric.DecoratedCurve;

public class Convex
extends DecoratedCurve {
    private RealParamAnimateable aa;
    private RealParamAnimateable bb;
    private RealParamAnimateable cc;
    private RealParamAnimateable dd;
    private RealParamAnimateable ee;
    private RealParamAnimateable ff;
    private RealParamAnimateable phase;
    private double a;
    private double b;
    private double c;
    private double d;
    private double e;
    private double f;
    private double ph;

    public Convex() {
        this.tResolution.setValueAndDefault(300);
        this.aa = new RealParamAnimateable("vmm3d.planecurve.parametric.Convex.aa", 15.0, 15.0, 15.0);
        this.bb = new RealParamAnimateable("vmm3d.planecurve.parametric.Convex.bb", 0.0, 0.0, 0.0);
        this.cc = new RealParamAnimateable("vmm3d.planecurve.parametric.Convex.cc", 0.0, 0.0, 0.0);
        this.dd = new RealParamAnimateable("vmm3d.planecurve.parametric.Convex.dd", 1.5, 1.5, 0.0);
        this.ee = new RealParamAnimateable("vmm3d.planecurve.parametric.Convex.ee", 0.0, 0.0, 0.0);
        this.ff = new RealParamAnimateable("vmm3d.planecurve.parametric.Convex.ff", 0.0, 0.0, 0.6);
        this.phase = new RealParamAnimateable("vmm3d.planecurve.parametric.Convex.phase", 0.0, 0.0, 0.0);
        this.addParameter(this.phase);
        this.addParameter(this.ff);
        this.addParameter(this.ee);
        this.addParameter(this.dd);
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
        this.tmin.setValueAndDefaultFromString("0");
        this.tmax.setValueAndDefaultFromString("2*pi");
        this.setDefaultWindow(-18.0, 18.0, -18.0, 18.0);
    }

    private void setConstants() {
        this.a = this.aa.getValue();
        this.b = this.bb.getValue();
        this.c = this.cc.getValue();
        this.d = this.dd.getValue();
        this.e = this.ee.getValue();
        this.f = this.ff.getValue();
        this.ph = this.phase.getValue();
    }

    private static double sin(double t) {
        return Math.sin(t);
    }

    private static double cos(double t) {
        return Math.cos(t);
    }

    private double supportFunction(double t) {
        this.setConstants();
        return this.a + this.b * Convex.cos(t) + this.c * Convex.cos(2.0 * t) + this.d * Convex.cos(3.0 * t) + this.e * Convex.cos(4.0 * t) + this.f * Convex.cos(5.0 * t);
    }

    private double supportDerivative(double t) {
        return -this.b * Convex.sin(t) - 2.0 * this.c * Convex.sin(2.0 * t) - 3.0 * this.d * Convex.sin(3.0 * t) - 4.0 * this.e * Convex.sin(4.0 * t) - 5.0 * this.f * Convex.sin(5.0 * t);
    }

    @Override
    public double xValue(double t) {
        return this.supportFunction(t) * Convex.cos(t - this.ph) - this.supportDerivative(t) * Convex.sin(t - this.ph);
    }

    @Override
    public double yValue(double t) {
        return this.supportFunction(t) * Convex.sin(t - this.ph) + this.supportDerivative(t) * Convex.cos(t - this.ph) + this.supportFunction(this.ph - 1.5707963267948966) - this.a;
    }

    @Override
    protected void drawNeededStuff(VectorGraphics g, View view, Transform limits, double t) {
        Color saveColor = g.getColor();
        g.setColor(Color.lightGray);
        view.setStrokeSizeMultiplier(6);
        double h = this.a * 1.02;
        g.draw((Shape)new Line2D.Double(-40.0, -h, 40.0, -h));
        g.draw((Shape)new Line2D.Double(-40.0, h, 40.0, h));
        g.setColor(saveColor);
        view.setStrokeSizeMultiplier(4);
        this.setStrokeSize(4);
        this.setWantedColor(saveColor);
        this.phase.setValue(t);
    }
}

