/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.planecurve.parametric;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.Transform;
import vmm3d.core.View;
import vmm3d.planecurve.parametric.DecoratedCurve;

public class Cissoid
extends DecoratedCurve {
    private RealParamAnimateable aa;
    private int pointCount;
    double a;
    double xa;
    double ya;
    double xco;
    double yco;
    double aux;
    double rotx;
    double roty;
    double tx;
    double ty;
    double nn;
    double ex;
    double ey;
    double dt;

    public Cissoid() {
        this.tResolution.setValueAndDefault(395);
        this.aa = new RealParamAnimateable("aa", 1.0, 2.0, 0.5);
        this.addParameter(this.aa);
        this.tmin.setValueAndDefault(-4.5);
        this.tmax.setValueAndDefaultFromString("4.5");
        this.setDefaultWindow(-4.0, 4.0, -4.0, 4.0);
        this.pointCount = 12000;
        this.randomSquare = this.fillRandomSquare(this.pointCount);
        this.movingSquare = this.initializeMovingSquare(this.pointCount);
    }

    @Override
    public double xValue(double t) {
        return t * this.yValue(t);
    }

    @Override
    public double yValue(double t) {
        this.a = this.aa.getValue();
        return 2.0 * this.a * t * t / (1.0 + t * t);
    }

    @Override
    public View getDefaultView() {
        DecoratedCurve.MMOView view = (DecoratedCurve.MMOView)super.getDefaultView();
        view.simplifyActionMenu = false;
        view.setUseCloud(false);
        return view;
    }

    private void abbreviations(double t) {
        this.a = this.aa.getValue();
        this.xa = this.xValue(t);
        this.ya = this.yValue(t);
        this.aux = Math.sqrt(this.ya * (2.0 * this.a - this.ya));
        this.xco = this.xa - Math.signum(this.xa) * this.aux;
        this.yco = 2.0 * this.ya - this.a;
        this.rotx = this.xa + Math.signum(this.xa) * this.aux;
        this.roty = -this.a - this.rotx * this.xco / (this.yco + this.a);
        this.ex = this.xco - this.rotx;
        this.ey = this.yco - this.a;
        this.tx = -this.roty + this.ya;
        this.ty = this.rotx - this.xa;
        this.dt = (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
    }

    @Override
    protected void drawNeededStuff(VectorGraphics g, View view, Transform limits, double t) {
        DecoratedCurve.MMOView myView = (DecoratedCurve.MMOView)view;
        this.setStrokeSize(2);
        Color saveColor = g.getColor();
        this.abbreviations(t);
        g.setColor(Color.red);
        myView.setStrokeSizeMultiplier(1);
        g.draw((Shape)new Line2D.Double(-10.0, this.a, 10.0, this.a));
        g.draw((Shape)new Line2D.Double(0.0, -this.a, -10.0 * this.xco / (this.yco + this.a), -10.0));
        myView.setStrokeSizeMultiplier(3);
        g.draw((Shape)new Line2D.Double(0.0, -this.a, this.xco, this.yco));
        g.draw((Shape)new Line2D.Double(this.xco, this.yco, this.rotx, this.a));
        myView.setStrokeSizeMultiplier(2);
        g.draw((Shape)new Ellipse2D.Double(this.rotx - 0.04, this.a - 0.04, 0.08, 0.08));
        g.draw((Shape)new Ellipse2D.Double(-0.06, -this.a - 0.06, 0.12, 0.12));
        g.setColor(Color.green);
        g.draw((Shape)new Ellipse2D.Double(this.xa - 0.06, this.ya - 0.06, 0.12, 0.12));
        if (myView.getUseCloud()) {
            myView.setStrokeSizeMultiplier(1);
            g.draw((Shape)new Line2D.Double(this.rotx, this.roty, this.rotx, this.a));
            g.draw((Shape)new Line2D.Double(this.rotx, this.roty, 0.0, -this.a));
            g.setColor(Color.blue);
            g.draw((Shape)new Line2D.Double(this.rotx, this.roty, this.xa, this.ya));
            g.draw((Shape)new Line2D.Double(this.xa + this.tx, this.ya + this.ty, this.xa - this.tx, this.ya - this.ty));
            g.draw((Shape)new Ellipse2D.Double(this.rotx - 0.06, this.roty - 0.06, 0.12, 0.12));
            this.abbreviations(t - this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, this.xa, this.ya, this.ex, this.ey, 3.0 * this.a);
            myView.drawPixels(this.movingSquare, 0, this.pointCount);
            this.abbreviations(t + this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, this.xa, this.ya, this.ex, this.ey, 3.0 * this.a);
            myView.drawPixels(this.movingSquare, 0, this.pointCount);
        }
        g.setColor(saveColor);
    }
}

