/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core3D;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.freehep.graphics2d.VectorGraphics;

public class StereoComposite {
    private int width;
    private int height;
    private BufferedImage view;
    private BufferedImage leftEyeView;
    private BufferedImage rightEyeView;
    private int chunkSize;
    private int[] leftSamples;
    private int[] rightSamples;
    private int[] viewInts;

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.chunkSize = 10000 / width;
        if (this.chunkSize < 1) {
            this.chunkSize = 1;
        }
        this.rightEyeView = null;
        this.leftEyeView = null;
        this.view = null;
        this.viewInts = null;
        this.rightSamples = null;
        this.leftSamples = null;
        try {
            this.leftEyeView = new BufferedImage(width, height, 10);
            this.rightEyeView = new BufferedImage(width, height, 10);
            this.view = new BufferedImage(width, height, 1);
            this.leftSamples = new int[this.chunkSize * width];
            this.rightSamples = new int[this.chunkSize * width];
        }
        catch (OutOfMemoryError e) {
            this.rightEyeView = null;
            this.leftEyeView = null;
            this.view = null;
            this.rightSamples = null;
            this.leftSamples = null;
            throw e;
        }
        WritableRaster viewRaster = this.view.getRaster();
        DataBufferInt viewData = (DataBufferInt)viewRaster.getDataBuffer();
        this.viewInts = viewData.getData();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void releaseMemory() {
        this.rightEyeView = null;
        this.leftEyeView = null;
        this.view = null;
        this.viewInts = null;
        this.rightSamples = null;
        this.leftSamples = null;
        this.height = 0;
        this.width = 0;
    }

    public VectorGraphics getLeftEyeGraphics() {
        return this.leftEyeView == null ? null : VectorGraphics.create((Graphics)this.leftEyeView.getGraphics());
    }

    public VectorGraphics getRightEyeGraphics() {
        return this.rightEyeView == null ? null : VectorGraphics.create((Graphics)this.rightEyeView.getGraphics());
    }

    public BufferedImage getLeftEyeImage() {
        return this.leftEyeView;
    }

    public BufferedImage getRightEyeImage() {
        return this.rightEyeView;
    }

    public BufferedImage getImage() {
        return this.view;
    }

    public void compose() {
        Raster leftRaster = this.leftEyeView.getData();
        Raster rightRaster = this.rightEyeView.getData();
        for (int row = 0; row < this.height; row += this.chunkSize) {
            int rowCount = this.chunkSize;
            if (row + rowCount > this.height) {
                rowCount = this.height - row;
            }
            int sampleCount = rowCount * this.width;
            int firstIndex = row * this.width;
            leftRaster.getSamples(0, row, this.width, rowCount, 0, this.leftSamples);
            rightRaster.getSamples(0, row, this.width, rowCount, 0, this.rightSamples);
            for (int i = 0; i < sampleCount; ++i) {
                this.viewInts[i + firstIndex] = (this.rightSamples[i] << 16) + (this.leftSamples[i] << 8);
            }
        }
    }
}

