/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core3D;

import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import vmm3d.core.I18n;
import vmm3d.core.ParameterInput;
import vmm3d.core.RealParam;
import vmm3d.core.SettingsDialog;
import vmm3d.core3D.Exhibit3D;
import vmm3d.core3D.Vector3D;
import vmm3d.core3D.View3D;

public class SetViewpointDialog
extends SettingsDialog {
    private View3D view;
    private RealParam viewX;
    private RealParam viewY;
    private RealParam viewZ;
    private RealParam upX;
    private RealParam upY;
    private RealParam upZ;
    private RealParam clipdist;
    private ParameterInput[] inputs;
    private JRadioButton useDefaultClip;
    private JRadioButton useCustomClip;

    public static void showDialog(View3D view) {
        new SetViewpointDialog(view).setVisible(true);
    }

    private SetViewpointDialog(View3D view) {
        super(view.getDisplay(), I18n.tr("vmm3d.core3D.commands.SetViewpoint"));
        this.view = view;
        Vector3D viewpoint = view.getViewPoint();
        Vector3D viewup = view.getViewUp();
        Vector3D defaultViewpoint = viewpoint;
        Vector3D defaultViewup = viewup;
        if (view.getExhibit() != null && view.getExhibit() instanceof Exhibit3D) {
            defaultViewpoint = ((Exhibit3D)view.getExhibit()).getDefaultViewpoint();
            defaultViewup = Vector3D.UNIT_Z;
        }
        this.viewX = new RealParam(I18n.tr("vmm3d.core3D.SetViewpointDialog.ViewpointComponent", "x"), viewpoint.x);
        this.viewX.setDefaultValue(defaultViewpoint.x);
        this.viewY = new RealParam(I18n.tr("vmm3d.core3D.SetViewpointDialog.ViewpointComponent", "y"), viewpoint.y);
        this.viewY.setDefaultValue(defaultViewpoint.y);
        this.viewZ = new RealParam(I18n.tr("vmm3d.core3D.SetViewpointDialog.ViewpointComponent", "z"), viewpoint.z);
        this.viewZ.setDefaultValue(defaultViewpoint.z);
        this.upX = new RealParam(I18n.tr("vmm3d.core3D.SetViewpointDialog.UpDirectionComponent", "x"), viewup.x);
        this.upX.setDefaultValue(defaultViewup.x);
        this.upY = new RealParam(I18n.tr("vmm3d.core3D.SetViewpointDialog.UpDirectionComponent", "y"), viewup.y);
        this.upY.setDefaultValue(defaultViewup.y);
        this.upZ = new RealParam(I18n.tr("vmm3d.core3D.SetViewpointDialog.UpDirectionComponent", "z"), viewup.z);
        this.upZ.setDefaultValue(defaultViewup.z);
        this.clipdist = new RealParam(I18n.tr("vmm3d.core3D.SetViewpointDialog.ClipDistance"), 0.0);
        this.clipdist.setMinimumValueForInput(Double.MIN_VALUE);
        this.inputs = new ParameterInput[7];
        this.inputs[0] = new ParameterInput(this.viewX);
        this.inputs[1] = new ParameterInput(this.viewY);
        this.inputs[2] = new ParameterInput(this.viewZ);
        this.inputs[3] = new ParameterInput(this.upX);
        this.inputs[4] = new ParameterInput(this.upY);
        this.inputs[5] = new ParameterInput(this.upZ);
        this.inputs[6] = new ParameterInput(this.clipdist);
        this.inputs[6].setEditable(false);
        this.inputs[6].setEnabled(false);
        for (int i = 0; i < 7; ++i) {
            this.inputs[i].setColumns(7);
        }
        Box panel = Box.createVerticalBox();
        panel.add(Box.createVerticalStrut(8));
        JPanel top = new JPanel();
        top.setLayout(new FlowLayout(2));
        JPanel bottom = new JPanel();
        bottom.setLayout(new FlowLayout(2));
        panel.add(top);
        panel.add(Box.createVerticalStrut(10));
        panel.add(bottom);
        top.add(new JLabel(I18n.tr("vmm3d.core3D.SetViewpointDialog.ViewFrom")));
        top.add(new JLabel(" ( "));
        top.add(this.inputs[0]);
        top.add(new JLabel(" , "));
        top.add(this.inputs[1]);
        top.add(new JLabel(" , "));
        top.add(this.inputs[2]);
        top.add(new JLabel(" ) "));
        bottom.add(new JLabel(I18n.tr("vmm3d.core3D.SetViewpointDialog.UpDirection")));
        bottom.add(new JLabel(" ( "));
        bottom.add(this.inputs[3]);
        bottom.add(new JLabel(" , "));
        bottom.add(this.inputs[4]);
        bottom.add(new JLabel(" , "));
        bottom.add(this.inputs[5]);
        bottom.add(new JLabel(" ) "));
        panel.add(Box.createVerticalStrut(20));
        JLabel clipLabel = new JLabel(I18n.tr("vmm3d.core3D.SetViewpointDialog.ClipDistance") + ":");
        panel.add(clipLabel);
        ButtonGroup group = new ButtonGroup();
        this.useDefaultClip = new JRadioButton(I18n.tr("vmm3d.core3D.SetViewpointDialog.UseDefaultClip"));
        this.useCustomClip = new JRadioButton(I18n.tr("vmm3d.core3D.SetViewpointDialog.UseCustomClip") + ":");
        group.add(this.useDefaultClip);
        group.add(this.useCustomClip);
        this.useDefaultClip.setSelected(true);
        this.useCustomClip.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean custom = SetViewpointDialog.this.useCustomClip.isSelected();
                SetViewpointDialog.this.inputs[6].setEditable(custom);
                SetViewpointDialog.this.inputs[6].setEnabled(custom);
                if (custom) {
                    SetViewpointDialog.this.inputs[6].selectAll();
                    SetViewpointDialog.this.inputs[6].requestFocus();
                }
            }
        });
        JPanel def = new JPanel();
        def.setLayout(new FlowLayout(0));
        def.add(Box.createHorizontalStrut(30));
        def.add(this.useDefaultClip);
        panel.add(def);
        JPanel cus = new JPanel();
        cus.setLayout(new FlowLayout(0));
        cus.add(Box.createHorizontalStrut(30));
        cus.add(this.useCustomClip);
        cus.add(Box.createHorizontalStrut(15));
        cus.add(this.inputs[6]);
        panel.add(cus);
        top.setAlignmentX(0.0f);
        bottom.setAlignmentX(0.0f);
        clipLabel.setAlignmentX(0.0f);
        def.setAlignmentX(0.0f);
        cus.setAlignmentX(0.0f);
        this.addInputPanel(panel);
    }

    @Override
    protected boolean doOK() {
        String error;
        int i;
        for (i = 0; i < 6; ++i) {
            String error2 = this.inputs[i].checkContents();
            if (error2 == null) continue;
            JOptionPane.showMessageDialog(this, error2, I18n.tr("vmm3d.core.SettingsDialog.errorTitle"), 0);
            return false;
        }
        if (this.useCustomClip.isSelected() && (error = this.inputs[6].checkContents()) != null) {
            JOptionPane.showMessageDialog(this, error, I18n.tr("vmm3d.core.SettingsDialog.errorTitle"), 0);
            return false;
        }
        for (i = 0; i < 6; ++i) {
            this.inputs[i].setValueFromContents();
        }
        Vector3D newView = new Vector3D(this.viewX.getValue(), this.viewY.getValue(), this.viewZ.getValue());
        if (newView.norm() < 1.0E-10) {
            JOptionPane.showMessageDialog(this, I18n.tr("vmm3d.core3D.SetViewpointDialog.BadViewpointError"), I18n.tr("vmm3d.core.SettingsDialog.errorTitle"), 0);
            return false;
        }
        this.view.setViewPoint(newView);
        this.view.setViewUp(new Vector3D(this.upX.getValue(), this.upY.getValue(), this.upZ.getValue()));
        if (this.useCustomClip.isSelected() && this.view.getTransform3D() != null) {
            this.inputs[6].setValueFromContents();
            this.view.getTransform3D().setClipDistance(this.clipdist.getValue());
        }
        return true;
    }

    @Override
    protected void doDefaults() {
        for (int i = 0; i < 6; ++i) {
            this.inputs[i].defaultVal();
        }
        this.useDefaultClip.setSelected(true);
    }
}

