/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core3D;

import java.awt.Color;
import java.util.Random;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.core.Decoration;
import vmm3d.core.Transform;
import vmm3d.core.VMMSave;
import vmm3d.core.View;
import vmm3d.core3D.Vector3D;
import vmm3d.core3D.View3D;

public abstract class DotCloudSurface
extends Decoration {
    @VMMSave
    private int dotCount = 10000;
    @VMMSave
    private Color color = Color.GRAY;
    private Vector3D[] points;

    protected abstract Vector3D makeRandomPixel(Random var1);

    public void setDotCount(int count) {
        this.dotCount = count;
        this.forceRedraw();
    }

    public int getDotCount() {
        return this.dotCount;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color == null ? Color.GRAY : color;
    }

    @Override
    public void computeDrawData(View view, boolean exhibitNeedsRedraw, Transform previousTransform, Transform newTransform) {
        if (this.points == null || exhibitNeedsRedraw || this.decorationNeedsRedraw) {
            this.points = new Vector3D[this.dotCount];
            Random rand = new Random(42L);
            for (int i = 0; i < this.points.length; ++i) {
                this.points[i] = this.makeRandomPixel(rand);
            }
        }
    }

    @Override
    public void doDraw(VectorGraphics g, View view, Transform transform) {
        View3D view3D = (View3D)view;
        Color saveColor = g.getColor();
        if (view3D.getViewStyle() == 1) {
            g.setColor(Color.WHITE);
        } else {
            g.setColor(this.color);
        }
        view3D.drawPixels(this.points);
        g.setColor(saveColor);
    }
}

