/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import java.util.ArrayList;
import vmm3d.core.Animateable;
import vmm3d.core.Complex;
import vmm3d.core.ComplexParam;
import vmm3d.core.ComplexParamAnimateable;
import vmm3d.core.IntegerParam;
import vmm3d.core.Parameter;
import vmm3d.core.RealParam;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.TimerAnimation;

public class BasicAnimator
extends TimerAnimation {
    private ArrayList<Animateable> animatedItems = new ArrayList();
    private ArrayList<Object[]> customLimitAnimatedParameters = null;
    private ArrayList<Object[]> initialParameterValues;
    private boolean restoreParameterValues = true;

    public BasicAnimator() {
        this((Animateable[])null, 100, 50);
    }

    public BasicAnimator(int frames) {
        this((Animateable[])null, frames, 50);
    }

    public BasicAnimator(Animateable item) {
        this(new Animateable[]{item}, 100, 50);
    }

    public BasicAnimator(Animateable item, int frames, int millisecondsPerFrame) {
        this(new Animateable[]{item}, frames, millisecondsPerFrame);
    }

    public BasicAnimator(Animateable[] items, int frames, int millisecondsPerFrame) {
        super(frames, millisecondsPerFrame);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                this.animatedItems.add(items[i]);
            }
        }
    }

    public boolean getRestoreParameterValues() {
        return this.restoreParameterValues;
    }

    public void setRestoreParameterValues(boolean restoreParameterValues) {
        this.restoreParameterValues = restoreParameterValues;
    }

    public synchronized void addAnimatedItem(Animateable item) {
        if (item != null && !this.animatedItems.contains(item)) {
            this.animatedItems.add(item);
        }
    }

    public synchronized void addWithCustomValue(IntegerParam item, int value) {
        if (item == null) {
            return;
        }
        if (this.customLimitAnimatedParameters == null) {
            this.customLimitAnimatedParameters = new ArrayList();
        }
        this.customLimitAnimatedParameters.add(new Object[]{item, value});
    }

    public synchronized void addWithCustomValue(RealParam item, double value) {
        if (item == null) {
            return;
        }
        if (this.customLimitAnimatedParameters == null) {
            this.customLimitAnimatedParameters = new ArrayList();
        }
        this.customLimitAnimatedParameters.add(new Object[]{item, value});
    }

    public synchronized void addWithCustomValue(ComplexParam item, Complex value) {
        if (item == null) {
            return;
        }
        if (this.customLimitAnimatedParameters == null) {
            this.customLimitAnimatedParameters = new ArrayList();
        }
        if (value == null) {
            value = new Complex();
        }
        this.customLimitAnimatedParameters.add(new Object[]{item, value});
    }

    public synchronized void addWithCustomLimits(RealParamAnimateable item, double start, double end) {
        if (item == null) {
            return;
        }
        if (this.customLimitAnimatedParameters == null) {
            this.customLimitAnimatedParameters = new ArrayList();
        }
        this.customLimitAnimatedParameters.add(new Object[]{item, start, end});
    }

    public synchronized void addWithCustomLimits(ComplexParamAnimateable item, Complex start, Complex end) {
        if (item == null) {
            return;
        }
        if (start == null) {
            start = new Complex();
        }
        if (end == null) {
            end = new Complex();
        }
        if (this.customLimitAnimatedParameters == null) {
            this.customLimitAnimatedParameters = new ArrayList();
        }
        this.customLimitAnimatedParameters.add(new Object[]{item, start, end});
    }

    @Override
    public final synchronized void start() {
        if (this.isRunning()) {
            this.cancel();
        }
        this.initialParameterValues = null;
        if (this.restoreParameterValues) {
            Parameter p;
            this.initialParameterValues = new ArrayList();
            for (Animateable animateable : this.animatedItems) {
                if (!(animateable instanceof Parameter)) continue;
                p = (Parameter)((Object)animateable);
                this.initialParameterValues.add(new Object[]{p, p.getValueObject()});
            }
            if (this.customLimitAnimatedParameters != null) {
                for (Object[] objectArray : this.customLimitAnimatedParameters) {
                    p = (Parameter)objectArray[0];
                    this.initialParameterValues.add(new Object[]{p, p.getValueObject()});
                }
            }
        }
        super.start();
    }

    @Override
    public final synchronized void cancel() {
        if (this.initialParameterValues != null) {
            for (Object[] info : this.initialParameterValues) {
                Parameter p = (Parameter)info[0];
                p.setValueObject(info[1]);
            }
            this.initialParameterValues = null;
        }
        super.cancel();
    }

    @Override
    protected void drawFrame() {
        if (this.animatedItems.size() == 0 && this.customLimitAnimatedParameters == null) {
            this.cancel();
        }
        double fractionComplete = (double)this.frameNumber / (double)this.getFrames();
        for (Animateable animateable : this.animatedItems) {
            animateable.setFractionComplete(fractionComplete);
        }
        if (this.customLimitAnimatedParameters != null) {
            for (Object[] objectArray : this.customLimitAnimatedParameters) {
                Parameter param;
                if (objectArray.length == 2) {
                    if (objectArray[0] instanceof IntegerParam) {
                        ((IntegerParam)objectArray[0]).setValue((Integer)objectArray[1]);
                        continue;
                    }
                    if (objectArray[0] instanceof RealParam) {
                        ((RealParam)objectArray[0]).setValue((Double)objectArray[1]);
                        continue;
                    }
                    ((ComplexParam)objectArray[0]).setValue((Complex)objectArray[1]);
                    continue;
                }
                if (objectArray[0] instanceof RealParamAnimateable) {
                    param = (RealParamAnimateable)objectArray[0];
                    double start = (Double)objectArray[1];
                    double end = (Double)objectArray[2];
                    double val = start + fractionComplete * (end - start);
                    ((RealParam)param).setValue(val);
                    continue;
                }
                param = (ComplexParamAnimateable)objectArray[0];
                Complex start = (Complex)objectArray[1];
                Complex end = (Complex)objectArray[2];
                double valRe = start.re + fractionComplete * (end.re - start.re);
                double valIm = start.im + fractionComplete * (end.re - start.re);
                ((ComplexParam)param).setValue(new Complex(valRe, valIm));
            }
        }
        if (this.display != null && this.display.getView() != null) {
            this.display.getView().forceRedraw();
        }
    }

    @Override
    public String getStatusText(boolean running) {
        return null;
    }
}

