/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.conformalmap;

import java.awt.FlowLayout;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import vmm3d.conformalmap.ConformalMap;
import vmm3d.core.Complex;
import vmm3d.core.ComplexVariableParamAnimateable;
import vmm3d.core.Display;
import vmm3d.core.I18n;
import vmm3d.core.UserExhibit;
import vmm3d.core.View;
import vmm3d.core3D.UserExhibit3D;

public class UserConformalMap
extends ConformalMap
implements UserExhibit3D {
    private UserExhibit3D.Support userExhibitSupport;
    private UserExhibit.FunctionInfo func;

    public UserConformalMap() {
        this.umin.reset(-2.0);
        this.umax.reset("-0.0001");
        this.vmin.reset("0.0001");
        this.vmax.reset("2 * pi");
        this.ures.reset(7);
        this.vres.reset(20);
        this.setDefaultWindow2D(-1.5, 1.5, -1.5, 1.5);
        this.userExhibitSupport = new UserExhibit3D.Support(this){
            GridTypeInput gridTypeInput;
            {
                this.gridTypeInput = new GridTypeInput();
            }

            @Override
            protected void finish(UserExhibit.Support.Dialog dialog, View view, boolean creating) {
                double[] w = dialog.getWindow();
                UserConformalMap.this.setDefaultWindow2D(w);
                if (view instanceof ConformalMap.ConformalMapView) {
                    ((ConformalMap.ConformalMapView)view).setWindowForUseWhileThreeDDisabled(w[0], w[1], w[2], w[3]);
                }
                if (this.gridTypeInput.cartesianButton.isSelected()) {
                    UserConformalMap.this.resetGridType(0);
                } else if (this.gridTypeInput.polarButton.isSelected()) {
                    UserConformalMap.this.resetGridType(1);
                } else {
                    UserConformalMap.this.resetGridType(2);
                }
            }

            @Override
            protected UserExhibit.Support.Dialog createDialog(Display display, View view, boolean creating) {
                UserExhibit.Support.Dialog dialog = super.createDialog(display, view, creating);
                if (!creating) {
                    if (UserConformalMap.this.getGridType() == 0) {
                        this.gridTypeInput.cartesianButton.setSelected(true);
                    } else if (UserConformalMap.this.getGridType() == 1) {
                        this.gridTypeInput.polarButton.setSelected(true);
                    } else {
                        this.gridTypeInput.polarconformalButton.setSelected(true);
                    }
                }
                dialog.addExtraPanel(this.gridTypeInput);
                return dialog;
            }

            class GridTypeInput
            extends UserExhibit.Support.ExtraPanel {
                JRadioButton cartesianButton;
                JRadioButton polarButton;
                JRadioButton polarconformalButton;

                GridTypeInput() {
                    super(I18n.tr("vmm3d.conformalmap.ConformalMap.gridChoice"));
                    this.setLayout(new FlowLayout(1));
                    ButtonGroup group = new ButtonGroup();
                    this.cartesianButton = new JRadioButton(I18n.tr("vmm3d.conformalmap.ConformalMap.cartesian"), true);
                    group.add(this.cartesianButton);
                    this.add(this.cartesianButton);
                    this.polarButton = new JRadioButton(I18n.tr("vmm3d.conformalmap.ConformalMap.polar"), true);
                    group.add(this.polarButton);
                    this.add(this.polarButton);
                    this.polarconformalButton = new JRadioButton(I18n.tr("vmm3d.conformalmap.ConformalMap.polarconformal"), true);
                    group.add(this.polarconformalButton);
                    this.add(this.polarconformalButton);
                }

                @Override
                public void checkData() throws IllegalArgumentException {
                }
            }
        };
        this.userExhibitSupport.addFunctionParameter(new ComplexVariableParamAnimateable("a", new Complex(0.66667)));
        this.userExhibitSupport.addFunctionParameter(new ComplexVariableParamAnimateable("c", new Complex(), new Complex(), new Complex(0.5)));
        this.func = this.userExhibitSupport.addComplexFunction("f", "((i*tan(i*z/2)+c)/(1+conj(c)*i*tan(i*z/2)))^a", "z");
        this.userExhibitSupport.setShowViewpoint(false);
    }

    @Override
    protected Complex function(Complex argument) {
        return this.func.complexFunctionValue(argument);
    }

    @Override
    public UserExhibit.Support getUserExhibitSupport() {
        return this.userExhibitSupport;
    }
}

