/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.autodetect;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.autodetect.FontDirFinder;
import org.apache.fop.fonts.autodetect.FontFinder;
import org.apache.fop.fonts.autodetect.MacFontDirFinder;
import org.apache.fop.fonts.autodetect.UnixFontDirFinder;
import org.apache.fop.fonts.autodetect.WindowsFontDirFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontFileFinder
extends DirectoryWalker
implements FontFinder {
    public static final int DEFAULT_DEPTH_LIMIT = -1;
    private final FontEventListener eventListener;

    public FontFileFinder(FontEventListener listener) {
        this(-1, listener);
    }

    public FontFileFinder(int depthLimit, FontEventListener listener) {
        super(FontFileFinder.getDirectoryFilter(), FontFileFinder.getFileFilter(), depthLimit);
        this.eventListener = listener;
    }

    protected static IOFileFilter getDirectoryFilter() {
        return FileFilterUtils.andFileFilter(FileFilterUtils.directoryFileFilter(), FileFilterUtils.notFileFilter(FileFilterUtils.prefixFileFilter(".")));
    }

    protected static IOFileFilter getFileFilter() {
        return FileFilterUtils.andFileFilter(FileFilterUtils.fileFileFilter(), new WildcardFileFilter(new String[]{"*.ttf", "*.otf", "*.pfb", "*.ttc"}, IOCase.INSENSITIVE));
    }

    @Override
    protected boolean handleDirectory(File directory, int depth, Collection results) {
        return true;
    }

    @Override
    protected void handleFile(File file, int depth, Collection results) {
        try {
            results.add(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
    }

    @Override
    protected void handleDirectoryEnd(File directory, int depth, Collection results) {
    }

    @Override
    public List<URL> find() throws IOException {
        String osName = System.getProperty("os.name");
        FontDirFinder fontDirFinder = osName.startsWith("Windows") ? new WindowsFontDirFinder() : (osName.startsWith("Mac") ? new MacFontDirFinder() : new UnixFontDirFinder());
        List<File> fontDirs = fontDirFinder.find();
        ArrayList<URL> results = new ArrayList<URL>();
        for (File dir : fontDirs) {
            super.walk(dir, results);
        }
        return results;
    }

    public List<URL> find(String dir) throws IOException {
        ArrayList<URL> results = new ArrayList<URL>();
        File directory = new File(dir);
        if (!directory.isDirectory()) {
            this.eventListener.fontDirectoryNotFound(this, dir);
        } else {
            super.walk(directory, results);
        }
        return results;
    }
}

