/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.cmd.mandel;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.GridConfig;
import org.homedns.dade.jcgrid.admin.GridNodeAdminConfig;
import org.homedns.dade.jcgrid.client.GridNodeClientConfig;
import org.homedns.dade.jcgrid.cmd.MainCmd;
import org.homedns.dade.jcgrid.cmd.mandel.guiMandelRenderingPannel;
import org.homedns.dade.jcgrid.cmd.mandel.guiMandelWorkerPannel;
import org.homedns.dade.jcgrid.cmd.mandel.guiRenderingSetting;
import org.homedns.dade.jcgrid.gui.guiJCGridAbout;
import org.homedns.dade.jcgrid.gui.guiJCGridAdminStatus;
import org.homedns.dade.jcgrid.worker.GridNodeWorkerConfig;

public class guiJCGridClient
extends JFrame {
    private static final String className = guiJCGridClient.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private static final long serialVersionUID = 1L;
    private guiMandelRenderingPannel pPic;
    private guiRenderingSetting pSet = null;
    private guiJCGridAdminStatus pServerStatus = null;
    private guiMandelWorkerPannel pWorker;
    private guiJCGridAbout pAbout = null;
    private GridNodeClientConfig clientConfig;
    private GridNodeWorkerConfig workerConfig;
    private GridNodeAdminConfig adminConfig;
    private JMenuItem mAbout;
    private JMenu mAdmin;
    private JMenuBar mBar;
    private JMenu mEdit;
    private JMenuItem mExit;
    private JMenu mFile;
    private JMenuItem mResetView;
    private JMenuItem mSaveImageAs;
    private JSeparator mSepa2;
    private JSeparator mSepa3;
    private JMenuItem mStatus;

    public guiJCGridClient() {
        this.initComponents();
        this.clientConfig = new GridNodeClientConfig();
        this.clientConfig.autoSessioName();
        this.adminConfig = new GridNodeAdminConfig();
        this.adminConfig.autoSessioName();
        this.workerConfig = new GridNodeWorkerConfig();
        this.workerConfig.autoSessioName();
        GridConfig gc = this.clientConfig.getGridConfig();
        gc.setServerAddress("dade.homedns.org");
        gc.setServerClientPort(10201);
        gc.setServerWorkerPort(10202);
        gc.setServerAdminPort(10203);
        gc.setUseCompression(true);
        gc.setUseVFS(false);
        this.adminConfig.setGridConfig(gc);
        this.workerConfig.setGridConfig(gc);
        this.pPic = new guiMandelRenderingPannel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pPic, gridBagConstraints);
        this.pSet = new guiRenderingSetting(this.clientConfig, this, false, this.pPic);
        this.pSet.setVisible(true);
        this.pWorker = new guiMandelWorkerPannel(this.workerConfig, this, false);
        this.pWorker.setVisible(true);
    }

    private void initComponents() {
        this.mBar = new JMenuBar();
        this.mFile = new JMenu();
        this.mSaveImageAs = new JMenuItem();
        this.mSepa2 = new JSeparator();
        this.mAbout = new JMenuItem();
        this.mSepa3 = new JSeparator();
        this.mExit = new JMenuItem();
        this.mEdit = new JMenu();
        this.mResetView = new JMenuItem();
        this.mAdmin = new JMenu();
        this.mStatus = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("JCGrid Mandel Client");
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                guiJCGridClient.this.exitForm(evt);
            }
        });
        this.mFile.setText("File");
        this.mSaveImageAs.setText("Save image as...");
        this.mSaveImageAs.setMnemonic('s');
        this.mSaveImageAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridClient.this.mSaveImageAsActionPerformed(evt);
            }
        });
        this.mFile.add(this.mSaveImageAs);
        this.mFile.add(this.mSepa2);
        this.mAbout.setText("About");
        this.mAbout.setMnemonic('a');
        this.mAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridClient.this.mAboutActionPerformed(evt);
            }
        });
        this.mFile.add(this.mAbout);
        this.mFile.add(this.mSepa3);
        this.mExit.setText("Exit");
        this.mExit.setMnemonic('e');
        this.mExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridClient.this.mExitActionPerformed(evt);
            }
        });
        this.mFile.add(this.mExit);
        this.mBar.add(this.mFile);
        this.mEdit.setText("Edit");
        this.mResetView.setText("Reset view");
        this.mResetView.setMnemonic('r');
        this.mResetView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridClient.this.mResetViewActionPerformed(evt);
            }
        });
        this.mEdit.add(this.mResetView);
        this.mBar.add(this.mEdit);
        this.mAdmin.setText("Admin.");
        this.mStatus.setText("Server status");
        this.mStatus.setMnemonic('s');
        this.mStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridClient.this.mStatusActionPerformed(evt);
            }
        });
        this.mAdmin.add(this.mStatus);
        this.mBar.add(this.mAdmin);
        this.setJMenuBar(this.mBar);
        this.setBounds(0, 0, 400, 300);
    }

    private void mAboutActionPerformed(ActionEvent evt) {
        if (this.pAbout == null || !this.pAbout.isVisible()) {
            this.pAbout = new guiJCGridAbout((Frame)this, false);
            this.pAbout.setVisible(true);
        }
    }

    private void mResetViewActionPerformed(ActionEvent evt) {
        if (this.pSet != null) {
            this.pSet.startRendering();
        }
    }

    private void mStatusActionPerformed(ActionEvent evt) {
        if (this.pServerStatus != null && this.pServerStatus.isVisible()) {
            this.pServerStatus.refreshInfo(this.adminConfig);
        } else {
            try {
                this.pServerStatus = new guiJCGridAdminStatus(this.adminConfig, this, false);
                this.pServerStatus.setVisible(true);
            }
            catch (Exception ex) {
                log.warn((Object)"Error while opening the Admin. Status dialog", (Throwable)ex);
                JOptionPane.showMessageDialog(this, "Error while opening the Admin. Status dialog", "Admin error", 0);
            }
        }
    }

    private void mExitActionPerformed(ActionEvent evt) {
        this.exitForm(null);
    }

    private void mSaveImageAsActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        int res = chooser.showSaveDialog(this);
        if (res == 0) {
            this.pPic.saveImage(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            MainCmd.setUpLog4J("gui-client", false);
            new guiJCGridClient().setVisible(true);
        }
        catch (Exception ex) {
            log.warn((Object)"Error", (Throwable)ex);
            System.exit(0);
        }
    }
}

