/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.admin;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.GridNodeGeneric;
import org.homedns.dade.jcgrid.GridStats;
import org.homedns.dade.jcgrid.admin.GridNodeAdminConfig;
import org.homedns.dade.jcgrid.message.GridMessage;
import org.homedns.dade.jcgrid.message.GridMessageAdminGetGridStats;
import org.homedns.dade.jcgrid.message.GridMessageAdminGetWorkerStats;
import org.homedns.dade.jcgrid.message.GridMessageAdminGridStats;
import org.homedns.dade.jcgrid.message.GridMessageAdminWorkerStats;
import org.homedns.dade.jcgrid.message.GridMessagePing;
import org.homedns.dade.jcgrid.message.GridMessagePingAck;
import org.homedns.dade.jcgrid.vfs.vfsSession;

public class GridAdmin
extends GridNodeGeneric {
    private static final String className = GridAdmin.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private vfsSession session;

    public GridAdmin() {
        super(new GridNodeAdminConfig());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start GridAdmin()");
        }
        this.session = null;
        super.getNodeConfig().setWorkingDir(System.getProperty("user.dir"));
        if (log.isDebugEnabled()) {
            log.debug((Object)"End GridAdmin()");
        }
    }

    public long ping() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start ping()");
        }
        long t1 = System.currentTimeMillis();
        super.getGridMessageChannel().send(new GridMessagePing());
        GridMessage msg = super.getGridMessageChannel().recv(30000);
        long res = msg == null || !(msg instanceof GridMessagePingAck) ? -1L : System.currentTimeMillis() - t1;
        if (log.isDebugEnabled()) {
            log.debug((Object)("End ping(" + res + ")"));
        }
        return res;
    }

    public Vector getWorkerStats() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start getWorkerStats()");
        }
        super.getGridMessageChannel().send(new GridMessageAdminGetWorkerStats());
        GridMessage msg = super.getGridMessageChannel().recv(30000);
        Vector res = msg == null || !(msg instanceof GridMessageAdminWorkerStats) ? null : ((GridMessageAdminWorkerStats)msg).getStats();
        if (log.isDebugEnabled()) {
            log.debug((Object)("End getWorkerStats(" + res + ")"));
        }
        return res;
    }

    public GridStats getGridStats() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start getGridStats()");
        }
        super.getGridMessageChannel().send(new GridMessageAdminGetGridStats());
        GridMessage msg = super.getGridMessageChannel().recv(30000);
        GridStats res = msg == null || !(msg instanceof GridMessageAdminGridStats) ? null : ((GridMessageAdminGridStats)msg).getStats();
        if (log.isDebugEnabled()) {
            log.debug((Object)("End getGridStats(" + res + ")"));
        }
        return res;
    }
}

