/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid;

import java.io.Serializable;
import org.homedns.dade.jcgrid.WorkResult;

public class WorkerStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final short STATUS_FREE = 0;
    public static final short STATUS_BUSY = 1;
    private String name;
    private short status;
    private String workingFor;
    private long workingStarted;
    private long unitDone;
    private double unitSec;

    public WorkerStats(String workerName) {
        this.name = workerName;
        this.status = 0;
        this.workingFor = "";
        this.workingStarted = 0L;
        this.unitDone = 0L;
        this.unitSec = 0.0;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized short getStatus() {
        return this.status;
    }

    public synchronized String getWorkingFor() {
        return this.workingFor;
    }

    public synchronized long getWorkingStarted() {
        return this.workingStarted;
    }

    public synchronized long getUnitDone() {
        return this.unitDone;
    }

    public synchronized double getUnitSec() {
        return this.unitSec;
    }

    public synchronized void setStatusFree() {
        this.status = 0;
        this.workingFor = "";
        this.workingStarted = 0L;
    }

    public synchronized void workBegin(String sessionName) {
        this.status = 1;
        this.workingFor = sessionName;
        this.workingStarted = System.currentTimeMillis();
    }

    public synchronized void workEnd(WorkResult wr) {
        long t = System.currentTimeMillis() - this.workingStarted + 1L;
        this.setStatusFree();
        this.unitDone += wr.getUnitDone();
        if (this.unitDone == 0L) {
            this.unitSec = 1000.0 * (double)wr.getUnitDone() / (double)t;
        } else {
            double k = (double)wr.getUnitDone() / (double)this.unitDone;
            this.unitSec = this.unitSec * (1.0 - k) + 1000.0 * (double)wr.getUnitDone() / (double)t * k;
        }
    }
}

