/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.swing;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.File;
import de.schlichtherle.key.PromptingKeyManager;
import de.schlichtherle.swing.AbstractComboBoxBrowser;
import java.io.FilenameFilter;
import java.text.Collator;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class FileComboBoxBrowser
extends AbstractComboBoxBrowser {
    private static final long serialVersionUID = -6878885832542209810L;
    private java.io.File directory = new File(".");

    public FileComboBoxBrowser() {
    }

    public FileComboBoxBrowser(JComboBox comboBox) {
        super(comboBox);
        Object item;
        if (comboBox != null && ((item = comboBox.getSelectedItem()) == null || item instanceof String)) {
            FileComboBoxBrowser.update((DefaultComboBoxModel)comboBox.getModel(), this.directory, (String)item);
        }
    }

    public java.io.File getDirectory() {
        return this.directory;
    }

    public void setDirectory(java.io.File directory) {
        this.directory = directory != null ? directory : new File(".");
    }

    protected boolean update(String initials) {
        return FileComboBoxBrowser.update((DefaultComboBoxModel)this.getComboBox().getModel(), this.getDirectory(), initials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean update(DefaultComboBoxModel model, java.io.File dir, String initials) {
        String prefix;
        String base;
        if (initials == null) {
            initials = "";
        }
        if ("".equals(initials)) {
            base = "";
            prefix = "";
        } else {
            ArchiveDetector detector = dir instanceof File ? ((File)dir).getArchiveDetector() : ArchiveDetector.NULL;
            File node = new File(initials, detector);
            if (node.isAbsolute()) {
                boolean dirPath;
                boolean bl = dirPath = node.getPath().length() < initials.length();
                if (dirPath) {
                    PromptingKeyManager.resetCancelledPrompts();
                }
                if (dirPath && node.isDirectory()) {
                    dir = node;
                    prefix = "";
                } else {
                    dir = (File)node.getParentFile();
                    if (dir == null) {
                        dir = node;
                        prefix = "";
                    } else {
                        prefix = node.getName();
                    }
                }
                base = dir.getPath().endsWith(File.separator) ? initials.substring(0, dir.getPath().length()) : initials.substring(0, dir.getPath().length() + 1);
            } else {
                boolean dirPath;
                java.io.File directory = dir;
                node = new File(directory, initials);
                boolean bl = dirPath = node.getPath().length() < (directory.getPath() + File.separator + initials).length();
                if (dirPath) {
                    PromptingKeyManager.resetCancelledPrompts();
                }
                if (dirPath && node.isDirectory()) {
                    dir = node;
                    prefix = "";
                } else {
                    dir = (File)node.getParentFile();
                    prefix = node.getName();
                }
                base = initials.substring(0, dir.getPath().length() - directory.getPath().length());
            }
        }
        FilenameFilter filter = new FilenameFilter(){
            final int pl;
            {
                this.pl = prefix.length();
            }

            public boolean accept(java.io.File d, String child) {
                if (child.length() >= this.pl) {
                    return prefix.equalsIgnoreCase(child.substring(0, this.pl));
                }
                return false;
            }
        };
        String[] children = dir.list(filter);
        try {
            boolean bl;
            int l;
            model.removeAllElements();
            int n = l = children != null ? children.length : 0;
            if (l > 0) {
                Arrays.sort(children, Collator.getInstance());
                for (int i = 0; i < l; ++i) {
                    model.addElement(base + children[i]);
                }
                bl = true;
                return bl;
            }
            model.addElement(initials);
            bl = false;
            return bl;
        }
        finally {
            if (!initials.equals(model.getSelectedItem())) {
                model.setSelectedItem(initials);
            }
        }
    }
}

