/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.util;

import java.awt.image.BufferedImage;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import org.ujmp.core.util.UJMPTimer;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.renderer.MatrixHeatmapRenderer;

public class UpdateIconTimerTask
extends TimerTask {
    private static UpdateIconTimerTask instance = null;
    private static final Object lock = new Object();
    private List<MatrixGUIObject> list = new LinkedList<MatrixGUIObject>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final UpdateIconTimerTask getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new UpdateIconTimerTask();
                }
            }
        }
        return instance;
    }

    private UpdateIconTimerTask() {
        UJMPTimer.newInstance("UpdateIcon").schedule((TimerTask)this, 300L, 300L);
    }

    public void add(MatrixGUIObject matrixGUIObject) {
        this.list.add(matrixGUIObject);
    }

    @Override
    public void run() {
        try {
            for (MatrixGUIObject matrixGuiObject : this.list) {
                if (matrixGuiObject.isIconUpToDate()) continue;
                matrixGuiObject.setIconUpToDate(true);
                BufferedImage image = new BufferedImage(16, 16, 1);
                MatrixHeatmapRenderer.paintMatrix(image.getGraphics(), matrixGuiObject, 16, 16, 0, 0);
                matrixGuiObject.setIcon(image);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }
}

