/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.io;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;

public class IntelligentFileWriter
extends Writer
implements Appendable,
Closeable,
Flushable {
    private static final String SEVENZIPOUTPUTSTREAM = "org.ujmp.j7zip.SevenZipOutputStream";
    private FileWriter fw = null;
    private OutputStream zip = null;
    private BufferedWriter bw = null;
    private String encoding = "UTF-8";

    public IntelligentFileWriter(String filename) throws IOException, ClassNotFoundException {
        this(filename, false);
    }

    public IntelligentFileWriter(String filename, boolean append) throws IOException, ClassNotFoundException {
        this(new File(filename), append);
    }

    public IntelligentFileWriter(OutputStream outputStream) throws IOException {
        this.bw = new BufferedWriter(new OutputStreamWriter(outputStream, this.encoding));
    }

    public IntelligentFileWriter(File file) throws IOException {
        this(file, false);
    }

    public IntelligentFileWriter(File file, boolean append) throws IOException {
        if (file.getAbsolutePath().toLowerCase().endsWith(".gz")) {
            this.zip = new GZIPOutputStream(new FileOutputStream(file, append));
            this.bw = new BufferedWriter(new OutputStreamWriter(this.zip, this.encoding));
        } else if (file.getAbsolutePath().toLowerCase().endsWith(".z")) {
            this.zip = new ZipOutputStream(new FileOutputStream(file, append));
            this.bw = new BufferedWriter(new OutputStreamWriter(this.zip, this.encoding));
        } else if (file.getAbsolutePath().toLowerCase().endsWith(".7z")) {
            try {
                Class<?> c = Class.forName(SEVENZIPOUTPUTSTREAM);
                Constructor<?> con = c.getConstructor(FileOutputStream.class);
                this.zip = (OutputStream)con.newInstance(new FileOutputStream(file, append));
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Could not find ujmp-j7zip in classpath");
            }
            catch (Exception e) {
                throw new IOException("Could not create SevenZipOutputStream");
            }
            this.bw = new BufferedWriter(new OutputStreamWriter(this.zip, this.encoding));
        } else {
            this.fw = new FileWriter(file, append);
            this.bw = new BufferedWriter(this.fw);
        }
    }

    public static final void save(String filename, String text) throws Exception {
        IntelligentFileWriter.save(new File(filename), text);
    }

    public static final void save(File file, String text) throws Exception {
        IntelligentFileWriter fw = new IntelligentFileWriter(file, false);
        fw.write(text);
        fw.close();
    }

    public static final void append(String filename, String text) throws Exception {
        IntelligentFileWriter fw = new IntelligentFileWriter(filename, true);
        fw.write(text);
        fw.close();
    }

    @Override
    public void close() throws IOException {
        if (this.bw != null) {
            this.bw.close();
        }
        if (this.fw != null) {
            this.fw.close();
        }
        if (this.zip != null) {
            this.zip.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.bw != null) {
            this.bw.flush();
        }
        if (this.fw != null) {
            this.fw.flush();
        }
        if (this.zip != null) {
            this.zip.flush();
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.bw.write(cbuf, off, len);
    }

    public static void write(OutputStream os, String text) {
        try {
            if (text == null) {
                text = "";
            }
            IntelligentFileWriter fw = new IntelligentFileWriter(os);
            fw.write(text);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

