/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;

public class ClientMatrix
extends AbstractDenseDoubleMatrix2D {
    private static final long serialVersionUID = 7947043738616156003L;
    public static final int GETSIZE = 1;
    public static final int GETDOUBLE = 2;
    public static final int SETDOUBLE = 3;
    public static final int ISREADONLY = 4;
    public static final int PLUSMATRIX = 5;
    private final byte[] inputBuffer = new byte[1000000];
    private final byte[] outputBuffer = new byte[1000000];
    private final ByteBuffer inputBB = ByteBuffer.wrap(this.inputBuffer);
    private final ByteBuffer outputBB = ByteBuffer.wrap(this.outputBuffer);
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final boolean isReadOnly;

    public ClientMatrix(int port) throws UnknownHostException, IOException {
        this(ClientMatrix.open("localhost", port));
    }

    public ClientMatrix(String host, int port) throws UnknownHostException, IOException {
        this(ClientMatrix.open(host, port));
    }

    private static Socket open(String host, int port) throws UnknownHostException, IOException {
        return new Socket(host, port);
    }

    public ClientMatrix(Socket socket) throws IOException {
        this(ClientMatrix.getInputStream(socket), ClientMatrix.getOutputStream(socket));
    }

    public ClientMatrix(InputStream inputStream, OutputStream outputStream) throws IOException {
        this(inputStream, outputStream, ClientMatrix.getSize(inputStream, outputStream), ClientMatrix.isReadOnly(inputStream, outputStream));
    }

    private ClientMatrix(InputStream inputStream, OutputStream outputStream, long[] size, boolean isReadOnly) {
        super(size[0], size[1]);
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.isReadOnly = isReadOnly;
    }

    private static InputStream getInputStream(Socket socket) throws IOException {
        return socket.getInputStream();
    }

    private static OutputStream getOutputStream(Socket socket) throws IOException {
        return socket.getOutputStream();
    }

    private static long[] getSize(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[128];
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        bb.putInt(1);
        outputStream.write(buffer, 0, bb.position());
        outputStream.flush();
        inputStream.read(buffer);
        bb.rewind();
        return new long[]{bb.getLong(), bb.getLong()};
    }

    private static boolean isReadOnly(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[128];
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        bb.putInt(4);
        outputStream.write(buffer, 0, bb.position());
        outputStream.flush();
        inputStream.read(buffer);
        bb.rewind();
        return bb.get() == 1;
    }

    @Override
    public synchronized double getDouble(long row, long column) {
        try {
            this.outputBB.rewind();
            this.outputBB.putInt(2);
            this.outputBB.putLong(row);
            this.outputBB.putLong(column);
            this.outputStream.write(this.outputBuffer, 0, this.outputBB.position());
            this.outputStream.flush();
            this.inputStream.read(this.inputBuffer);
            this.inputBB.rewind();
            return this.inputBB.getDouble();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public synchronized void setDouble(double value, long row, long column) {
        if (this.isReadOnly) {
            throw new RuntimeException("matrix is read only");
        }
        try {
            this.outputBB.rewind();
            this.outputBB.putInt(3);
            this.outputBB.putDouble(value);
            this.outputBB.putLong(row);
            this.outputBB.putLong(column);
            this.outputStream.write(this.outputBuffer, 0, this.outputBB.position());
            this.outputStream.flush();
            this.fireValueChanged();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized Matrix plus(Calculation.Ret returnType, boolean ignoreNaN, Matrix m) {
        if (returnType == Calculation.Ret.ORIG) {
            try {
                this.outputBB.rewind();
                this.outputBB.putInt(5);
                this.outputStream.write(this.outputBuffer, 0, this.outputBB.position());
                this.outputStream.flush();
                this.fireValueChanged();
                return this;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return super.plus(returnType, ignoreNaN, m);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.getDouble((long)row, (long)column);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.setDouble(value, (long)row, (long)column);
    }
}

