/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.stringmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.stringmatrix.stub.AbstractDenseStringMatrix2D;
import org.ujmp.core.util.MathUtil;

public class ArrayDenseStringMatrix2D
extends AbstractDenseStringMatrix2D {
    private static final long serialVersionUID = -4292004796378125964L;
    private final String[][] values;

    public ArrayDenseStringMatrix2D(String string) {
        super(0L, 0L);
        string = string.replaceAll("[\\[\\]\\(\\)\\{\\}]", "");
        String[] rows = string.split("\\s*[;\\n]\\s*");
        String[] cols = rows[0].split("[,\\s*]");
        this.values = new String[rows.length][cols.length];
        for (int r = 0; r < rows.length; ++r) {
            cols = rows[r].split("[,\\s*]");
            for (int c = 0; c < cols.length; ++c) {
                this.values[r][c] = cols[c];
            }
        }
    }

    public ArrayDenseStringMatrix2D(Matrix source) {
        this(MathUtil.longToInt(source.getRowCount()), MathUtil.longToInt(source.getColumnCount()));
        for (long[] c : source.availableCoordinates()) {
            this.setAsString(source.getAsString(c), c);
        }
    }

    public ArrayDenseStringMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.values = new String[rows][columns];
    }

    public ArrayDenseStringMatrix2D(String[] ... values) {
        super((long)values.length, (long)values[0].length);
        this.values = values;
    }

    @Override
    public String getString(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    @Override
    public void setString(String value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }
}

