/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.setmatrix;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.ujmp.core.genericmatrix.stub.AbstractDenseGenericMatrix2D;
import org.ujmp.core.setmatrix.SetMatrix;

public abstract class AbstractSetMatrix<E>
extends AbstractDenseGenericMatrix2D<E>
implements SetMatrix<E> {
    private static final long serialVersionUID = -3152489258987719660L;

    public AbstractSetMatrix() {
        super(0L, 1L);
    }

    @Override
    public final synchronized long[] getSize() {
        this.size[0] = this.size();
        return this.size;
    }

    @Override
    public final synchronized E getObject(long row, long column) {
        return this.getObject((int)row, (int)column);
    }

    @Override
    public final synchronized void setObject(Object value, long row, long column) {
        this.setObject(value, (long)((int)row), (long)((int)column));
    }

    @Override
    public final boolean add(E e) {
        boolean ret = this.addToSet(e);
        this.fireValueChanged();
        return ret;
    }

    @Override
    public final boolean addAll(Collection<? extends E> c) {
        boolean ret = false;
        for (E value : c) {
            ret |= this.addToSet(value);
        }
        if (ret) {
            this.fireValueChanged();
        }
        return ret;
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = this.removeFromSet(o);
        if (ret) {
            this.fireValueChanged();
        }
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = false;
        for (Object o : c) {
            ret |= this.removeFromSet(o);
        }
        if (ret) {
            this.fireValueChanged();
        }
        return ret;
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        boolean ret = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            ret = true;
        }
        if (ret) {
            this.fireValueChanged();
        }
        return ret;
    }

    @Override
    public final E getObject(int row, int column) {
        Iterator it = this.iterator();
        for (int i = 0; i < row && it.hasNext(); ++i) {
            it.next();
        }
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    @Override
    public final Object[] toArray() {
        Object[] objects = new Object[this.size()];
        Iterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            objects[i++] = it.next();
        }
        return objects;
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        Object[] objects = (Object[])Array.newInstance(a.getClass(), this.size());
        Iterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            objects[i++] = it.next();
        }
        return objects;
    }

    @Override
    public final void clear() {
        this.clearSet();
        this.fireValueChanged();
    }

    protected abstract void clearSet();

    protected abstract boolean removeFromSet(Object var1);

    protected abstract boolean addToSet(E var1);
}

