/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import java.util.Iterator;
import org.ujmp.core.objectmatrix.impl.DefaultSparseColumnObjectMatrix2D;

class NonZeroIterator
implements Iterator<long[]> {
    private final DefaultSparseColumnObjectMatrix2D matrix;
    private final long[] coordinates = new long[]{-1L, -1L};
    private final Iterator<Long> columnIterator;
    private Iterator<long[]> rowIterator;
    private long currentColumn;

    public NonZeroIterator(DefaultSparseColumnObjectMatrix2D matrix) {
        this.matrix = matrix;
        this.columnIterator = matrix.columns.keySet().iterator();
        while (this.columnIterator.hasNext() && (this.rowIterator == null || !this.rowIterator.hasNext())) {
            this.currentColumn = this.columnIterator.next();
            this.rowIterator = matrix.columns.get(this.currentColumn).availableCoordinates().iterator();
        }
    }

    @Override
    public boolean hasNext() {
        return this.rowIterator != null && this.rowIterator.hasNext();
    }

    @Override
    public long[] next() {
        long[] rowCoordinates = this.rowIterator.next();
        this.coordinates[0] = rowCoordinates[0];
        this.coordinates[1] = this.currentColumn;
        if (!this.rowIterator.hasNext()) {
            while (this.columnIterator.hasNext() && (this.rowIterator == null || !this.rowIterator.hasNext())) {
                this.currentColumn = this.columnIterator.next();
                this.rowIterator = this.matrix.columns.get(this.currentColumn).availableCoordinates().iterator();
            }
        }
        return this.coordinates;
    }

    @Override
    public void remove() {
        throw new RuntimeException("cannot modify matrix");
    }
}

