/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix;
import org.ujmp.core.util.MathUtil;

public class DefaultDenseObjectMatrixMultiD
extends AbstractDenseObjectMatrix {
    private static final long serialVersionUID = 4312852021159459897L;
    private final Object[] values;
    private final int length;

    public DefaultDenseObjectMatrixMultiD(Matrix m) {
        super(m.getSize());
        this.size = Coordinates.copyOf(m.getSize());
        this.length = (int)Coordinates.product(this.size);
        this.values = new Object[this.length];
        if (m instanceof DefaultDenseObjectMatrixMultiD) {
            Object[] v = ((DefaultDenseObjectMatrixMultiD)m).values;
            System.arraycopy(v, 0, this.values, 0, v.length);
        } else {
            for (long[] c : m.allCoordinates()) {
                this.setObject(m.getAsObject(c), c);
            }
        }
    }

    public DefaultDenseObjectMatrixMultiD(long ... size) {
        super(size);
        this.size = Coordinates.copyOf(size);
        this.length = (int)Coordinates.product(size);
        this.values = new Object[this.length];
    }

    public DefaultDenseObjectMatrixMultiD(Object[] v, long ... size) {
        super(size);
        this.size = Coordinates.copyOf(size);
        this.length = (int)Coordinates.product(size);
        this.values = v;
    }

    @Override
    public final Object getObject(long ... pos) {
        return this.values[(int)MathUtil.pos2IndexRowMajor(this.size, pos)];
    }

    @Override
    public final void setObject(Object value, long ... pos) {
        this.values[(int)MathUtil.pos2IndexRowMajor((long[])this.size, (long[])pos)] = value;
    }
}

