/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.longmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.longmatrix.stub.AbstractDenseLongMatrix2D;

public class ArrayDenseLongMatrix2D
extends AbstractDenseLongMatrix2D {
    private static final long serialVersionUID = 2888746188860361425L;
    private final long[][] values;

    public ArrayDenseLongMatrix2D(long[] ... v) {
        super((long)v.length, (long)v[0].length);
        this.values = v;
    }

    @Override
    public long getLong(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    @Override
    public void setLong(long value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    @Override
    public long getLong(int row, int column) {
        return this.values[row][column];
    }

    @Override
    public void setLong(long value, int row, int column) {
        this.values[row][column] = value;
    }

    @Override
    public final Matrix transpose() {
        long[][] result = new long[this.values[0].length][this.values.length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[c][r];
            }
        }
        return new ArrayDenseLongMatrix2D(result);
    }
}

