/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.listmatrix;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.ujmp.core.collections.list.FastArrayList;
import org.ujmp.core.listmatrix.AbstractListMatrix;

public class DefaultListMatrix<T>
extends AbstractListMatrix<T> {
    private static final long serialVersionUID = -6381864884046078055L;
    private final List<T> list;

    public DefaultListMatrix(List<T> list) {
        this.list = list;
    }

    public DefaultListMatrix(Set<T> set) {
        this.list = new FastArrayList<T>(set);
    }

    public DefaultListMatrix(Collection<T> list) {
        this.list = list instanceof List ? (List<Object>)list : new FastArrayList<T>(list);
    }

    public DefaultListMatrix() {
        this.list = new FastArrayList<T>();
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public boolean addToList(T t) {
        return this.list.add(t);
    }

    @Override
    public void addToList(int index, T element) {
        this.list.add(index, element);
    }

    @Override
    public T removeFromList(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean removeFromList(Object o) {
        return this.list.remove(o);
    }

    @Override
    public T setToList(int index, T element) {
        return this.list.set(index, element);
    }

    @Override
    public void clearList() {
        this.list.clear();
    }

    @Override
    public int size() {
        return this.list.size();
    }
}

