/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.intmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.impl.DefaultDenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasIntArray;
import org.ujmp.core.intmatrix.stub.AbstractDenseIntMatrix2D;
import org.ujmp.core.mapmatrix.MapMatrix;

public class DefaultDenseIntMatrix2D
extends AbstractDenseIntMatrix2D
implements HasIntArray {
    private static final long serialVersionUID = 2911903176935762073L;
    private final int[] values;
    private final int rows;
    private final int cols;

    public DefaultDenseIntMatrix2D(int rows, int cols) {
        super((long)rows, (long)cols);
        this.rows = rows;
        this.cols = cols;
        this.values = new int[rows * cols];
    }

    @Override
    public int getInt(long row, long column) {
        return this.values[(int)(column * (long)this.rows + row)];
    }

    @Override
    public void setInt(int value, long row, long column) {
        this.values[(int)(column * (long)this.rows + row)] = value;
    }

    @Override
    public int getInt(int row, int column) {
        return this.values[column * this.rows + row];
    }

    @Override
    public void setInt(int value, int row, int column) {
        this.values[column * this.rows + row] = value;
    }

    @Override
    public final Matrix plus(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] + v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    @Override
    public final Matrix minus(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] - v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    @Override
    public final Matrix times(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] * v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    @Override
    public final Matrix divide(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] / v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix copy() {
        DefaultDenseIntMatrix2D m = new DefaultDenseIntMatrix2D(this.rows, this.cols);
        int[] result = m.values;
        System.arraycopy(this.values, 0, result, 0, this.values.length);
        if (this.getMetaData() != null) {
            m.setMetaData((MapMatrix<String, Object>)this.getMetaData().clone());
        }
        return m;
    }

    @Override
    public final Matrix transpose() {
        DefaultDenseIntMatrix2D m = new DefaultDenseIntMatrix2D(this.cols, this.rows);
        int[] result = m.values;
        int c = this.rows;
        while (--c != -1) {
            int r = this.cols;
            while (--r != -1) {
                result[c * this.cols + r] = this.values[r * this.rows + c];
            }
        }
        return m;
    }

    @Override
    public int[] getIntArray() {
        return this.values;
    }
}

