/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.graphmatrix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ujmp.core.Coordinates;
import org.ujmp.core.collections.list.ArrayIndexList;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.graphmatrix.AbstractGraphMatrix;
import org.ujmp.core.util.CoordinateSetToLongWrapper;

public class DefaultGraphMatrix<N, E>
extends AbstractGraphMatrix<N, E> {
    private static final long serialVersionUID = -6103776352324576412L;
    private boolean directed = true;
    private final List<N> nodes = new ArrayIndexList<N>();
    private final Map<Coordinates, E> edges = new HashMap<Coordinates, E>();
    private final Map<Long, List<Long>> parents = new HashMap<Long, List<Long>>();
    private final Map<Long, List<Long>> children = new HashMap<Long, List<Long>>();

    public DefaultGraphMatrix() {
    }

    public DefaultGraphMatrix(List<N> nodes) {
        this.nodes.addAll(nodes);
    }

    public Collection<E> getEdgeList() {
        return this.edges.values();
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return new CoordinateSetToLongWrapper(this.edges.keySet());
    }

    @Override
    public List<N> getNodeList() {
        return this.nodes;
    }

    @Override
    public void addNode(N o) {
        this.nodes.add(o);
    }

    @Override
    public void removeNode(N o) {
        this.nodes.remove(o);
    }

    @Override
    public int getEdgeCount() {
        return this.edges.size();
    }

    @Override
    public int getNodeCount() {
        return this.nodes.size();
    }

    @Override
    public void clear() {
        this.edges.clear();
        this.parents.clear();
        this.children.clear();
    }

    @Override
    public int getChildCount(long nodeIndex) {
        List<Long> indices = this.children.get(nodeIndex);
        return indices == null ? 0 : indices.size();
    }

    @Override
    public N getNode(long index) {
        return this.nodes.get((int)index);
    }

    @Override
    public int getParentCount(long nodeIndex) {
        List<Long> indices = this.parents.get(nodeIndex);
        return indices == null ? 0 : indices.size();
    }

    @Override
    public List<Long> getParentIndices(long index) {
        List<Long> indices = this.parents.get(index);
        return indices == null ? Collections.EMPTY_LIST : indices;
    }

    @Override
    public List<Long> getChildIndices(long index) {
        List<Long> indices = this.children.get(index);
        return indices == null ? Collections.EMPTY_LIST : indices;
    }

    @Override
    public void removeNode(long node) {
        this.nodes.remove((int)node);
    }

    @Override
    public boolean isDirected() {
        return this.directed;
    }

    @Override
    public void setDirected(boolean directed) {
        this.directed = directed;
    }

    @Override
    public void setNode(N node, long index) {
        this.nodes.set((int)index, node);
    }

    @Override
    public synchronized void setEdge(E edge, long nodeIndex1, long nodeIndex2) {
        int nmbOfNodes = this.nodes.size();
        if (nodeIndex1 >= (long)nmbOfNodes) {
            throw new RuntimeException("accessed node " + nodeIndex1 + ", but only " + nmbOfNodes + " available");
        }
        if (nodeIndex2 >= (long)nmbOfNodes) {
            throw new RuntimeException("accessed node " + nodeIndex2 + ", but only " + nmbOfNodes + " available");
        }
        if (edge == null) {
            List<Long> parentsNode2;
            this.edges.remove(Coordinates.wrap(nodeIndex1, nodeIndex2));
            List<Long> childrenNode1 = this.children.get(nodeIndex1);
            if (childrenNode1 != null) {
                childrenNode1.remove(nodeIndex1);
            }
            if ((parentsNode2 = this.parents.get(nodeIndex2)) != null) {
                parentsNode2.remove(nodeIndex2);
            }
        } else {
            this.edges.put(Coordinates.wrap(nodeIndex1, nodeIndex2), edge);
            List<Long> childrenNode1 = this.children.get(nodeIndex1);
            if (childrenNode1 == null) {
                childrenNode1 = new ArrayList<Long>();
                this.children.put(nodeIndex1, childrenNode1);
            }
            childrenNode1.add(nodeIndex2);
            List<Long> parentsNode2 = this.parents.get(nodeIndex2);
            if (parentsNode2 == null) {
                parentsNode2 = new ArrayList<Long>();
                this.parents.put(nodeIndex2, parentsNode2);
            }
            parentsNode2.add(nodeIndex1);
        }
    }

    @Override
    public void setEdge(E edge, N node1, N node2) {
        long index2;
        long index1 = this.getIndexOfNode(node1);
        if (index1 == -1L) {
            this.addNode(node1);
            index1 = this.getIndexOfNode(node1);
        }
        if ((index2 = this.getIndexOfNode(node2)) == -1L) {
            this.addNode(node2);
            index2 = this.getIndexOfNode(node2);
        }
        this.setEdge(edge, (N)index1, (N)index2);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.OBJECT;
    }

    @Override
    public E getEdge(long nodeIndex1, long nodeIndex2) {
        return this.edges.get(Coordinates.wrap(nodeIndex1, nodeIndex2));
    }

    public void removeEdge(E edge) {
        ArrayList<Coordinates> coordinatesToDelete = new ArrayList<Coordinates>();
        for (Coordinates c : this.edges.keySet()) {
            E e = this.edges.get(c);
            if (e != edge) continue;
            coordinatesToDelete.add(c);
        }
        for (Coordinates c : coordinatesToDelete) {
            this.edges.remove(c);
        }
    }

    @Override
    public void removeEdge(N node1, N node2) {
        this.setEdge(null, node1, node2);
    }

    @Override
    public void removeEdge(long nodeIndex1, long nodeIndex2) {
        this.setEdge(null, (N)nodeIndex1, (N)nodeIndex2);
    }
}

