/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasRowMajorDoubleArray2D;
import org.ujmp.core.mapmatrix.MapMatrix;

public class ArrayDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements HasRowMajorDoubleArray2D {
    private static final long serialVersionUID = 3132491298449205914L;
    private final double[][] values;

    public ArrayDenseDoubleMatrix2D(Matrix m) {
        super(m.getRowCount(), m.getColumnCount());
        if (m instanceof ArrayDenseDoubleMatrix2D) {
            double[][] v = ((ArrayDenseDoubleMatrix2D)m).values;
            this.values = new double[v.length][v[0].length];
            int r = v.length;
            while (--r != -1) {
                int c = v[0].length;
                while (--c != -1) {
                    this.values[r][c] = v[r][c];
                }
            }
        } else {
            this.values = new double[(int)m.getRowCount()][(int)m.getColumnCount()];
            for (long[] c : m.allCoordinates()) {
                this.setAsDouble(m.getAsDouble(c), c);
            }
        }
        if (m.getMetaData() != null) {
            this.setMetaData((MapMatrix<String, Object>)m.getMetaData().clone());
        }
    }

    public ArrayDenseDoubleMatrix2D(double[] ... v) {
        super((long)v.length, (long)v[0].length);
        this.values = v;
    }

    public ArrayDenseDoubleMatrix2D(long rows, long cols) {
        super(rows, cols);
        this.values = new double[(int)rows][(int)cols];
    }

    public ArrayDenseDoubleMatrix2D(double[] v) {
        super((long)v.length, 1L);
        this.values = new double[v.length][1];
        int r = v.length;
        while (--r != -1) {
            this.values[r][0] = v[r];
        }
    }

    @Override
    public double getDouble(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    @Override
    public double getDouble(int row, int column) {
        return this.values[row][column];
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.values[row][column] = value;
    }

    public final Matrix copy() {
        double[][] result = new double[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r != -1) {
            int c = result[0].length;
            while (--c != -1) {
                result[r][c] = this.values[r][c];
            }
        }
        ArrayDenseDoubleMatrix2D m = new ArrayDenseDoubleMatrix2D(result);
        if (this.getMetaData() != null) {
            m.setMetaData((MapMatrix<String, Object>)this.getMetaData().clone());
        }
        return m;
    }

    public boolean containsNaN() {
        int r = this.values.length;
        while (--r != -1) {
            int c = this.values[0].length;
            while (--c != -1) {
                if (!Double.isNaN(this.values[r][c])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public double[][] getRowMajorDoubleArray2D() {
        return this.values;
    }
}

