/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.decomposition;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.general.decomposition.LU;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Solve;
import org.ujmp.core.util.DecompositionOps;
import org.ujmp.core.util.UJMPSettings;

public interface SolveSymm<T>
extends Solve<T> {
    public static final int SQUARETHRESHOLD = 100;
    public static final SolveSymm<Matrix> MATRIX = new SolveSymm<Matrix>(){

        @Override
        public final Matrix calc(Matrix a, Matrix b) {
            if (UJMPSettings.getInstance().getNumberOfThreads() == 1) {
                if (a.getRowCount() >= 100L && a.getColumnCount() >= 100L) {
                    return MATRIXSQUARELARGESINGLETHREADED.calc(a, b);
                }
                return MATRIXSQUARESMALLSINGLETHREADED.calc(a, b);
            }
            if (a.getRowCount() >= 100L && a.getColumnCount() >= 100L) {
                return MATRIXSQUARELARGEMULTITHREADED.calc(a, b);
            }
            return MATRIXSQUARESMALLMULTITHREADED.calc(a, b);
        }
    };
    public static final SolveSymm<Matrix> INSTANCE = MATRIX;
    public static final SolveSymm<Matrix> UJMPSQUARE = new SolveSymm<Matrix>(){

        @Override
        public final Matrix calc(Matrix a, Matrix b) {
            return LU.INSTANCE.solve(a, b);
        }
    };
    public static final SolveSymm<Matrix> MATRIXSQUARESMALLSINGLETHREADED = UJMPSQUARE;
    public static final SolveSymm<Matrix> MATRIXSQUARELARGESINGLETHREADED = new SolveSymm<Matrix>(){

        @Override
        public final Matrix calc(Matrix a, Matrix b) {
            Solve<Object> solve = null;
            if (UJMPSettings.getInstance().isUseJBlas()) {
                solve = DecompositionOps.SOLVE_JBLAS;
            }
            if (solve == null && UJMPSettings.getInstance().isUseOjalgo()) {
                solve = DecompositionOps.SOLVE_OJALGO;
            }
            if (solve == null && UJMPSettings.getInstance().isUseEJML()) {
                solve = DecompositionOps.SOLVE_EJML;
            }
            if (solve == null && UJMPSettings.getInstance().isUseMTJ()) {
                solve = DecompositionOps.SOLVE_MTJ;
            }
            if (solve == null) {
                solve = UJMPSQUARE;
            }
            return solve.calc(a, b);
        }
    };
    public static final SolveSymm<Matrix> MATRIXSQUARELARGEMULTITHREADED = new SolveSymm<Matrix>(){

        @Override
        public Matrix calc(Matrix a, Matrix b) {
            Solve<Object> solve = null;
            if (UJMPSettings.getInstance().isUseJBlas()) {
                solve = DecompositionOps.SOLVE_JBLAS;
            }
            if (solve == null && UJMPSettings.getInstance().isUseOjalgo()) {
                solve = DecompositionOps.SOLVE_OJALGO;
            }
            if (solve == null && UJMPSettings.getInstance().isUseEJML()) {
                solve = DecompositionOps.SOLVE_EJML;
            }
            if (solve == null) {
                solve = UJMPSQUARE;
            }
            return solve.calc(a, b);
        }
    };
    public static final SolveSymm<Matrix> MATRIXSQUARESMALLMULTITHREADED = UJMPSQUARE;

    @Override
    public T calc(T var1, T var2);
}

