/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.DenseMatrix2D;
import org.ujmp.core.calculation.MinusMatrix;
import org.ujmp.core.calculation.MinusMatrixCalculation;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

class MinusMatrixDenseMatrix
implements MinusMatrixCalculation<DenseMatrix, DenseMatrix, DenseMatrix> {
    MinusMatrixDenseMatrix() {
    }

    @Override
    public final void calc(DenseMatrix source1, DenseMatrix source2, DenseMatrix target) {
        MapMatrix<String, Object> a;
        if (source1 != target && (a = source1.getMetaData()) != null) {
            target.setMetaData((MapMatrix<String, Object>)a.clone());
        }
        if (source1 instanceof DenseMatrix2D && source2 instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            MinusMatrix.DENSEMATRIX2D.calc((DenseMatrix2D)source1, (DenseMatrix2D)source2, (DenseMatrix2D)target);
        } else {
            VerifyUtil.verifySameSize(source1, source2, target);
            a = source1.allCoordinates().iterator();
            while (a.hasNext()) {
                long[] c = (long[])a.next();
                BigDecimal v1 = source1.getAsBigDecimal(c);
                BigDecimal v2 = source2.getAsBigDecimal(c);
                BigDecimal result = MathUtil.minus(v1, v2);
                target.setAsBigDecimal(result, c);
            }
            if (source1 != target && (a = source1.getMetaData()) != null) {
                target.setMetaData((MapMatrix<String, Object>)a.clone());
            }
        }
    }
}

