/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.SparseMatrix;
import org.ujmp.core.calculation.DivideMatrix;
import org.ujmp.core.calculation.DivideMatrixCalculation;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

class DivideMatrixMatrix
implements DivideMatrixCalculation<Matrix, Matrix, Matrix> {
    DivideMatrixMatrix() {
    }

    @Override
    public final void calc(Matrix source1, Matrix source2, Matrix target) {
        if (source1 instanceof DenseMatrix && source2 instanceof DenseMatrix && target instanceof DenseMatrix) {
            DivideMatrix.DENSEMATRIX.calc((DenseMatrix)source1, (DenseMatrix)source2, (DenseMatrix)target);
        } else if (source1 instanceof SparseMatrix && source2 instanceof SparseMatrix && target instanceof SparseMatrix) {
            DivideMatrix.SPARSEMATRIX.calc((SparseMatrix)source1, (SparseMatrix)source2, (SparseMatrix)target);
        } else {
            MapMatrix<String, Object> a;
            VerifyUtil.verifySameSize(source1, source2, target);
            for (long[] c : source1.allCoordinates()) {
                BigDecimal v1 = source1.getAsBigDecimal(c);
                BigDecimal v2 = source2.getAsBigDecimal(c);
                BigDecimal result = MathUtil.divide(v1, v2);
                target.setAsBigDecimal(result, c);
            }
            if (source1 != target && (a = source1.getMetaData()) != null) {
                target.setMetaData((MapMatrix<String, Object>)a.clone());
            }
        }
    }
}

