/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bytematrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.bytematrix.ByteMatrix;
import org.ujmp.core.bytematrix.calculation.ByteCalculation;
import org.ujmp.core.bytematrix.impl.ByteCalculationMatrix;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.mapmatrix.MapMatrix;

public abstract class AbstractByteCalculation
extends AbstractCalculation
implements ByteCalculation {
    private static final long serialVersionUID = -6732603786169729218L;

    public AbstractByteCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractByteCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    @Override
    public final ByteMatrix calcNew() {
        ByteMatrix result = (ByteMatrix)Matrix.Factory.zeros(ValueType.BYTE, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setByte(this.getByte(c), c);
        }
        if (this.getMetaData() != null) {
            result.setMetaData((MapMatrix<String, Object>)this.getMetaData().clone());
        }
        return result;
    }

    @Override
    public final ByteMatrix calcLink() {
        return new ByteCalculationMatrix(this);
    }

    @Override
    public final Matrix calcOrig() {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new RuntimeException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsByte(this.getByte(c), c);
        }
        this.getSource().fireValueChanged();
        return this.getSource();
    }

    @Override
    public void setByte(byte value, long ... coordinates) {
    }

    @Override
    public final ValueType getValueType() {
        return ValueType.BYTE;
    }
}

