/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core;

import java.io.Serializable;
import java.util.Arrays;
import org.ujmp.core.util.MathUtil;

public class Coordinates
implements Serializable,
Comparable<Coordinates> {
    private static final long serialVersionUID = 8361257560328772093L;
    public static final int X = 1;
    public static final int Y = 0;
    public static final int Z = 2;
    public static final int ROW = 0;
    public static final int COLUMN = 1;
    public static final int ALL = Integer.MAX_VALUE;
    public static final long[] ZERO2D = new long[]{0L, 0L};
    private final long[] coordinates;

    private Coordinates(long ... coordinates) {
        this.coordinates = coordinates;
    }

    public final int hashCode() {
        return Arrays.hashCode(this.coordinates);
    }

    public final boolean equals(Coordinates c) {
        return Arrays.equals(this.coordinates, c.coordinates);
    }

    public static final long product(long ... c) {
        long product = 1L;
        for (int i = c.length - 1; i != -1; --i) {
            product *= c[i];
        }
        return product;
    }

    public static final long product(int ... c) {
        long product = 1L;
        for (int i = c.length - 1; i != -1; --i) {
            product *= (long)c[i];
        }
        return product;
    }

    public static final Coordinates wrap(long ... coordinates) {
        return new Coordinates(coordinates);
    }

    public final String toString(String separator) {
        return this.toString("[", separator, "]");
    }

    public final String toString() {
        return this.toString("[", ",", "]");
    }

    public final String toString(String prefix, String separator, String suffix) {
        StringBuilder s = new StringBuilder();
        s.append(prefix);
        for (int i = 0; i < this.coordinates.length; ++i) {
            s.append(this.coordinates[i]);
            if (i >= this.coordinates.length - 1) continue;
            s.append(separator);
        }
        s.append(suffix);
        return s.toString();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Coordinates) {
            return this.equals((Coordinates)o);
        }
        return false;
    }

    public final void fillWithValue(long value) {
        Arrays.fill(this.coordinates, value);
    }

    public final void clear() {
        Arrays.fill(this.coordinates, 0L);
    }

    public static final String toString(long ... coordinates) {
        return Coordinates.toString(",", coordinates);
    }

    public static final String toString(String separator, long ... coordinates) {
        return Coordinates.toString("[", separator, "]", coordinates);
    }

    public static final String toString(String prefix, String separator, String suffix, long ... coordinates) {
        StringBuilder s = new StringBuilder();
        s.append(prefix);
        for (int i = 0; i < coordinates.length; ++i) {
            s.append(coordinates[i]);
            if (i >= coordinates.length - 1) continue;
            s.append(separator);
        }
        s.append(suffix);
        return s.toString();
    }

    public final Coordinates clone() {
        return Coordinates.wrap(Arrays.copyOf(this.coordinates, this.coordinates.length));
    }

    public static final long[] plus(long[] c1, long[] c2) {
        return Coordinates.plus(new long[c1.length], c1, c2);
    }

    public static final long[] plus(long[] result, long[] c1, long[] c2) {
        for (int i = result.length - 1; i != -1; --i) {
            result[i] = c1[i] + c2[i];
        }
        return result;
    }

    public static final long[] times(long[] c1, long[] c2) {
        return Coordinates.times(new long[c1.length], c1, c2);
    }

    public static final long[] times(long[] result, long[] c1, long[] c2) {
        for (int i = result.length - 1; i != -1; --i) {
            result[i] = c1[i] * c2[i];
        }
        return result;
    }

    public static final long[] divide(long[] c1, long[] c2) {
        return Coordinates.divide(new long[c1.length], c1, c2);
    }

    public static final long[] divide(long[] c1, int[] c2) {
        return Coordinates.divide(new long[c1.length], c1, c2);
    }

    public static final long[] divide(long[] result, long[] c1, long[] c2) {
        for (int i = result.length - 1; i != -1; --i) {
            result[i] = c1[i] / c2[i];
        }
        return result;
    }

    public static final long[] divide(long[] result, long[] c1, int[] c2) {
        for (int i = result.length - 1; i != -1; --i) {
            result[i] = c1[i] / (long)c2[i];
        }
        return result;
    }

    public static final long[] times(long[] c, long value) {
        return Coordinates.times(new long[c.length], c, value);
    }

    public static final long[] times(long[] result, long[] c, long value) {
        for (int i = result.length - 1; i != -1; --i) {
            result[i] = c[i] * value;
        }
        return result;
    }

    public static final long[] divide(long[] c, long value) {
        return Coordinates.divide(new long[c.length], c, value);
    }

    public static final long[] divide(long[] result, long[] c, long value) {
        for (int i = result.length - 1; i != -1; --i) {
            result[i] = c[i] / value;
        }
        return result;
    }

    public static final long[] modulo(long[] c1, long[] c2) {
        return Coordinates.modulo(new long[c1.length], c1, c2);
    }

    public static final long[] modulo(long[] result, long[] c1, long[] c2) {
        for (int i = result.length - 1; i != -1; --i) {
            result[i] = c1[i] % c2[i];
        }
        return result;
    }

    public static final long[] minus(long[] c1, long[] c2) {
        return Coordinates.minus(new long[c1.length], c1, c2);
    }

    public static final long[] minus(long[] result, long[] c1, long[] c2) {
        for (int i = result.length - 1; i != -1; --i) {
            result[i] = c1[i] - c2[i];
        }
        return result;
    }

    public static final long[] max(long[] c1, long[] c2) {
        return Coordinates.max(new long[c1.length], c1, c2);
    }

    public static final long[] max(long[] result, long[] c1, long[] c2) {
        for (int i = result.length - 1; i != -1; --i) {
            result[i] = Math.max(c1[i], c2[i]);
        }
        return result;
    }

    public static final long[] min(long[] c1, long[] c2) {
        return Coordinates.max(new long[c1.length], c1, c2);
    }

    public static final long[] min(long[] result, long[] c1, long[] c2) {
        for (int i = result.length - 1; i != -1; --i) {
            result[i] = Math.min(c1[i], c2[i]);
        }
        return result;
    }

    public static final long[] parseString(String s, String splitRegex) {
        return Coordinates.parseString(s, "[x,;\t]");
    }

    public static final long[] parseString(String s) {
        String[] fields = s.split("[,;\tx]");
        long[] result = new long[fields.length];
        for (int i = fields.length - 1; i != -1; --i) {
            result[i] = Long.parseLong(fields[i]);
        }
        return result;
    }

    public final int getDimensionCount() {
        return this.coordinates.length;
    }

    public static final boolean equals(long[] c1, long[] c2) {
        return Arrays.equals(c1, c2);
    }

    public static final boolean equals(int[] c1, int[] c2) {
        return Arrays.equals(c1, c2);
    }

    public static final long[] copyOf(long[] c) {
        return Arrays.copyOf(c, c.length);
    }

    public static final long[] transpose(long[] c) {
        return Coordinates.transpose(new long[c.length], c, 0, 1);
    }

    public static final long[] transpose(long[] c, int swapDimension1, int swapDimension2) {
        return Coordinates.transpose(new long[c.length], c, swapDimension1, swapDimension2);
    }

    public static final long[] transpose(long[] result, long[] c, int swapDimension1, int swapDimension2) {
        if (result == c) {
            long temp = c[swapDimension1];
            result[swapDimension1] = c[swapDimension2];
            result[swapDimension2] = temp;
        } else {
            result[swapDimension1] = c[swapDimension2];
            result[swapDimension2] = c[swapDimension1];
        }
        return result;
    }

    public static final boolean isSmallerThan(long[] coordinates, long[] size) {
        for (int i = coordinates.length - 1; i != -1; --i) {
            if (coordinates[i] < size[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean isSmallerOrEqual(long[] coordinates, long[] size) {
        for (int i = coordinates.length - 1; i != -1; --i) {
            if (coordinates[i] <= size[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean isGreaterThan(long[] coordinates, long[] size) {
        for (int i = coordinates.length - 1; i != -1; --i) {
            if (coordinates[i] > size[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean isGreaterOrEqual(long[] coordinates, long[] size) {
        for (int i = coordinates.length - 1; i != -1; --i) {
            if (coordinates[i] >= size[i]) continue;
            return false;
        }
        return true;
    }

    public static final long[] minus(long[] coordinates, long value) {
        return Coordinates.minus(new long[coordinates.length], coordinates, value);
    }

    public static final long[] minus(long[] result, long[] coordinates, long value) {
        for (int i = coordinates.length - 1; i != -1; --i) {
            result[i] = coordinates[i] - value;
        }
        return result;
    }

    public static final long[] plus(long[] coordinates, long value) {
        return Coordinates.plus(new long[coordinates.length], coordinates, value);
    }

    public static final long[] plus(long[] result, long[] coordinates, long value) {
        for (int i = coordinates.length - 1; i != -1; --i) {
            result[i] = coordinates[i] + value;
        }
        return result;
    }

    public static final boolean allEquals(long[] coordinates, long value) {
        for (int i = coordinates.length - 1; i != -1; --i) {
            if (coordinates[i] == value) continue;
            return false;
        }
        return true;
    }

    public static final long manhattenDistance(long[] c1, long[] c2) {
        long distance = 0L;
        for (int i = c1.length - 1; i != -1; --i) {
            distance += Math.abs(c1[i] - c2[i]);
        }
        return distance;
    }

    @Override
    public final int compareTo(Coordinates coordinates) {
        if (coordinates == null) {
            throw new IllegalArgumentException("coordinates cannot be null");
        }
        long distance = Coordinates.manhattenDistance(this.coordinates, coordinates.coordinates);
        return MathUtil.longToIntClip(distance);
    }

    public final long[] getLongCoordinates() {
        return this.coordinates;
    }

    public final long getRow() {
        return this.coordinates[0];
    }

    public final long getColumn() {
        return this.coordinates[1];
    }
}

