/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import org.ujmp.core.Coordinates;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.SparseMatrix;
import org.ujmp.core.SparseMatrix2D;
import org.ujmp.core.bigdecimalmatrix.BaseBigDecimalMatrix;
import org.ujmp.core.bigdecimalmatrix.calculation.ToBigDecimalMatrix;
import org.ujmp.core.bigintegermatrix.BigIntegerMatrix;
import org.ujmp.core.bigintegermatrix.calculation.ToBigIntegerMatrix;
import org.ujmp.core.booleanmatrix.BooleanMatrix;
import org.ujmp.core.booleanmatrix.calculation.And;
import org.ujmp.core.booleanmatrix.calculation.Eq;
import org.ujmp.core.booleanmatrix.calculation.Ge;
import org.ujmp.core.booleanmatrix.calculation.Gt;
import org.ujmp.core.booleanmatrix.calculation.Le;
import org.ujmp.core.booleanmatrix.calculation.Lt;
import org.ujmp.core.booleanmatrix.calculation.Ne;
import org.ujmp.core.booleanmatrix.calculation.Not;
import org.ujmp.core.booleanmatrix.calculation.Or;
import org.ujmp.core.booleanmatrix.calculation.ToBooleanMatrix;
import org.ujmp.core.booleanmatrix.calculation.Xor;
import org.ujmp.core.bytematrix.ByteMatrix;
import org.ujmp.core.bytematrix.calculation.ToByteMatrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.charmatrix.CharMatrix;
import org.ujmp.core.charmatrix.calculation.ToCharMatrix;
import org.ujmp.core.collections.Dictionary;
import org.ujmp.core.collections.list.FastArrayList;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.DoubleMatrix;
import org.ujmp.core.doublematrix.calculation.ToDoubleMatrix;
import org.ujmp.core.doublematrix.calculation.basic.Atimes;
import org.ujmp.core.doublematrix.calculation.basic.DivideMatrix;
import org.ujmp.core.doublematrix.calculation.basic.DivideScalar;
import org.ujmp.core.doublematrix.calculation.basic.MinusMatrix;
import org.ujmp.core.doublematrix.calculation.basic.MinusScalar;
import org.ujmp.core.doublematrix.calculation.basic.Mtimes;
import org.ujmp.core.doublematrix.calculation.basic.PlusMatrix;
import org.ujmp.core.doublematrix.calculation.basic.PlusScalar;
import org.ujmp.core.doublematrix.calculation.basic.TimesMatrix;
import org.ujmp.core.doublematrix.calculation.basic.TimesScalar;
import org.ujmp.core.doublematrix.calculation.entrywise.basic.Abs;
import org.ujmp.core.doublematrix.calculation.entrywise.basic.Exp;
import org.ujmp.core.doublematrix.calculation.entrywise.basic.Log;
import org.ujmp.core.doublematrix.calculation.entrywise.basic.Log10;
import org.ujmp.core.doublematrix.calculation.entrywise.basic.Log2;
import org.ujmp.core.doublematrix.calculation.entrywise.basic.Power;
import org.ujmp.core.doublematrix.calculation.entrywise.basic.Sign;
import org.ujmp.core.doublematrix.calculation.entrywise.basic.Sqrt;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Eye;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.NaNs;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Ones;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Rand;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Randn;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Zeros;
import org.ujmp.core.doublematrix.calculation.entrywise.hyperbolic.Cosh;
import org.ujmp.core.doublematrix.calculation.entrywise.hyperbolic.Sinh;
import org.ujmp.core.doublematrix.calculation.entrywise.hyperbolic.Tanh;
import org.ujmp.core.doublematrix.calculation.entrywise.misc.GrayScale;
import org.ujmp.core.doublematrix.calculation.entrywise.misc.LogisticFunction;
import org.ujmp.core.doublematrix.calculation.entrywise.rounding.Ceil;
import org.ujmp.core.doublematrix.calculation.entrywise.rounding.Floor;
import org.ujmp.core.doublematrix.calculation.entrywise.rounding.Round;
import org.ujmp.core.doublematrix.calculation.entrywise.trigonometric.Cos;
import org.ujmp.core.doublematrix.calculation.entrywise.trigonometric.Sin;
import org.ujmp.core.doublematrix.calculation.entrywise.trigonometric.Tan;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Chol;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Eig;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Ginv;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Inv;
import org.ujmp.core.doublematrix.calculation.general.decomposition.InvSPD;
import org.ujmp.core.doublematrix.calculation.general.decomposition.LU;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Pinv;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Princomp;
import org.ujmp.core.doublematrix.calculation.general.decomposition.QR;
import org.ujmp.core.doublematrix.calculation.general.decomposition.SVD;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Solve;
import org.ujmp.core.doublematrix.calculation.general.decomposition.SolveSPD;
import org.ujmp.core.doublematrix.calculation.general.misc.Center;
import org.ujmp.core.doublematrix.calculation.general.misc.CosineSimilarity;
import org.ujmp.core.doublematrix.calculation.general.misc.DiscretizeToColumns;
import org.ujmp.core.doublematrix.calculation.general.misc.FadeIn;
import org.ujmp.core.doublematrix.calculation.general.misc.FadeOut;
import org.ujmp.core.doublematrix.calculation.general.misc.MinkowskiDistance;
import org.ujmp.core.doublematrix.calculation.general.misc.Normalize;
import org.ujmp.core.doublematrix.calculation.general.misc.Standardize;
import org.ujmp.core.doublematrix.calculation.general.misc.TfIdf;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.AddMissing;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.CountMissing;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.Impute;
import org.ujmp.core.doublematrix.calculation.general.statistical.Corrcoef;
import org.ujmp.core.doublematrix.calculation.general.statistical.Cov;
import org.ujmp.core.doublematrix.calculation.general.statistical.Cumprod;
import org.ujmp.core.doublematrix.calculation.general.statistical.Cumsum;
import org.ujmp.core.doublematrix.calculation.general.statistical.Diff;
import org.ujmp.core.doublematrix.calculation.general.statistical.IndexOfMax;
import org.ujmp.core.doublematrix.calculation.general.statistical.IndexOfMin;
import org.ujmp.core.doublematrix.calculation.general.statistical.Max;
import org.ujmp.core.doublematrix.calculation.general.statistical.Mean;
import org.ujmp.core.doublematrix.calculation.general.statistical.Min;
import org.ujmp.core.doublematrix.calculation.general.statistical.MutualInformation;
import org.ujmp.core.doublematrix.calculation.general.statistical.Prod;
import org.ujmp.core.doublematrix.calculation.general.statistical.Std;
import org.ujmp.core.doublematrix.calculation.general.statistical.Sum;
import org.ujmp.core.doublematrix.calculation.general.statistical.Var;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.export.destinationselector.DefaultMatrixExportDestinationSelector;
import org.ujmp.core.export.destinationselector.MatrixExportDestinationSelector;
import org.ujmp.core.floatmatrix.FloatMatrix;
import org.ujmp.core.floatmatrix.calculation.ToFloatMatrix;
import org.ujmp.core.importer.sourceselector.DefaultMatrixImportSourceSelector;
import org.ujmp.core.importer.sourceselector.MatrixImportSourceSelector;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.core.interfaces.HasColumnMajorDoubleArray1D;
import org.ujmp.core.interfaces.HasLabel;
import org.ujmp.core.interfaces.HasRowMajorDoubleArray2D;
import org.ujmp.core.intmatrix.IntMatrix;
import org.ujmp.core.intmatrix.calculation.Discretize;
import org.ujmp.core.intmatrix.calculation.DiscretizeDictionary;
import org.ujmp.core.intmatrix.calculation.ToIntMatrix;
import org.ujmp.core.listmatrix.DefaultListMatrix;
import org.ujmp.core.listmatrix.ListMatrix;
import org.ujmp.core.longmatrix.LongMatrix;
import org.ujmp.core.longmatrix.calculation.ToLongMatrix;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.matrix.factory.BaseMatrixFactory;
import org.ujmp.core.objectmatrix.ObjectMatrix;
import org.ujmp.core.objectmatrix.calculation.Bootstrap;
import org.ujmp.core.objectmatrix.calculation.Concatenation;
import org.ujmp.core.objectmatrix.calculation.Convert;
import org.ujmp.core.objectmatrix.calculation.Deletion;
import org.ujmp.core.objectmatrix.calculation.Diag;
import org.ujmp.core.objectmatrix.calculation.ExtractAnnotation;
import org.ujmp.core.objectmatrix.calculation.Fill;
import org.ujmp.core.objectmatrix.calculation.Flipdim;
import org.ujmp.core.objectmatrix.calculation.IncludeAnnotation;
import org.ujmp.core.objectmatrix.calculation.Replace;
import org.ujmp.core.objectmatrix.calculation.Reshape;
import org.ujmp.core.objectmatrix.calculation.Selection;
import org.ujmp.core.objectmatrix.calculation.SetContent;
import org.ujmp.core.objectmatrix.calculation.Shuffle;
import org.ujmp.core.objectmatrix.calculation.Sortrows;
import org.ujmp.core.objectmatrix.calculation.Squeeze;
import org.ujmp.core.objectmatrix.calculation.SubMatrix;
import org.ujmp.core.objectmatrix.calculation.Swap;
import org.ujmp.core.objectmatrix.calculation.ToObjectMatrix;
import org.ujmp.core.objectmatrix.calculation.Transpose;
import org.ujmp.core.objectmatrix.calculation.Tril;
import org.ujmp.core.objectmatrix.calculation.Triu;
import org.ujmp.core.objectmatrix.calculation.Unique;
import org.ujmp.core.objectmatrix.calculation.UniqueValueCount;
import org.ujmp.core.objectmatrix.impl.DefaultSparseObjectMatrix;
import org.ujmp.core.setmatrix.DefaultSetMatrix;
import org.ujmp.core.setmatrix.SetMatrix;
import org.ujmp.core.shortmatrix.ShortMatrix;
import org.ujmp.core.shortmatrix.calculation.ToShortMatrix;
import org.ujmp.core.stringmatrix.StringMatrix;
import org.ujmp.core.stringmatrix.calculation.ConvertEncoding;
import org.ujmp.core.stringmatrix.calculation.LowerCase;
import org.ujmp.core.stringmatrix.calculation.RemovePunctuation;
import org.ujmp.core.stringmatrix.calculation.RemoveWords;
import org.ujmp.core.stringmatrix.calculation.ReplaceRegex;
import org.ujmp.core.stringmatrix.calculation.Stem;
import org.ujmp.core.stringmatrix.calculation.ToStringMatrix;
import org.ujmp.core.stringmatrix.calculation.Translate;
import org.ujmp.core.stringmatrix.calculation.UpperCase;
import org.ujmp.core.util.CoordinateIterator;
import org.ujmp.core.util.CoordinateIterator2D;
import org.ujmp.core.util.DecompositionOps;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.SerializationUtil;
import org.ujmp.core.util.StringUtil;
import org.ujmp.core.util.UJMPFormat;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.VerifyUtil;
import org.ujmp.core.util.concurrent.PForEquidistant;
import org.ujmp.core.util.io.MatrixSocketThread;

public abstract class AbstractMatrix
extends Number
implements Matrix {
    private static final long serialVersionUID = 5264103919889924711L;
    private static long runningId = 0L;
    protected transient GUIObject guiObject = null;
    protected long[] size;
    private final long id;
    private MapMatrix<String, Object> metaData = null;

    @Override
    public List<Matrix> getRowList() {
        FastArrayList<Matrix> list = new FastArrayList<Matrix>();
        int r = 0;
        while ((long)r < this.getRowCount()) {
            list.add(this.selectRows(Calculation.Ret.LINK, r));
            ++r;
        }
        return list;
    }

    @Override
    public List<Matrix> getColumnList() {
        FastArrayList<Matrix> list = new FastArrayList<Matrix>();
        int c = 0;
        while ((long)c < this.getColumnCount()) {
            list.add(this.selectRows(Calculation.Ret.LINK, c));
            ++c;
        }
        return list;
    }

    protected AbstractMatrix(long[] size) {
        VerifyUtil.verifyTrue(size.length > 1, "matrix must be at least 2d");
        for (int i = size.length - 1; i != -1; --i) {
            VerifyUtil.verifyTrue(size[i] >= 0L, "coordinates must be positive");
        }
        this.size = size;
        this.id = runningId++;
    }

    public BaseMatrixFactory<? extends Matrix> getFactory() {
        if (this.isSparse()) {
            return SparseMatrix.Factory;
        }
        return DenseMatrix.Factory;
    }

    @Override
    public final Iterable<long[]> allCoordinates() {
        if (this.getDimensionCount() == 2) {
            return new CoordinateIterator2D(this.getSize());
        }
        return new CoordinateIterator(this.getSize());
    }

    @Override
    public final long getCoreObjectId() {
        return this.id;
    }

    @Override
    public double getAsDouble(long ... coordinates) {
        return MathUtil.getDouble(this.getAsObject(coordinates));
    }

    @Override
    public void setAsDouble(double v, long ... coordinates) {
        this.setAsObject(v, coordinates);
    }

    @Override
    public final Object getPreferredObject(long ... coordinates) {
        return MathUtil.getPreferredObject(this.getAsObject(coordinates));
    }

    @Override
    public ValueType getValueType() {
        return ValueType.OBJECT;
    }

    @Override
    public Matrix getMetaDataDimensionMatrix(int dimension) {
        Matrix m;
        if (this.metaData == null) {
            this.metaData = new DefaultMapMatrix<String, Object>(new TreeMap());
        }
        if ((m = (Matrix)this.metaData.get("DimensionMetaData" + dimension)) == null) {
            long[] t = new long[this.getDimensionCount()];
            Arrays.fill(t, 1L);
            m = new DefaultSparseObjectMatrix(t);
            this.metaData.put("DimensionMetaData" + dimension, m);
        }
        return m;
    }

    @Override
    public final Object getDimensionMetaData(int dimension, long ... position) {
        if (this.metaData == null) {
            return null;
        }
        Matrix m = this.getMetaDataDimensionMatrix(dimension);
        long old = position[dimension];
        position[dimension] = 0L;
        Object o = null;
        if (Coordinates.isSmallerThan(position, m.getSize())) {
            o = m.getAsObject(position);
        }
        position[dimension] = old;
        return o;
    }

    @Override
    public void setMetaDataDimensionMatrix(int dimension, Matrix matrix) {
        if (this.metaData == null) {
            this.metaData = new DefaultMapMatrix<String, Object>(new TreeMap());
        }
        this.metaData.put("DimensionMetaData" + dimension, matrix);
    }

    @Override
    public final String getDimensionLabel(int dimension) {
        return this.metaData == null ? null : StringUtil.getString(this.metaData.get("DimensionMetaData" + dimension));
    }

    @Override
    public final void setDimensionMetaData(int dimension, Object label, long ... position) {
        if (this.metaData == null) {
            this.metaData = new DefaultMapMatrix<String, Object>(new TreeMap());
        }
        Matrix m = this.getMetaDataDimensionMatrix(dimension);
        long old = position[dimension];
        position[dimension] = 0L;
        if (!Coordinates.isSmallerThan(position, m.getSize())) {
            long[] newSize = Coordinates.max(m.getSize(), Coordinates.plus(position, 1L));
            m.setSize(newSize);
        }
        m.setAsObject(label, position);
        position[dimension] = old;
    }

    @Override
    public final void setDimensionLabel(int dimension, Object label) {
        if (this.metaData == null) {
            this.metaData = new DefaultMapMatrix<String, Object>(new TreeMap());
        }
        Matrix m = this.getMetaDataDimensionMatrix(dimension);
        m.setLabel(label);
    }

    @Override
    public GUIObject getGUIObject() {
        if (this.guiObject == null) {
            try {
                Class<?> c = Class.forName("org.ujmp.gui.DefaultMatrixGUIObject");
                Constructor<?> con = c.getConstructor(Matrix.class);
                this.guiObject = (GUIObject)con.newInstance(this);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot create matrix gui object", e);
            }
        }
        return this.guiObject;
    }

    @Override
    public final boolean containsMissingValues() {
        for (long[] c : this.allCoordinates()) {
            double v = this.getAsDouble(c);
            if (!MathUtil.isNaNOrInfinite(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getDimensionCount() {
        return this.getSize().length;
    }

    @Override
    public final double getEuklideanValue() {
        double sum = 0.0;
        for (long[] c : this.allCoordinates()) {
            sum += Math.pow(this.getAsDouble(c), 2.0);
        }
        return Math.sqrt(sum);
    }

    @Override
    public Matrix clone() {
        return Convert.calcNew(this);
    }

    @Override
    public final Matrix select(Calculation.Ret returnType, long[] ... selection) {
        return new Selection((Matrix)this, selection).calc(returnType);
    }

    @Override
    public void save(String filename) throws IOException {
        this.save(new File(filename));
    }

    @Override
    public void save(File file) throws IOException {
        SerializationUtil.saveCompressed(file, (Object)this);
    }

    @Override
    public final Matrix select(Calculation.Ret returnType, Collection<? extends Number> ... selection) {
        return new Selection((Matrix)this, selection).calc(returnType);
    }

    @Override
    public Matrix selectRows(Calculation.Ret returnType, long ... rows) {
        return this.select(returnType, rows, null);
    }

    @Override
    public final Matrix select(Calculation.Ret returnType, String selection) {
        return new Selection((Matrix)this, selection).calc(returnType);
    }

    @Override
    public Matrix selectColumns(Calculation.Ret returnType, long ... columns) {
        return this.select(returnType, null, columns);
    }

    @Override
    public final Matrix selectRows(Calculation.Ret returnType, Collection<? extends Number> rows) {
        return this.select(returnType, rows, null);
    }

    @Override
    public final Matrix selectColumns(Calculation.Ret returnType, Collection<? extends Number> columns) {
        return this.select(returnType, null, columns);
    }

    @Override
    public Matrix impute(Calculation.Ret returnType, Impute.ImputationMethod method, Object ... parameters) {
        return new Impute((Matrix)this, method, parameters).calc(returnType);
    }

    @Override
    public Matrix discretize(Calculation.Ret returnType, int dimension, Discretize.DiscretizationMethod method, int numberOfBins) {
        return new Discretize((Matrix)this, dimension, method, numberOfBins).calc(returnType);
    }

    @Override
    public Matrix discretize(Calculation.Ret returnType, Dictionary dictionary) {
        return new DiscretizeDictionary((Matrix)this, dictionary).calc(returnType);
    }

    @Override
    public Matrix discretizeToBoolean(int targetColumnCount) {
        SparseMatrix ret = SparseMatrix2D.Factory.zeros(this.getRowCount(), (long)targetColumnCount);
        for (long[] c : this.availableCoordinates()) {
            Object o = this.getAsObject(c);
            String s = "col" + c[1] + ":" + o;
            ret.setAsBoolean(true, c[0], Math.abs(s.hashCode()) % targetColumnCount);
        }
        return ret;
    }

    @Override
    public Matrix indexOfMax(Calculation.Ret returnType, int dimension) {
        return new IndexOfMax(dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix indexOfMin(Calculation.Ret returnType, int dimension) {
        return new IndexOfMin(dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix standardize(Calculation.Ret returnType, int dimension) {
        return new Standardize(dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix normalize(Calculation.Ret returnType, int dimension) {
        return new Normalize(dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix atimes(Calculation.Ret returnType, boolean ignoreNaN, Matrix matrix) {
        return new Atimes(ignoreNaN, (Matrix)this, matrix).calc(returnType);
    }

    @Override
    public Matrix inv() {
        return Inv.INSTANCE.calc(this);
    }

    @Override
    public Matrix invSymm() {
        return Inv.INSTANCE.calc(this);
    }

    @Override
    public Matrix invSPD() {
        return InvSPD.INSTANCE.calc(this);
    }

    @Override
    public Matrix solve(Matrix b) {
        return Solve.INSTANCE.calc(this, b);
    }

    @Override
    public Matrix solveSymm(Matrix b) {
        return Solve.INSTANCE.calc(this, b);
    }

    @Override
    public Matrix solveSPD(Matrix b) {
        return SolveSPD.INSTANCE.calc(this, b);
    }

    @Override
    public Matrix ginv() {
        return new Ginv((Matrix)this).calcNew();
    }

    @Override
    public Matrix princomp() {
        return new Princomp((Matrix)this).calcNew();
    }

    @Override
    public Matrix pinv() {
        return new Pinv((Matrix)this).calcNew();
    }

    @Override
    public Matrix pinv(int k) {
        Matrix[] usv = this.svd(k);
        Matrix u = usv[0];
        Matrix s = usv[1];
        Matrix v = usv[2];
        int i = (int)Math.min(s.getRowCount(), s.getColumnCount());
        while (--i >= 0) {
            long[] lArray = new long[]{i, i};
            double d = s.getAsDouble(lArray);
            if (Math.abs(d) > UJMPSettings.getInstance().getTolerance()) {
                s.setAsDouble(1.0 / d, i, i);
                continue;
            }
            s.setAsDouble(0.0, i, i);
        }
        return v.mtimes(s.transpose()).mtimes(u.transpose());
    }

    @Override
    public Matrix center(Calculation.Ret returnType, int dimension, boolean ignoreNaN) {
        return new Center(ignoreNaN, dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public boolean isResizable() {
        return false;
    }

    @Override
    public final Matrix convert(ValueType newValueType) {
        return Convert.calcNew(newValueType, this);
    }

    @Override
    public final Matrix replaceRegex(Calculation.Ret returnType, Pattern search, String replacement) {
        return new ReplaceRegex((Matrix)this, search, replacement).calc(returnType);
    }

    @Override
    public final Matrix replace(Calculation.Ret returnType, Object search, Object replacement) {
        return new Replace((Matrix)this, search, replacement).calc(returnType);
    }

    @Override
    public final Matrix replaceRegex(Calculation.Ret returnType, String search, String replacement) {
        return new ReplaceRegex((Matrix)this, search, replacement).calc(returnType);
    }

    @Override
    public Matrix times(double factor) {
        Matrix result = this.getFactory().zeros(this.getSize());
        Matrix.timesScalar.calc((Matrix)this, factor, result);
        return result;
    }

    @Override
    public Matrix tanh() {
        int rows = MathUtil.longToInt(this.getRowCount());
        final int cols = MathUtil.longToInt(this.getColumnCount());
        final DenseMatrix result = Matrix.Factory.zeros((long)rows, (long)cols);
        if (UJMPSettings.getInstance().getNumberOfThreads() > 1 && rows >= 100 && cols >= 100) {
            new PForEquidistant(0, rows - 1, new Object[0]){

                @Override
                public void step(int i) {
                    for (int c = 0; c < cols; ++c) {
                        result.setAsDouble(Math.tanh(AbstractMatrix.this.getAsDouble(i, c)), i, c);
                    }
                }
            };
        } else {
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < cols; ++c) {
                    result.setAsDouble(Math.tanh(this.getAsDouble(r, c)), r, c);
                }
            }
        }
        return result;
    }

    @Override
    public Matrix times(Matrix m) {
        Matrix result = this.getFactory().zeros(this.getSize());
        Matrix.timesMatrix.calc(this, m, result);
        return result;
    }

    @Override
    public Matrix divide(Matrix m) {
        Matrix result = this.getFactory().zeros(this.getSize());
        Matrix.divideMatrix.calc(this, m, result);
        return result;
    }

    @Override
    public Matrix divide(double divisor) {
        Matrix result = this.getFactory().zeros(this.getSize());
        Matrix.divideScalar.calc((Matrix)this, divisor, result);
        return result;
    }

    @Override
    public Matrix divide(Calculation.Ret returnType, boolean ignoreNaN, double factor) {
        return new DivideScalar(ignoreNaN, (Matrix)this, factor).calc(returnType);
    }

    @Override
    public Matrix times(Calculation.Ret returnType, boolean ignoreNaN, double factor) {
        return new TimesScalar(ignoreNaN, (Matrix)this, factor).calc(returnType);
    }

    @Override
    public Matrix times(Calculation.Ret returnType, boolean ignoreNaN, Matrix factor) {
        return new TimesMatrix(ignoreNaN, (Matrix)this, factor).calc(returnType);
    }

    @Override
    public Matrix divide(Calculation.Ret returnType, boolean ignoreNaN, Matrix factor) {
        return new DivideMatrix(ignoreNaN, (Matrix)this, factor).calc(returnType);
    }

    @Override
    public final Matrix power(Calculation.Ret returnType, double power) {
        return new Power((Matrix)this, power).calc(returnType);
    }

    @Override
    public final Matrix power(Calculation.Ret returnType, Matrix power) {
        return new Power((Matrix)this, power).calc(returnType);
    }

    @Override
    public final Matrix gt(Calculation.Ret returnType, Matrix matrix) {
        return new Gt((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix gt(Calculation.Ret returnType, double value) {
        return new Gt((Matrix)this, value).calc(returnType);
    }

    @Override
    public final Matrix and(Calculation.Ret returnType, Matrix matrix) {
        return new And((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix and(Calculation.Ret returnType, boolean value) {
        return new And((Matrix)this, value).calc(returnType);
    }

    @Override
    public final Matrix or(Calculation.Ret returnType, Matrix matrix) {
        return new Or((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix or(Calculation.Ret returnType, boolean value) {
        return new Or((Matrix)this, value).calc(returnType);
    }

    @Override
    public final Matrix xor(Calculation.Ret returnType, Matrix matrix) {
        return new Xor((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix xor(Calculation.Ret returnType, boolean value) {
        return new Xor((Matrix)this, value).calc(returnType);
    }

    @Override
    public final Matrix not(Calculation.Ret returnType) {
        return new Not((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix lt(Calculation.Ret returnType, Matrix matrix) {
        return new Lt((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix lt(Calculation.Ret returnType, double value) {
        return new Lt((Matrix)this, value).calc(returnType);
    }

    @Override
    public final Matrix ge(Calculation.Ret returnType, Matrix matrix) {
        return new Ge((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix ge(Calculation.Ret returnType, double value) {
        return new Ge((Matrix)this, value).calc(returnType);
    }

    @Override
    public final Matrix le(Calculation.Ret returnType, Matrix matrix) {
        return new Le((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix le(Calculation.Ret returnType, double value) {
        return new Le((Matrix)this, value).calc(returnType);
    }

    @Override
    public final Matrix eq(Calculation.Ret returnType, Matrix matrix) {
        return new Eq((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix eq(Calculation.Ret returnType, Object value) {
        return new Eq((Matrix)this, value).calc(returnType);
    }

    @Override
    public final Matrix ne(Calculation.Ret returnType, Matrix matrix) {
        return new Ne((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix ne(Calculation.Ret returnType, Object value) {
        return new Ne((Matrix)this, value).calc(returnType);
    }

    @Override
    public long getValueCount() {
        return Coordinates.product(this.getSize());
    }

    @Override
    public final long[] getCoordinatesOfMaximum() {
        double max = -1.7976931348623157E308;
        long[] maxc = Coordinates.copyOf(this.getSize());
        Arrays.fill(maxc, -1L);
        for (long[] c : this.allCoordinates()) {
            double v = this.getAsDouble(c);
            if (!(v > max)) continue;
            max = v;
            maxc = Coordinates.copyOf(c);
        }
        return maxc;
    }

    @Override
    public final long[] getCoordinatesOfMinimum() {
        double min = Double.MAX_VALUE;
        long[] minc = Coordinates.copyOf(this.getSize());
        Arrays.fill(minc, -1L);
        for (long[] c : this.allCoordinates()) {
            double v = this.getAsDouble(c);
            if (!(v < min)) continue;
            min = v;
            minc = Coordinates.copyOf(c);
        }
        return minc;
    }

    @Override
    public Iterable<long[]> selectedCoordinates(String selection) {
        return this.select(Calculation.Ret.LINK, selection).allCoordinates();
    }

    @Override
    public Iterable<long[]> selectedCoordinates(long[] ... selection) {
        return this.select(Calculation.Ret.LINK, selection).allCoordinates();
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public Iterable<long[]> nonZeroCoordinates() {
        return this.availableCoordinates();
    }

    @Override
    public double[][] toDoubleArray() {
        int rows = (int)this.getRowCount();
        int columns = (int)this.getColumnCount();
        double[][] values = new double[rows][columns];
        if (this instanceof HasColumnMajorDoubleArray1D) {
            double[] m = ((HasColumnMajorDoubleArray1D)((Object)this)).getColumnMajorDoubleArray1D();
            for (int r = 0; r < rows; ++r) {
                double[] valuesr = values[r];
                for (int c = 0; c < columns; ++c) {
                    valuesr[c] = m[c * rows + r];
                }
            }
        } else if (this instanceof HasRowMajorDoubleArray2D) {
            double[][] m = ((HasRowMajorDoubleArray2D)((Object)this)).getRowMajorDoubleArray2D();
            for (int r = 0; r < rows; ++r) {
                System.arraycopy(m[r], 0, values[r], 0, columns);
            }
        } else if (this instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D m = (DenseDoubleMatrix2D)((Object)this);
            for (int r = 0; r < rows; ++r) {
                double[] valuesr = values[r];
                for (int c = 0; c < columns; ++c) {
                    valuesr[c] = m.getDouble(r, c);
                }
            }
        } else {
            for (int r = 0; r < rows; ++r) {
                double[] valuesr = values[r];
                for (int c = 0; c < columns; ++c) {
                    valuesr[c] = this.getAsDouble(r, c);
                }
            }
        }
        return values;
    }

    @Override
    public Object[][] toObjectArray() {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        Object[][] values = new Object[r][c];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                values[i][j] = this.getAsObject(i, j);
            }
        }
        return values;
    }

    @Override
    public int[][] toIntArray() {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        int[][] values = new int[r][c];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                values[i][j] = this.getAsInt(i, j);
            }
        }
        return values;
    }

    @Override
    public long[][] toLongArray() {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        long[][] values = new long[r][c];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                values[i][j] = this.getAsLong(i, j);
            }
        }
        return values;
    }

    @Override
    public short[][] toShortArray() {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        short[][] values = new short[r][c];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                values[i][j] = this.getAsShort(i, j);
            }
        }
        return values;
    }

    @Override
    public char[][] toCharArray() {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        char[][] values = new char[r][c];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                values[i][j] = this.getAsChar(i, j);
            }
        }
        return values;
    }

    @Override
    public String[][] toStringArray() {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        String[][] values = new String[r][c];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                values[i][j] = this.getAsString(i, j);
            }
        }
        return values;
    }

    @Override
    public byte[][] toByteArray() {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        byte[][] values = new byte[r][c];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                values[i][j] = this.getAsByte(i, j);
            }
        }
        return values;
    }

    @Override
    public boolean[][] toBooleanArray() {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        boolean[][] values = new boolean[r][c];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                values[i][j] = this.getAsBoolean(i, j);
            }
        }
        return values;
    }

    @Override
    public float[][] toFloatArray() {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        float[][] values = new float[r][c];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                values[i][j] = this.getAsFloat(i, j);
            }
        }
        return values;
    }

    @Override
    public Date[][] toDateArray() {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        Date[][] values = new Date[r][c];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                values[i][j] = this.getAsDate(i, j);
            }
        }
        return values;
    }

    @Override
    public BigDecimal[][] toBigDecimalArray() {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        BigDecimal[][] values = new BigDecimal[r][c];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                values[i][j] = this.getAsBigDecimal(i, j);
            }
        }
        return values;
    }

    @Override
    public BigInteger[][] toBigIntegerArray() {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        BigInteger[][] values = new BigInteger[r][c];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                values[i][j] = this.getAsBigInteger(i, j);
            }
        }
        return values;
    }

    @Override
    public final Matrix sqrt(Calculation.Ret returnType) {
        return new Sqrt((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix round(Calculation.Ret returnType) {
        return new Round((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix ceil(Calculation.Ret returnType) {
        return new Ceil((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix extractAnnotation(Calculation.Ret returnType, int dimension) {
        return new ExtractAnnotation((Matrix)this, dimension).calc(returnType);
    }

    @Override
    public final Matrix includeAnnotation(Calculation.Ret returnType, int dimension) {
        return new IncludeAnnotation((Matrix)this, dimension).calc(returnType);
    }

    @Override
    public final Matrix floor(Calculation.Ret returnType) {
        return new Floor((Matrix)this).calc(returnType);
    }

    @Override
    public final JFrame showGUI() {
        try {
            Class<?> c = Class.forName("org.ujmp.gui.util.FrameManager");
            Method method = c.getMethod("showFrame", GUIObject.class);
            Object o = method.invoke(null, this.getGUIObject());
            return (JFrame)o;
        }
        catch (Exception e) {
            throw new RuntimeException("cannot show GUI", e);
        }
    }

    @Override
    public void fireValueChanged() {
        if (this.guiObject != null) {
            this.guiObject.fireValueChanged();
        }
    }

    @Override
    public void fireValueChanged(Coordinates coordinates, Object object) {
        if (this.guiObject != null) {
            this.guiObject.fireValueChanged(coordinates, object);
        }
    }

    @Override
    public void fireValueChanged(Coordinates start, Coordinates end) {
        if (this.guiObject != null) {
            this.guiObject.fireValueChanged(start, end);
        }
    }

    @Override
    public Matrix mtimes(Matrix matrix) {
        Matrix result = this.getFactory().zeros(this.getRowCount(), matrix.getColumnCount());
        Matrix.mtimes.calc(this, matrix, result);
        return result;
    }

    @Override
    public Matrix mtimes(Calculation.Ret returnType, boolean ignoreNaN, Matrix matrix) {
        return new Mtimes(ignoreNaN, (Matrix)this, matrix).calc(returnType);
    }

    @Override
    public boolean getAsBoolean(long ... coordinates) {
        return MathUtil.getBoolean(this.getAsObject(coordinates));
    }

    @Override
    public void setAsBoolean(boolean value, long ... coordinates) {
        this.setAsDouble(value ? 1.0 : 0.0, coordinates);
    }

    @Override
    public int getAsInt(long ... coordinates) {
        return (int)this.getAsDouble(coordinates);
    }

    @Override
    public void setAsInt(int value, long ... coordinates) {
        this.setAsDouble(value, coordinates);
    }

    @Override
    public byte getAsByte(long ... coordinates) {
        return (byte)this.getAsDouble(coordinates);
    }

    @Override
    public byte[] getAsByteArray(long ... coordinates) {
        Object o = this.getAsObject(coordinates);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return ((String)o).getBytes();
        }
        return null;
    }

    @Override
    public void setAsByteArray(byte[] value, long ... coordinates) {
        if (value == null) {
            this.setAsObject(null, coordinates);
        } else {
            this.setAsString(new String(value), new long[0]);
        }
    }

    @Override
    public void setAsByte(byte value, long ... coordinates) {
        this.setAsDouble(value, coordinates);
    }

    @Override
    public char getAsChar(long ... coordinates) {
        return (char)this.getAsDouble(coordinates);
    }

    @Override
    public BigInteger getAsBigInteger(long ... coordinates) {
        return MathUtil.getBigInteger(this.getAsObject(coordinates));
    }

    @Override
    public BigDecimal getAsBigDecimal(long ... coordinates) {
        return MathUtil.getBigDecimal(this.getAsObject(coordinates));
    }

    @Override
    public void setAsChar(char value, long ... coordinates) {
        this.setAsDouble(value, coordinates);
    }

    @Override
    public void setAsBigDecimal(BigDecimal value, long ... coordinates) {
        if (value == null) {
            this.setAsDouble(Double.NaN, coordinates);
        } else {
            this.setAsDouble(value.doubleValue(), coordinates);
        }
    }

    @Override
    public void setAsBigInteger(BigInteger value, long ... coordinates) {
        if (value == null) {
            this.setAsLong(0L, coordinates);
        } else {
            this.setAsLong(value.longValue(), coordinates);
        }
    }

    @Override
    public float getAsFloat(long ... coordinates) {
        return (float)this.getAsDouble(coordinates);
    }

    @Override
    public void setAsFloat(float value, long ... coordinates) {
        this.setAsDouble(value, coordinates);
    }

    @Override
    public short getAsShort(long ... coordinates) {
        return (short)this.getAsDouble(coordinates);
    }

    @Override
    public Matrix getAsMatrix(long ... coordinates) {
        return MathUtil.getMatrix(this.getAsObject(coordinates));
    }

    @Override
    public void setAsMatrix(Matrix m, long ... coordinates) {
        this.setAsObject(m, coordinates);
    }

    @Override
    public void setAsShort(short value, long ... coordinates) {
        this.setAsDouble(value, coordinates);
    }

    @Override
    public long getAsLong(long ... coordinates) {
        return (long)this.getAsDouble(coordinates);
    }

    @Override
    public void setAsLong(long value, long ... coordinates) {
        this.setAsDouble(value, coordinates);
    }

    @Override
    public Date getAsDate(long ... coordinates) {
        return MathUtil.getDate(this.getAsObject(coordinates));
    }

    @Override
    public void setAsDate(Date date, long ... coordinates) {
        this.setAsObject(date, coordinates);
    }

    @Override
    public final Matrix delete(Calculation.Ret returnType, String selection) {
        return new Deletion((Matrix)this, selection).calc(returnType);
    }

    @Override
    public final Matrix delete(Calculation.Ret returnType, Collection<? extends Number> ... selection) {
        return new Deletion((Matrix)this, selection).calc(returnType);
    }

    @Override
    public final Matrix delete(Calculation.Ret returnType, long[] ... selection) {
        return new Deletion((Matrix)this, selection).calc(returnType);
    }

    @Override
    public final Matrix deleteRows(Calculation.Ret returnType, long ... rows) {
        return this.delete(returnType, rows, new long[0]);
    }

    @Override
    public final Matrix deleteRows(Calculation.Ret returnType, Collection<? extends Number> rows) {
        return this.delete(returnType, rows, new ArrayList());
    }

    @Override
    public final Matrix deleteColumns(Calculation.Ret returnType, Collection<? extends Number> columns) {
        return this.delete(returnType, new ArrayList(), columns);
    }

    @Override
    public final Matrix deleteColumns(Calculation.Ret returnType, long ... columns) {
        return this.delete(returnType, new long[0], columns);
    }

    @Override
    public Matrix minus(Calculation.Ret returnType, boolean ignoreNaN, double v) {
        return new MinusScalar(ignoreNaN, (Matrix)this, v).calc(returnType);
    }

    @Override
    public Matrix minus(Calculation.Ret returnType, boolean ignoreNaN, Matrix m) {
        return new MinusMatrix(ignoreNaN, (Matrix)this, m).calc(returnType);
    }

    @Override
    public Matrix plus(Calculation.Ret returnType, boolean ignoreNaN, double v) {
        return new PlusScalar(ignoreNaN, (Matrix)this, v).calc(returnType);
    }

    @Override
    public Matrix plus(Calculation.Ret returnType, boolean ignoreNaN, Matrix m) {
        return new PlusMatrix(ignoreNaN, (Matrix)this, m).calc(returnType);
    }

    @Override
    public Matrix transpose() {
        Matrix result = this.getFactory().zeros(Coordinates.transpose(this.getSize()));
        Matrix.transpose.calc(this, result);
        return result;
    }

    @Override
    public Matrix transpose(Calculation.Ret returnType) {
        return new Transpose((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix diag(Calculation.Ret returnType) {
        return new Diag((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix mean(Calculation.Ret returnType, int dimension, boolean ignoreNaN) {
        return new Mean(dimension, ignoreNaN, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix var(Calculation.Ret returnType, int dimension, boolean ignoreNaN, boolean besselsCorrection) {
        return new Var(dimension, ignoreNaN, (Matrix)this, besselsCorrection).calc(returnType);
    }

    @Override
    public Matrix std(Calculation.Ret returnType, int dimension, boolean ignoreNaN, boolean besselsCorrection) {
        return new Std(dimension, ignoreNaN, (Matrix)this, besselsCorrection).calc(returnType);
    }

    @Override
    public long getColumnCount() {
        return this.getSize(1);
    }

    @Override
    public long getRowCount() {
        return this.getSize(0);
    }

    @Override
    public long getZCount() {
        return this.getSize(2);
    }

    @Override
    public final long getSize(int dimension) {
        return this.getSize()[dimension];
    }

    @Override
    public long[] getSize() {
        return this.size;
    }

    @Override
    public Matrix prod(Calculation.Ret returnType, int dimension, boolean ignoreNaN) {
        return new Prod(dimension, ignoreNaN, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix diff(Calculation.Ret returnType, int dimension, boolean ignoreNaN) {
        return new Diff(dimension, ignoreNaN, (Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix sum(Calculation.Ret returnType, int dimension, boolean ignoreNaN) {
        return new Sum(dimension, ignoreNaN, (Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix sign(Calculation.Ret returnType) {
        return new Sign((Matrix)this).calc(returnType);
    }

    @Override
    public String toString() {
        return UJMPFormat.getMultiLineInstance().format(this);
    }

    @Override
    public String toHtml() {
        try {
            return this.exportTo().string().asHtml();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final Matrix ones(Calculation.Ret ret) {
        return new Ones((Matrix)this).calc(ret);
    }

    @Override
    public final Matrix nans(Calculation.Ret ret) {
        return new NaNs((Matrix)this).calc(ret);
    }

    @Override
    public final Matrix fill(Calculation.Ret ret, Object value) {
        return new Fill((Matrix)this, value).calc(ret);
    }

    @Override
    public final Matrix zeros(Calculation.Ret ret) {
        return new Zeros((Matrix)this).calc(ret);
    }

    @Override
    public final Matrix eye(Calculation.Ret ret) {
        return new Eye((Matrix)this).calc(ret);
    }

    @Override
    public Matrix plus(double value) {
        Matrix result = this.getFactory().zeros(this.getSize());
        Matrix.plusScalar.calc((Matrix)this, value, result);
        return result;
    }

    @Override
    public Matrix plus(Matrix m) {
        Matrix result = this.getFactory().zeros(this.getSize());
        Matrix.plusMatrix.calc(this, m, result);
        return result;
    }

    @Override
    public Matrix minus(double value) {
        Matrix result = this.getFactory().zeros(this.getSize());
        Matrix.minusScalar.calc((Matrix)this, value, result);
        return result;
    }

    @Override
    public Matrix minus(Matrix m) {
        Matrix result = this.getFactory().zeros(this.getSize());
        Matrix.minusMatrix.calc(this, m, result);
        return result;
    }

    @Override
    public final Matrix rand(Calculation.Ret ret) {
        return new Rand((Matrix)this).calc(ret);
    }

    @Override
    public final Matrix randn(Calculation.Ret ret) {
        return new Randn((Matrix)this).calc(ret);
    }

    @Override
    public int compareTo(Matrix m) {
        double v1 = this.doubleValue();
        double v2 = m.doubleValue();
        return new Double(v1).compareTo(v2);
    }

    @Override
    public int rank() {
        int rank = 0;
        Matrix[] usv = this.svd();
        Matrix s = usv[1];
        int i = (int)Math.min(s.getSize(0), s.getSize(1));
        while (--i >= 0) {
            long[] lArray = new long[]{i, i};
            if (!(Math.abs(s.getAsDouble(lArray)) > UJMPSettings.getInstance().getTolerance())) continue;
            ++rank;
        }
        return rank;
    }

    @Override
    public final boolean isSPD() {
        if (this.getDimensionCount() != 2) {
            return false;
        }
        if (!this.isSquare()) {
            return false;
        }
        return new Chol.CholMatrix(this).isSPD();
    }

    @Override
    public final boolean isSymmetric() {
        if (this.getDimensionCount() != 2) {
            throw new RuntimeException("only supported for 2d matrices");
        }
        if (this.isSquare()) {
            return false;
        }
        if (this instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D m = (DenseDoubleMatrix2D)((Object)this);
            long r = this.getRowCount();
            while (--r >= 0L) {
                long c = this.getColumnCount();
                while (--c >= 0L) {
                    if (m.getDouble(r, c) == m.getDouble(c, r)) continue;
                    return false;
                }
            }
        } else {
            for (long[] c : this.availableCoordinates()) {
                Object o2;
                Object o1 = this.getAsObject(c);
                if (MathUtil.equals(o1, o2 = this.getAsObject(Coordinates.transpose(c)))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsDouble(c) == 0.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Matrix abs(Calculation.Ret returnType) {
        return new Abs((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix log(Calculation.Ret returnType) {
        return new Log((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix setContent(Calculation.Ret returnType, Matrix newContent, long ... position) {
        return new SetContent((Matrix)this, newContent, position).calc(returnType);
    }

    @Override
    public final Matrix exp(Calculation.Ret returnType) {
        return new Exp((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix logistic(Calculation.Ret returnType) {
        return new LogisticFunction((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix sortrows(Calculation.Ret returnType, long column, boolean reverse) {
        return new Sortrows((Matrix)this, column, reverse).calc(returnType);
    }

    @Override
    public final Matrix cumsum(boolean ignoreNaN) {
        return new Cumsum((Matrix)this, ignoreNaN).calcNew();
    }

    @Override
    public final Matrix cumprod(boolean ignoreNaN) {
        return new Cumprod((Matrix)this, ignoreNaN).calcNew();
    }

    @Override
    public final Matrix log2(Calculation.Ret returnType) {
        return new Log2((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix log10(Calculation.Ret returnType) {
        return new Log10((Matrix)this).calc(returnType);
    }

    @Override
    public final boolean isDiagonal() {
        if (!this.isSquare()) {
            return false;
        }
        for (long[] c : this.allCoordinates()) {
            double v = this.getAsDouble(c);
            if (v == 0.0) continue;
            for (int i = 1; i < c.length; ++i) {
                if (c[i - 1] == c[i]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean isSquare() {
        return this.getDimensionCount() == 2 && this.getColumnCount() == this.getRowCount();
    }

    @Override
    public double euklideanDistanceTo(Matrix m, boolean ignoreNaN) {
        return this.minkowskiDistanceTo(m, 2.0, ignoreNaN);
    }

    @Override
    public double det() {
        if (this.getDimensionCount() != 2 || !this.isSquare()) {
            throw new RuntimeException("only supported for 2d square matrices");
        }
        return new LU.LUMatrix(this).det();
    }

    @Override
    public double pdet() {
        Matrix s = this.svd()[1];
        double prod = 1.0;
        int i = 0;
        while ((long)i < s.getRowCount()) {
            long[] lArray = new long[]{i, i};
            double v = s.getAsDouble(lArray);
            if (v > 0.0) {
                prod *= v;
            }
            ++i;
        }
        return prod;
    }

    @Override
    public boolean isSingular() {
        if (this.getDimensionCount() != 2 || !this.isSquare()) {
            return false;
        }
        return !new LU.LUMatrix(this).isNonsingular();
    }

    @Override
    public double manhattenDistanceTo(Matrix m, boolean ignoreNaN) {
        return this.minkowskiDistanceTo(m, 1.0, ignoreNaN);
    }

    @Override
    public Matrix manhattenDistance(Calculation.Ret returnType, boolean ignoreNaN) {
        return this.minkowskiDistance(returnType, 1.0, ignoreNaN);
    }

    @Override
    public Matrix euklideanDistance(Calculation.Ret returnType, boolean ignoreNaN) {
        return this.minkowskiDistance(returnType, 2.0, ignoreNaN);
    }

    @Override
    public final Matrix minkowskiDistance(Calculation.Ret returnType, double p, boolean ignoreNaN) {
        return new MinkowskiDistance((Matrix)this, p, ignoreNaN).calc(returnType);
    }

    @Override
    public final Matrix cosineSimilarity(Calculation.Ret returnType, boolean ignoreNaN) {
        return new CosineSimilarity((Matrix)this, ignoreNaN).calc(returnType);
    }

    @Override
    public double cosineSimilarityTo(Matrix m, boolean ignoreNaN) {
        return CosineSimilarity.getCosineSimilartiy(this, m, ignoreNaN);
    }

    @Override
    public double minkowskiDistanceTo(Matrix m, double p, boolean ignoreNaN) {
        double sum = 0.0;
        if (ignoreNaN) {
            for (long[] c : this.allCoordinates()) {
                sum += MathUtil.ignoreNaN(Math.pow(Math.abs(this.getAsDouble(c) - m.getAsDouble(c)), p));
            }
        } else {
            for (long[] c : this.allCoordinates()) {
                sum += Math.pow(Math.abs(this.getAsDouble(c) - m.getAsDouble(c)), p);
            }
        }
        return Math.pow(sum, 1.0 / p);
    }

    @Override
    public double chebyshevDistanceTo(Matrix m, boolean ignoreNaN) {
        double max = 0.0;
        if (ignoreNaN) {
            for (long[] c : this.allCoordinates()) {
                double v = MathUtil.ignoreNaN(Math.abs(this.getAsDouble(c) - m.getAsDouble(c)));
                max = v > max ? v : max;
            }
        } else {
            for (long[] c : this.allCoordinates()) {
                double v = Math.abs(this.getAsDouble(c) - m.getAsDouble(c));
                max = v > max ? v : max;
            }
        }
        return max;
    }

    @Override
    public Matrix min(Calculation.Ret returnType, int dimension) {
        return new Min(dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix max(Calculation.Ret returnType, int dimension) {
        return new Max(dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix addMissing(Calculation.Ret returnType, int dimension, double ... percentMissing) {
        return new AddMissing(dimension, (Matrix)this, percentMissing).calc(returnType);
    }

    @Override
    public Matrix countMissing(Calculation.Ret returnType, int dimension) {
        return new CountMissing(dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public final boolean isScalar() {
        return Coordinates.product(this.getSize()) == 1L;
    }

    @Override
    public final boolean isRowVector() {
        return this.getColumnCount() == 1L && this.getRowCount() != 1L;
    }

    @Override
    public final boolean isColumnVector() {
        return this.getColumnCount() != 1L && this.getRowCount() == 1L;
    }

    @Override
    public final boolean isMultidimensionalMatrix() {
        return this.getColumnCount() != 1L && this.getRowCount() != 1L;
    }

    @Override
    public Matrix sinh(Calculation.Ret returnType) {
        return new Sinh((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix cosh(Calculation.Ret returnType) {
        return new Cosh((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix tanh(Calculation.Ret returnType) {
        return new Tanh((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix sin(Calculation.Ret returnType) {
        return new Sin((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix cos(Calculation.Ret returnType) {
        return new Cos((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix tril(Calculation.Ret returnType, int k) {
        return new Tril((Matrix)this, k).calc(returnType);
    }

    @Override
    public Matrix triu(Calculation.Ret returnType, int k) {
        return new Triu((Matrix)this, k).calc(returnType);
    }

    @Override
    public Matrix tan(Calculation.Ret returnType) {
        return new Tan((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix cov(Calculation.Ret returnType, boolean ignoreNaN, boolean besselsCorrection) {
        return new Cov(ignoreNaN, (Matrix)this, besselsCorrection).calc(returnType);
    }

    @Override
    public Matrix corrcoef(Calculation.Ret returnType, boolean ignoreNaN, boolean besselsCorrection) {
        return new Corrcoef(ignoreNaN, (Matrix)this, besselsCorrection).calc(returnType);
    }

    @Override
    public Matrix mutualInf(Calculation.Ret returnType) {
        return new MutualInformation((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix pairedTTest(Calculation.Ret returnType) {
        try {
            Class<?> c = Class.forName("org.ujmp.commonsmath.PairedTTest");
            Constructor<?> con = c.getConstructor(Matrix.class);
            Calculation calc = (Calculation)con.newInstance(this);
            return calc.calc(returnType);
        }
        catch (Exception e) {
            throw new RuntimeException("could not calculate", e);
        }
    }

    @Override
    public Matrix bootstrap(Calculation.Ret returnType) {
        return new Bootstrap((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix grayScale(Calculation.Ret returnType, GrayScale.ColorChannel colorChannel) {
        return new GrayScale((Matrix)this, colorChannel).calc(returnType);
    }

    @Override
    public Matrix translate(Calculation.Ret returnType, String sourceLanguage, String targetLanguage) {
        return new Translate((Matrix)this, sourceLanguage, targetLanguage).calc(returnType);
    }

    @Override
    public Matrix lowerCase(Calculation.Ret returnType) {
        return new LowerCase((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix upperCase(Calculation.Ret returnType) {
        return new UpperCase((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix convertEncoding(Calculation.Ret returnType, String encoding) {
        return new ConvertEncoding((Matrix)this, encoding).calc(returnType);
    }

    @Override
    public Matrix tfIdf(boolean calculateTf, boolean calculateIdf, boolean normalize) {
        return new TfIdf((Matrix)this, calculateTf, calculateIdf, normalize).calc(Calculation.Ret.NEW);
    }

    @Override
    public Matrix removePunctuation(Calculation.Ret ret) {
        return new RemovePunctuation((Matrix)this).calc(ret);
    }

    @Override
    public Matrix stem(Calculation.Ret ret) {
        return new Stem((Matrix)this).calc(ret);
    }

    @Override
    public Matrix removeWords(Calculation.Ret ret, Collection<String> words) {
        return new RemoveWords((Matrix)this, words).calc(ret);
    }

    @Override
    public Matrix unique(Calculation.Ret returnType) {
        return new Unique((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix uniqueValueCount(Calculation.Ret returnType, int dimension) {
        return new UniqueValueCount((Matrix)this, dimension).calc(returnType);
    }

    @Override
    public Matrix bootstrap(Calculation.Ret returnType, int count) {
        return new Bootstrap((Matrix)this, count).calc(returnType);
    }

    @Override
    public Matrix transpose(Calculation.Ret returnType, int dimension1, int dimension2) {
        return new Transpose((Matrix)this, dimension1, dimension2).calc(returnType);
    }

    @Override
    public Matrix swap(Calculation.Ret returnType, int dimension, long pos1, long pos2) {
        return new Swap(dimension, pos1, pos2, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix flipdim(Calculation.Ret returnType, int dimension) {
        return new Flipdim(dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix shuffle(Calculation.Ret returnType) {
        return new Shuffle((Matrix)this).calc(returnType);
    }

    @Override
    public final double trace() {
        double sum = 0.0;
        long i = Math.min(this.getRowCount(), this.getColumnCount());
        while (--i >= 0L) {
            sum += this.getAsDouble(i, i);
        }
        return sum;
    }

    @Override
    public void setLabel(Object label) {
        if (this.metaData == null) {
            this.metaData = new DefaultMapMatrix<String, Object>(new TreeMap());
        }
        this.metaData.put("Label", label);
    }

    @Override
    public final String getLabel() {
        Object o = this.getLabelObject();
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof HasLabel) {
            return ((HasLabel)o).getLabel();
        }
        return o.toString();
    }

    @Override
    public void setAsString(String string, long ... coordinates) {
        this.setAsObject(string, coordinates);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getAsString(long ... coordinates) {
        return StringUtil.convert(this.getAsObject(coordinates));
    }

    @Override
    public final double getMaxValue() {
        return Max.calc(this);
    }

    @Override
    public final double getMinValue() {
        return Min.calc(this);
    }

    @Override
    public final double getMeanValue() {
        return Mean.calc(this);
    }

    @Override
    public final double getStdValue() {
        return this.std(Calculation.Ret.NEW, Integer.MAX_VALUE, true, true).getEuklideanValue();
    }

    @Override
    public final double getValueSum() {
        double sum = 0.0;
        for (long[] c : this.allCoordinates()) {
            sum += this.getAsDouble(c);
        }
        return sum;
    }

    @Override
    public final double getAbsoluteValueSum() {
        double sum = 0.0;
        for (long[] c : this.allCoordinates()) {
            sum += Math.abs(this.getAsDouble(c));
        }
        return sum;
    }

    @Override
    public final String getColumnLabel(long col) {
        if (this.getDimensionCount() != 2) {
            throw new RuntimeException("This function is only supported for 2D matrices");
        }
        return StringUtil.convert(this.getDimensionMetaData(0, 0L, col));
    }

    @Override
    public final String getRowLabel(long row) {
        if (this.getDimensionCount() != 2) {
            throw new RuntimeException("This function is only supported for 2D matrices");
        }
        return StringUtil.convert(this.getDimensionMetaData(1, row, 0L));
    }

    @Override
    public final long getRowForLabel(Object object) {
        if (this.getDimensionCount() != 2) {
            throw new RuntimeException("This function is only supported for 2D matrices");
        }
        return this.getPositionForLabel(1, object)[0];
    }

    @Override
    public final long getColumnForLabel(Object object) {
        if (this.getDimensionCount() != 2) {
            throw new RuntimeException("This function is only supported for 2D matrices");
        }
        return this.getPositionForLabel(0, object)[1];
    }

    @Override
    public final long[] getPositionForLabel(int dimension, Object label) {
        if (label == null) {
            throw new RuntimeException("label is null");
        }
        if (this.metaData == null) {
            long[] t = Coordinates.copyOf(this.getSize());
            t[dimension] = -1L;
            return t;
        }
        Matrix m = this.getMetaDataDimensionMatrix(dimension);
        for (long[] c : m.availableCoordinates()) {
            Object o = m.getAsObject(c);
            if (!label.equals(o)) continue;
            return c;
        }
        long[] t = new long[this.getDimensionCount()];
        Arrays.fill(t, -1L);
        return t;
    }

    @Override
    public final void setColumnLabel(long col, Object label) {
        if (this.getDimensionCount() != 2) {
            throw new RuntimeException("This function is only supported for 2D matrices");
        }
        this.setDimensionMetaData(0, label, 0L, col);
    }

    @Override
    public final void setRowLabel(long row, Object label) {
        if (this.getDimensionCount() != 2) {
            throw new RuntimeException("This function is only supported for 2D matrices");
        }
        this.setDimensionMetaData(1, label, row, 0L);
    }

    @Override
    public final double getAbsoluteValueMean() {
        return this.getAbsoluteValueSum() / (double)this.getValueCount();
    }

    @Override
    public final Matrix toRowVector(Calculation.Ret returnType) {
        if (this.isRowVector()) {
            return this;
        }
        if (this.isColumnVector()) {
            return this.transpose(returnType);
        }
        return this.reshape(returnType, Coordinates.product(this.getSize()), 1L);
    }

    @Override
    public final Matrix toColumnVector(Calculation.Ret returnType) {
        if (this.isColumnVector()) {
            return this;
        }
        if (this.isRowVector()) {
            return this.transpose(returnType);
        }
        return this.reshape(returnType, 1L, (int)Coordinates.product(this.getSize()));
    }

    @Override
    public Matrix replaceMissingBy(Matrix matrix) {
        DenseMatrix ret = Matrix.Factory.zeros(this.getSize());
        for (long[] c : this.allCoordinates()) {
            double v = this.getAsDouble(c);
            if (MathUtil.isNaNOrInfinite(v)) {
                ret.setAsDouble(matrix.getAsDouble(c), c);
                continue;
            }
            ret.setAsDouble(this.getAsDouble(c), c);
        }
        return ret;
    }

    @Override
    public final Matrix deleteColumnsWithMissingValues(Calculation.Ret returnType) {
        Matrix mv = this.countMissing(Calculation.Ret.NEW, 0);
        ArrayList<Long> sel = new ArrayList<Long>();
        for (long c = 0L; c < mv.getColumnCount(); ++c) {
            if (mv.getAsDouble(0L, c) != 0.0) continue;
            sel.add(c);
        }
        long[] longsel = new long[sel.size()];
        int i = sel.size();
        while (--i >= 0) {
            longsel[i] = (Long)sel.get(i);
        }
        return this.selectColumns(returnType, longsel);
    }

    @Override
    public final Matrix deleteRowsWithMissingValues(Calculation.Ret returnType, long threshold) {
        Matrix mv = this.countMissing(Calculation.Ret.NEW, 1);
        ArrayList<Long> sel = new ArrayList<Long>();
        for (long r = 0L; r < mv.getRowCount(); ++r) {
            if (mv.getAsLong(r, 0L) >= threshold) continue;
            sel.add(r);
        }
        if (sel.isEmpty()) {
            return Matrix.Factory.emptyMatrix();
        }
        return this.selectRows(returnType, sel);
    }

    @Override
    public final Matrix appendHorizontally(Calculation.Ret returnType, Matrix ... matrices) {
        return this.append(returnType, 1, matrices);
    }

    @Override
    public Iterable<Object> allValues() {
        return new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    private Iterator<long[]> it;
                    {
                        this.it = AbstractMatrix.this.allCoordinates().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Object next() {
                        return AbstractMatrix.this.getAsObject(this.it.next());
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }
        };
    }

    @Override
    public final Matrix appendVertically(Calculation.Ret returnType, Matrix ... matrices) {
        return this.append(returnType, 0, matrices);
    }

    @Override
    public final Matrix append(Calculation.Ret returnType, int dimension, Matrix ... matrices) {
        Matrix[] mtotal = new Matrix[matrices.length + 1];
        mtotal[0] = this;
        System.arraycopy(matrices, 0, mtotal, 1, matrices.length);
        return new Concatenation(dimension, mtotal).calc(returnType);
    }

    @Override
    public final Matrix discretizeToColumns(long column) {
        return new DiscretizeToColumns((Matrix)this, false, column).calc(Calculation.Ret.NEW);
    }

    @Override
    public final Matrix subMatrix(Calculation.Ret returnType, long ... startAndEndCoordinates) {
        return new SubMatrix((Matrix)this, startAndEndCoordinates).calc(returnType);
    }

    @Override
    public Matrix[] svd() {
        return SVD.INSTANCE.calc(this);
    }

    @Override
    public final Matrix[] svd(int k) {
        int iterations = 3;
        Matrix aSquared = this.mtimes(this.transpose());
        for (int i = 0; i < 3; ++i) {
            aSquared = aSquared.mtimes(aSquared);
        }
        Object o = Matrix.Factory.randn(this.getRowCount(), (long)k);
        Matrix y = aSquared.mtimes(this).mtimes((Matrix)o);
        Matrix[] qr = y.qr();
        Matrix q = qr[0];
        Matrix b = q.transpose().mtimes(this);
        Matrix[] svd = b.svd();
        Matrix uHat = svd[0];
        Matrix s = svd[1];
        Matrix v = svd[2];
        Matrix u = q.mtimes(uHat);
        return new Matrix[]{u, s, v};
    }

    @Override
    public Matrix[] eig() {
        return Eig.INSTANCE.calc(this);
    }

    @Override
    public Matrix[] eigSymm() {
        return Eig.INSTANCE.calc(this);
    }

    @Override
    public Matrix[] qr() {
        return QR.INSTANCE.calc(this);
    }

    @Override
    public Matrix[] lu() {
        return LU.INSTANCE.calc(this);
    }

    @Override
    public Matrix chol() {
        return Chol.INSTANCE.calc(this);
    }

    @Override
    public void setSize(long ... size) {
        throw new RuntimeException("operation not possible: cannot change size of matrix");
    }

    @Override
    public final Matrix reshape(Calculation.Ret returnType, long ... newSize) {
        return new Reshape((Matrix)this, newSize).calc(returnType);
    }

    @Override
    public final Matrix squeeze(Calculation.Ret returnType) {
        return new Squeeze((Matrix)this).calc(returnType);
    }

    @Override
    public final double doubleValue() {
        if (this.isScalar()) {
            return this.getAsDouble(0L, 0L);
        }
        return Double.NaN;
    }

    @Override
    public final int intValue() {
        if (this.isScalar()) {
            return this.getAsInt(0L, 0L);
        }
        return 0;
    }

    @Override
    public final char charValue() {
        if (this.isScalar()) {
            return this.getAsChar(0L, 0L);
        }
        return '\u0000';
    }

    @Override
    public final BigInteger bigIntegerValue() {
        if (this.isScalar()) {
            return this.getAsBigInteger(0L, 0L);
        }
        return null;
    }

    @Override
    public final BigDecimal bigDecimalValue() {
        if (this.isScalar()) {
            return this.getAsBigDecimal(0L, 0L);
        }
        return null;
    }

    @Override
    public final Matrix fadeIn(Calculation.Ret ret, int dimension) {
        return new FadeIn(dimension, (Matrix)this).calc(ret);
    }

    @Override
    public final Matrix fadeOut(Calculation.Ret ret, int dimension) {
        return new FadeOut(dimension, (Matrix)this).calc(ret);
    }

    @Override
    public final float floatValue() {
        if (this.isScalar()) {
            return this.getAsFloat(0L, 0L);
        }
        return Float.NaN;
    }

    @Override
    public final long longValue() {
        if (this.isScalar()) {
            return this.getAsLong(0L, 0L);
        }
        return 0L;
    }

    @Override
    public final Date dateValue() {
        if (this.isScalar()) {
            return this.getAsDate(0L, 0L);
        }
        return MathUtil.getDate(null);
    }

    @Override
    public final boolean booleanValue() {
        if (this.isScalar()) {
            return this.getAsBoolean(0L, 0L);
        }
        return false;
    }

    @Override
    public final String stringValue() {
        if (this.isScalar()) {
            return this.getAsString(0L, 0L);
        }
        return this.toString();
    }

    @Override
    public final double getRMS() {
        double sum = 0.0;
        long count = 0L;
        for (long[] c : this.allCoordinates()) {
            sum += Math.pow(this.getAsDouble(c), 2.0);
            ++count;
        }
        return Math.sqrt(sum /= (double)count);
    }

    @Override
    public final Object getMetaData(Object key) {
        return this.metaData == null ? null : this.metaData.get(key);
    }

    @Override
    public final Matrix getMetaDataMatrix(Object key) {
        return this.metaData == null ? null : MathUtil.getMatrix(this.metaData.get(key));
    }

    @Override
    public final double getMetaDataDouble(Object key) {
        return this.metaData == null ? Double.NaN : MathUtil.getDouble(this.metaData.get(key));
    }

    @Override
    public final String getMetaDataString(Object key) {
        return this.metaData == null ? null : StringUtil.getString(this.metaData.get(key));
    }

    @Override
    public final MapMatrix<String, Object> getMetaData() {
        return this.metaData;
    }

    @Override
    public final void setMetaData(MapMatrix<String, Object> metaData) {
        this.metaData = metaData;
    }

    @Override
    public final void setMetaData(String key, Object value) {
        if (this.metaData == null) {
            this.metaData = new DefaultMapMatrix<String, Object>(new TreeMap());
        }
        this.metaData.put(key, value);
    }

    @Override
    public final boolean equalsAnnotation(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Matrix) {
            Matrix m = (Matrix)o;
            MapMatrix<String, Object> a1 = this.getMetaData();
            MapMatrix<String, Object> a2 = m.getMetaData();
            if (a1 != null ? !a1.equals(a2) : a2 != null) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        return this.equalsContent(o) && this.equalsAnnotation(o);
    }

    @Override
    public final boolean equalsContent(Object o) {
        try {
            if (this == o) {
                return true;
            }
            if (o instanceof Matrix) {
                Matrix m = (Matrix)o;
                if (!Coordinates.equals(this.getSize(), m.getSize())) {
                    return false;
                }
                if (this.isSparse() && m.isSparse()) {
                    Object o2;
                    Object o1;
                    for (long[] c : this.availableCoordinates()) {
                        o1 = this.getAsObject(c);
                        o2 = m.getAsObject(c);
                        if (o1 == null && o2 != null || o1 != null && o2 == null) {
                            return false;
                        }
                        if (o1 != null && o2 != null) {
                            if (o1.equals(o2)) continue;
                            return false;
                        }
                        if (o1 == null && o2 == null) continue;
                        return false;
                    }
                    for (long[] c : m.availableCoordinates()) {
                        o1 = this.getAsObject(c);
                        o2 = m.getAsObject(c);
                        if (o1 == null && o2 != null || o1 != null && o2 == null) {
                            return false;
                        }
                        if (o1 != null && o2 != null) {
                            if (o1.equals(o2)) continue;
                            return false;
                        }
                        if (o1 == null && o2 == null) continue;
                        return false;
                    }
                } else if (this instanceof MapMatrix && m instanceof MapMatrix) {
                    MapMatrix map1 = (MapMatrix)((Object)this);
                    MapMatrix map2 = (MapMatrix)m;
                    for (Object key : map1.keySet()) {
                        Object o1 = map1.get(key);
                        Object o2 = map2.get(key);
                        if (o1 == null && o2 != null || o1 != null && o2 == null) {
                            return false;
                        }
                        if (o1 != null && o2 != null) {
                            if (!(o1.getClass().equals(o2.getClass()) ? !o1.equals(o2) : !MathUtil.equals(o1, o2))) continue;
                            return false;
                        }
                        if (o1 == null && o2 == null) continue;
                        return false;
                    }
                } else {
                    for (long[] c : this.allCoordinates()) {
                        Object o1 = this.getAsObject(c);
                        Object o2 = m.getAsObject(c);
                        if (o1 == null && o2 != null || o1 != null && o2 == null) {
                            return false;
                        }
                        if (o1 != null && o2 != null) {
                            if (!(o1.getClass().equals(o2.getClass()) ? !o1.equals(o2) : !MathUtil.equals(o1, o2))) continue;
                            return false;
                        }
                        if (o1 == null && o2 == null) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("could not compare", e);
        }
    }

    @Override
    public final BooleanMatrix toBooleanMatrix() {
        return new ToBooleanMatrix((Matrix)this).calcLink();
    }

    @Override
    public final ByteMatrix toByteMatrix() {
        return new ToByteMatrix((Matrix)this).calcLink();
    }

    @Override
    public final CharMatrix toCharMatrix() {
        return new ToCharMatrix((Matrix)this).calcLink();
    }

    @Override
    public final DoubleMatrix toDoubleMatrix() {
        return new ToDoubleMatrix((Matrix)this).calcLink();
    }

    @Override
    public final FloatMatrix toFloatMatrix() {
        return new ToFloatMatrix((Matrix)this).calcLink();
    }

    @Override
    public final IntMatrix toIntMatrix() {
        return new ToIntMatrix((Matrix)this).calcLink();
    }

    @Override
    public final LongMatrix toLongMatrix() {
        return new ToLongMatrix((Matrix)this).calcLink();
    }

    @Override
    public final BaseBigDecimalMatrix toBigDecimalMatrix() {
        return new ToBigDecimalMatrix((Matrix)this).calcLink();
    }

    @Override
    public final BigIntegerMatrix toBigIntegerMatrix() {
        return new ToBigIntegerMatrix((Matrix)this).calcLink();
    }

    @Override
    public final ObjectMatrix toObjectMatrix() {
        return new ToObjectMatrix((Matrix)this).calcLink();
    }

    @Override
    public final ShortMatrix toShortMatrix() {
        return new ToShortMatrix((Matrix)this).calcLink();
    }

    @Override
    public final StringMatrix toStringMatrix() {
        return new ToStringMatrix((Matrix)this).calcLink();
    }

    @Override
    public double norm1() {
        long rows = this.getRowCount();
        long cols = this.getColumnCount();
        double max = 0.0;
        for (long c = 0L; c < cols; ++c) {
            double sum = 0.0;
            long r = 0L;
            while (r < rows) {
                sum += Math.abs(this.getAsDouble(r++, c));
            }
            max = Math.max(max, sum);
        }
        return max;
    }

    @Override
    public double norm2() {
        return this.svd()[1].getAsDouble(0L, 0L);
    }

    @Override
    public double normInf() {
        long rows = this.getRowCount();
        long cols = this.getColumnCount();
        double max = 0.0;
        for (long r = 0L; r < rows; ++r) {
            double sum = 0.0;
            long c = 0L;
            while (c < cols) {
                sum += Math.abs(this.getAsDouble(r, c++));
            }
            max = Math.max(max, sum);
        }
        return max;
    }

    @Override
    public double normF() {
        long rows = this.getRowCount();
        long cols = this.getColumnCount();
        double result = 0.0;
        for (long ro = 0L; ro < rows; ++ro) {
            for (long c = 0L; c < cols; ++c) {
                double b = this.getAsDouble(ro, c);
                double temp = 0.0;
                if (Math.abs(result) > Math.abs(b)) {
                    temp = b / result;
                    temp = Math.abs(result) * Math.sqrt(1.0 + temp * temp);
                } else if (b != 0.0) {
                    temp = result / b;
                    temp = Math.abs(b) * Math.sqrt(1.0 + temp * temp);
                } else {
                    temp = 0.0;
                }
                result = temp;
            }
        }
        return result;
    }

    @Override
    public ListMatrix<?> toListMatrix() {
        if (this instanceof ListMatrix) {
            return (ListMatrix)((Object)this);
        }
        DefaultListMatrix list = new DefaultListMatrix();
        int row = 0;
        while ((long)row < this.getRowCount()) {
            list.add(this.getAsObject(row, 0L));
            ++row;
        }
        return list;
    }

    @Override
    public SetMatrix<?> toSetMatrix() {
        if (this instanceof SetMatrix) {
            return (SetMatrix)((Object)this);
        }
        DefaultSetMatrix set = new DefaultSetMatrix();
        int row = 0;
        while ((long)row < this.getRowCount()) {
            set.add(this.getAsObject(row, 0L));
            ++row;
        }
        return set;
    }

    @Override
    public MapMatrix<?, ?> toMapMatrix() {
        if (this instanceof MapMatrix) {
            return (MapMatrix)((Object)this);
        }
        DefaultMapMatrix<Object, Object> map = new DefaultMapMatrix<Object, Object>();
        int row = 0;
        while ((long)row < this.getRowCount()) {
            map.put(this.getAsObject(row, 0L), this.getAsObject(row, 1L));
            ++row;
        }
        return map;
    }

    @Override
    public boolean containsBigInteger(BigInteger v) {
        for (long[] c : this.availableCoordinates()) {
            if (!v.equals(this.getAsBigInteger(c))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsBigDecimal(BigDecimal v) {
        for (long[] c : this.availableCoordinates()) {
            if (!v.equals(this.getAsBigDecimal(c))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsDate(Date v) {
        for (long[] c : this.availableCoordinates()) {
            if (!v.equals(this.getAsDate(c))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsObject(Object o) {
        for (long[] c : this.availableCoordinates()) {
            if (!o.equals(this.getAsObject(c))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsString(String s) {
        for (long[] c : this.availableCoordinates()) {
            if (!s.equals(this.getAsString(c))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsBoolean(boolean v) {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsBoolean(c) != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsByte(byte v) {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsByte(c) != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsChar(char v) {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsChar(c) != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsDouble(double v) {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsDouble(c) != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsFloat(float v) {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsFloat(c) != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsInt(int v) {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsInt(c) != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsLong(long v) {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsLong(c) != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsShort(short v) {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsShort(c) != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsNull() {
        for (long[] c : this.allCoordinates()) {
            if (this.getAsDouble(c) != 0.0) continue;
            return true;
        }
        return false;
    }

    @Override
    public MatrixExportDestinationSelector exportTo() {
        if (this instanceof DenseMatrix) {
            return new DefaultMatrixExportDestinationSelector((DenseMatrix)((Object)this));
        }
        throw new RuntimeException("export only works for dense matrices");
    }

    @Override
    public MatrixImportSourceSelector importFrom() {
        if (this instanceof DenseMatrix) {
            return new DefaultMatrixImportSourceSelector(this);
        }
        throw new RuntimeException("import only works for dense matrices");
    }

    @Override
    public final String getId() {
        return this.metaData == null ? null : StringUtil.getString(this.metaData.get("Id"));
    }

    @Override
    public final void setId(String id) {
        if (this.metaData == null) {
            this.metaData = new DefaultMapMatrix<String, Object>(new TreeMap());
        }
        this.metaData.put("Id", id);
    }

    @Override
    public final String getDescription() {
        return this.metaData == null ? null : StringUtil.getString(this.metaData.get("Description"));
    }

    @Override
    public final Object getLabelObject() {
        return this.metaData == null ? null : this.metaData.get("Label");
    }

    @Override
    public final void setDescription(String description) {
        if (this.metaData == null) {
            this.metaData = new DefaultMapMatrix<String, Object>(new TreeMap());
        }
        this.metaData.put("Description", description);
    }

    @Override
    public final void share(String hostname, int port) throws UnknownHostException, IOException {
        ServerSocket serverSocket = new ServerSocket(port, 50, InetAddress.getByName(hostname));
        new MatrixSocketThread(this, serverSocket);
    }

    @Override
    public final void share(int port) throws IOException {
        ServerSocket serverSocket = new ServerSocket(port);
        new MatrixSocketThread(this, serverSocket);
    }

    static {
        runningId = System.nanoTime() + System.currentTimeMillis();
        DecompositionOps.init();
        try {
            long mem = Runtime.getRuntime().maxMemory();
            if (mem < 133234688L) {
                System.err.println("Available memory is very low: " + mem / 1000000L + "M");
                System.err.println("Invoke Java with the parameter -Xmx512M to increase available memory");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

