/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.table;

import java.awt.Dimension;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.RowSorterListener;
import javax.swing.plaf.TableUI;
import org.ujmp.gui.table.DefaultTableColumnModel64;
import org.ujmp.gui.table.FastListSelectionModel64;
import org.ujmp.gui.table.JTableHeader64;
import org.ujmp.gui.table.ListSelectionEvent64;
import org.ujmp.gui.table.ListSelectionListener64;
import org.ujmp.gui.table.ListSelectionModel64;
import org.ujmp.gui.table.TableColumnModel64;
import org.ujmp.gui.table.TableColumnModelEvent64;
import org.ujmp.gui.table.TableColumnModelListener64;
import org.ujmp.gui.table.TableModel64;
import org.ujmp.gui.table.TableModelEvent64;
import org.ujmp.gui.table.TableModelListener64;

public class JTable64
extends JTable
implements TableModelListener64,
Scrollable,
TableColumnModelListener64,
ListSelectionListener64,
CellEditorListener,
Accessible,
RowSorterListener {
    private static final long serialVersionUID = -4778128053560013569L;

    public JTable64(TableModel64 dataModel) {
        this(dataModel, null, null);
    }

    public JTable64(TableModel64 dataModel, TableColumnModel64 tableColumnModel, ListSelectionModel64 rowSelectionModel) {
        super(dataModel, tableColumnModel == null ? new DefaultTableColumnModel64(dataModel) : tableColumnModel, rowSelectionModel == null ? new FastListSelectionModel64() : rowSelectionModel);
    }

    @Override
    public void doLayout() {
        this.layout();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this.getColumnModel64().getTotalColumnWidth(), Integer.MAX_VALUE);
    }

    @Override
    public TableModel64 getModel() {
        return (TableModel64)super.getModel();
    }

    @Override
    protected void initializeLocalVars() {
        this.setOpaque(true);
        this.createDefaultRenderers();
        this.createDefaultEditors();
        this.setTableHeader(this.createDefaultTableHeader64());
        this.setShowGrid(true);
        this.setAutoResizeMode(0);
        this.setRowHeight(16);
        this.setRowMargin(1);
        this.setRowSelectionAllowed(true);
        this.setCellEditor(null);
        this.setEditingColumn(-1);
        this.setEditingRow(-1);
        this.setSurrendersFocusOnKeystroke(false);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.setAutoscrolls(true);
    }

    protected JTableHeader64 createDefaultTableHeader64() {
        return new JTableHeader64((TableColumnModel64)this.columnModel);
    }

    @Override
    public ListSelectionModel64 getSelectionModel() {
        if (this.selectionModel instanceof ListSelectionModel64) {
            return (ListSelectionModel64)this.selectionModel;
        }
        throw new RuntimeException("not a ListSelectionModel64");
    }

    @Override
    public void setSelectionModel(ListSelectionModel newModel) {
        if (!(newModel instanceof ListSelectionModel64)) {
            throw new IllegalArgumentException("needs ListSelectionModel64");
        }
        super.setSelectionModel(newModel);
    }

    public void setSelectionModel(ListSelectionModel64 newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException("Cannot set a null SelectionModel");
        }
        if (!(newModel instanceof ListSelectionModel64)) {
            throw new IllegalArgumentException("needs ListSelectionModel64");
        }
        ListSelectionModel64 oldModel = (ListSelectionModel64)this.selectionModel;
        if (newModel != oldModel) {
            if (oldModel != null) {
                oldModel.removeListSelectionListener(this);
            }
            this.selectionModel = newModel;
            newModel.addListSelectionListener(this);
            this.firePropertyChange("selectionModel", oldModel, newModel);
            this.repaint();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent64 e) {
        super.valueChanged(e);
    }

    @Override
    public void columnAdded(TableColumnModelEvent64 e) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void columnRemoved(TableColumnModelEvent64 e) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void columnMoved(TableColumnModelEvent64 e) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent64 e) {
        super.columnSelectionChanged(e);
    }

    @Override
    public void tableChanged(TableModelEvent64 e) {
        super.tableChanged(e);
    }

    @Override
    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle r = new Rectangle();
        boolean valid = true;
        if (row < 0) {
            valid = false;
        } else if (row >= this.getRowCount()) {
            r.y = this.getHeight();
            valid = false;
        } else {
            r.height = this.getRowHeight(row);
            r.y = row * r.height;
        }
        if (column < 0) {
            if (!this.getComponentOrientation().isLeftToRight()) {
                r.x = this.getWidth();
            }
            valid = false;
        } else if (column >= this.getColumnCount()) {
            if (this.getComponentOrientation().isLeftToRight()) {
                r.x = this.getWidth();
            }
            valid = false;
        } else {
            int i;
            TableColumnModel64 cm = this.getColumnModel64();
            if (this.getComponentOrientation().isLeftToRight()) {
                for (i = 0; i < column; ++i) {
                    r.x += cm.getColumnWidth(i);
                }
            } else {
                for (i = cm.getColumnCount() - 1; i > column; --i) {
                    r.x += cm.getColumnWidth(i);
                }
            }
            r.width = cm.getColumnWidth(column);
        }
        if (valid && !includeSpacing) {
            int rm = Math.min(this.getRowMargin(), r.height);
            int cm = Math.min(this.getColumnModel().getColumnMargin(), r.width);
            r.setBounds(r.x + cm / 2, r.y + rm / 2, r.width - cm, r.height - rm);
        }
        return r;
    }

    public TableColumnModel64 getColumnModel64() {
        return (TableColumnModel64)this.getColumnModel();
    }

    @Override
    public void updateUI() {
        if (this.tableHeader != null && this.tableHeader.getParent() == null) {
            this.tableHeader.updateUI();
        }
        this.setUI((TableUI)UIManager.getUI(this));
    }
}

