/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.ColorUtil;
import org.ujmp.core.util.StringUtil;
import org.ujmp.core.util.UJMPFormat;
import org.ujmp.gui.renderer.MatrixHeatmapRenderer;

public class MatrixValueTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -1473046176750819621L;
    private static final Color SELECTCOLOR = new Color(100, 100, 255, 76);
    private static final Border borderSelected = BorderFactory.createLineBorder(Color.blue, 1);
    private static final Border borderNotSelected = BorderFactory.createLineBorder(Color.white, 1);
    private final MatrixHeatmapRenderer matrixRenderer = new MatrixHeatmapRenderer();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        label.setHorizontalAlignment(0);
        Color c = ColorUtil.fromObject(value);
        int width = table.getColumnModel().getColumn(column).getWidth();
        if (width < 25) {
            label.setText("");
        } else {
            String s;
            if (value == null) {
                s = "";
            } else {
                if (value instanceof Matrix) {
                    String s2 = "";
                    Matrix ma = (Matrix)value;
                    s2 = ma.getLabel() != null ? s2 + "[" + ma.getLabel() + "]" : s2 + ma.getClass().getSimpleName();
                    return this.matrixRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
                s = value instanceof Integer ? String.valueOf(value) : (value instanceof Byte ? String.valueOf(value) : (value instanceof Long ? String.valueOf(value) : UJMPFormat.getSingleLineInstance().format(value)));
            }
            if (s != null && s.length() > 100) {
                s = s.substring(0, 100) + "...";
            }
            label.setText(s);
        }
        label.setForeground(ColorUtil.contrastBW(c));
        if (isSelected) {
            label.setBorder(borderSelected);
            label.setBackground(ColorUtil.add(c, SELECTCOLOR));
        } else {
            label.setBorder(borderNotSelected);
            label.setBackground(c);
        }
        return label;
    }

    @Override
    protected void setValue(Object value) {
        this.setText(value == null ? "" : StringUtil.format(value));
    }
}

