/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.panels;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import org.ujmp.core.Matrix;
import org.ujmp.core.interfaces.HasToolTip;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.actions.MatrixActions;
import org.ujmp.gui.interfaces.CanBeRepainted;
import org.ujmp.gui.menu.MatrixPopupMenu;
import org.ujmp.gui.renderer.MatrixHeatmapRenderer;
import org.ujmp.gui.table.TableModelEvent64;
import org.ujmp.gui.table.TableModelListener64;
import org.ujmp.gui.util.GraphicsExecutor;
import org.ujmp.gui.util.Preloader;
import org.ujmp.gui.util.TooltipUtil;

public class MatrixHeatmapPanel
extends JPanel
implements ComponentListener,
TableModelListener64,
MouseListener,
KeyListener,
MouseMotionListener,
CanBeRepainted,
HasToolTip,
ListSelectionListener {
    private static final long serialVersionUID = 843653796010276950L;
    private final MatrixGUIObject matrixGUIObject;
    private final MatrixHeatmapRenderer renderer = new MatrixHeatmapRenderer();
    private final Preloader preloader = new Preloader();
    private boolean isPreloaderVisible = true;
    private BufferedImage bufferedImage = null;
    private long startRow = 0L;
    private long startCol = 0L;

    public MatrixHeatmapPanel(MatrixGUIObject matrixGUIObject, boolean showBorder) {
        this.matrixGUIObject = matrixGUIObject;
        if (matrixGUIObject == null) {
            throw new IllegalArgumentException("matrixGUIObject is null");
        }
        if (showBorder) {
            this.setBorder(BorderFactory.createTitledBorder("Matrix Heatmap"));
        }
        this.setPreferredSize(new Dimension(600, 400));
        this.setLayout(new BorderLayout());
        this.add((Component)this.preloader, "Center");
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        matrixGUIObject.addTableModelListener(this);
        matrixGUIObject.getRowSelectionModel().addListSelectionListener(this);
        matrixGUIObject.getColumnSelectionModel().addListSelectionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.registerKeyboardActions();
    }

    private void registerKeyboardActions() {
        for (JComponent c : new MatrixActions(this, this.matrixGUIObject, null)) {
            if (!(c instanceof JMenuItem)) continue;
            this.registerKeyboardAction(((JMenuItem)c).getAction());
        }
    }

    private void registerKeyboardAction(Action a) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.renderer.setSize(this.getSize());
        GraphicsExecutor.scheduleUpdate(this);
    }

    @Override
    public void componentShown(ComponentEvent e) {
        GraphicsExecutor.scheduleUpdate(this);
    }

    @Override
    public void tableChanged(TableModelEvent64 e) {
        GraphicsExecutor.scheduleUpdate(this);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        GraphicsExecutor.scheduleUpdate(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object o;
        long newRow = this.getRowPos(e.getY());
        long newCol = this.getColPos(e.getX());
        if (e.getButton() == 3) {
            newRow = newRow < 0L ? 0L : newRow;
            newCol = newCol < 0L ? 0L : newCol;
            newRow = newRow >= (long)this.matrixGUIObject.getRowCount() ? (long)(this.matrixGUIObject.getRowCount() - 1) : newRow;
            newCol = newCol >= (long)this.matrixGUIObject.getColumnCount() ? (long)(this.matrixGUIObject.getColumnCount() - 1) : newCol;
            MatrixPopupMenu popup = new MatrixPopupMenu(this, this.matrixGUIObject, newRow, newCol);
            popup.show(this, e.getX(), e.getY());
        } else if (e.getButton() == 1 && (o = this.matrixGUIObject.getValueAt(newRow, newCol)) instanceof Matrix) {
            ((Matrix)o).showGUI();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.requestFocus();
            this.startRow = this.getRowPos(e.getY());
            this.startCol = this.getColPos(e.getX());
            this.startRow = this.startRow < 0L ? 0L : this.startRow;
            this.startCol = this.startCol < 0L ? 0L : this.startCol;
            this.startRow = this.startRow >= (long)this.matrixGUIObject.getRowCount() ? (long)(this.matrixGUIObject.getRowCount() - 1) : this.startRow;
            this.startCol = this.startCol >= (long)this.matrixGUIObject.getColumnCount() ? (long)(this.matrixGUIObject.getColumnCount() - 1) : this.startCol;
            this.matrixGUIObject.getRowSelectionModel().setValueIsAdjusting(true);
            this.matrixGUIObject.getColumnSelectionModel().setValueIsAdjusting(true);
            this.matrixGUIObject.getRowSelectionModel().setSelectionInterval(this.startRow, this.startRow);
            this.matrixGUIObject.getColumnSelectionModel().setSelectionInterval(this.startCol, this.startCol);
        }
        this.repaint(100L);
    }

    private long getRowPos(int y) {
        return this.matrixGUIObject.getRowCount64() * (long)y / (long)this.getHeight();
    }

    private long getColPos(int x) {
        return this.matrixGUIObject.getColumnCount64() * (long)x / (long)this.getWidth();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            long newRow = this.getRowPos(e.getY());
            long newCol = this.getColPos(e.getX());
            newRow = newRow < 0L ? 0L : newRow;
            newCol = newCol < 0L ? 0L : newCol;
            newRow = newRow >= (long)this.matrixGUIObject.getRowCount() ? (long)(this.matrixGUIObject.getRowCount() - 1) : newRow;
            newCol = newCol >= (long)this.matrixGUIObject.getColumnCount() ? (long)(this.matrixGUIObject.getColumnCount() - 1) : newCol;
            this.matrixGUIObject.getRowSelectionModel().setValueIsAdjusting(false);
            this.matrixGUIObject.getColumnSelectionModel().setValueIsAdjusting(false);
            this.matrixGUIObject.getRowSelectionModel().setSelectionInterval(this.startRow, newRow);
            this.matrixGUIObject.getColumnSelectionModel().setSelectionInterval(this.startCol, newCol);
            this.repaint(100L);
        }
    }

    public MatrixGUIObject getMatrix() {
        return this.matrixGUIObject;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this.matrixGUIObject.getRowCount() > 0 && this.matrixGUIObject.getColumnCount() > 0) {
            long r = this.getRowPos(e.getY());
            long c = this.getColPos(e.getX());
            r = r < 0L ? 0L : r;
            c = c < 0L ? 0L : c;
            r = r >= (long)this.matrixGUIObject.getRowCount() ? (long)(this.matrixGUIObject.getRowCount() - 1) : r;
            c = c >= (long)this.matrixGUIObject.getColumnCount() ? (long)(this.matrixGUIObject.getColumnCount() - 1) : c;
            String toolTip = TooltipUtil.getTooltip(this.matrixGUIObject, r, c);
            return toolTip;
        }
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.matrixGUIObject != null) {
            this.matrixGUIObject.removeTableModelListener(this);
        }
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.bufferedImage == null) {
            super.paintComponent(g);
        } else {
            if (this.isPreloaderVisible) {
                this.remove(this.preloader);
                this.isPreloaderVisible = false;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.drawImage(this.bufferedImage, 0, 0, this.getWidth(), this.getHeight(), null);
            if (!this.matrixGUIObject.getRowSelectionModel().isSelectionEmpty()) {
                int paddingX = UIManager.getInt("Table.paddingX");
                int paddingY = UIManager.getInt("Table.paddingY");
                g2d.setColor(Color.BLUE);
                g2d.setComposite(AlphaComposite.getInstance(10, 0.3f));
                long x1 = this.matrixGUIObject.getColumnSelectionModel().getMinSelectionIndex64();
                long x2 = this.matrixGUIObject.getColumnSelectionModel().getMaxSelectionIndex64();
                long y1 = this.matrixGUIObject.getRowSelectionModel().getMinSelectionIndex64();
                long y2 = this.matrixGUIObject.getRowSelectionModel().getMaxSelectionIndex64();
                double scaleX = (double)(this.getWidth() - paddingX - paddingX) / (double)this.matrixGUIObject.getColumnCount();
                double scaleY = (double)(this.getHeight() - paddingY - paddingY) / (double)this.matrixGUIObject.getRowCount();
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawRect((int)Math.floor((double)paddingX + (double)x1 * scaleX), (int)Math.floor((double)paddingY + (double)y1 * scaleY), (int)Math.ceil(scaleX + (double)(x2 - x1) * scaleX), (int)Math.ceil(scaleY + (double)(y2 - y1) * scaleY));
                g2d.fillRect((int)Math.floor((double)paddingX + (double)x1 * scaleX), (int)Math.floor((double)paddingY + (double)y1 * scaleY), (int)Math.ceil(scaleX + (double)(x2 - x1) * scaleX), (int)Math.ceil(scaleY + (double)(y2 - y1) * scaleY));
            }
        }
    }

    @Override
    public void repaintUI() {
        if (this.getWidth() > 0 && this.getHeight() > 0 && this.matrixGUIObject.getRowCount() >= 0 && this.matrixGUIObject.getColumnCount() >= 0) {
            BufferedImage tempBufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            this.renderer.setSize(this.getWidth(), this.getHeight());
            this.renderer.setMatrix(this.matrixGUIObject);
            Graphics2D g2d = (Graphics2D)tempBufferedImage.getGraphics();
            this.renderer.paintComponent(g2d);
            g2d.dispose();
            this.bufferedImage = tempBufferedImage;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.matrixGUIObject.getRowSelectionModel().getValueIsAdjusting()) {
            long newRow = this.getRowPos(e.getY());
            long newCol = this.getColPos(e.getX());
            newRow = newRow < 0L ? 0L : newRow;
            newCol = newCol < 0L ? 0L : newCol;
            newRow = newRow >= (long)this.matrixGUIObject.getRowCount() ? (long)(this.matrixGUIObject.getRowCount() - 1) : newRow;
            newCol = newCol >= (long)this.matrixGUIObject.getColumnCount() ? (long)(this.matrixGUIObject.getColumnCount() - 1) : newCol;
            this.matrixGUIObject.getRowSelectionModel().setSelectionInterval(this.startRow, newRow);
            this.matrixGUIObject.getColumnSelectionModel().setSelectionInterval(this.startCol, newCol);
            this.repaint(100L);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        long row = this.getRowPos(e.getY());
        long col = this.getColPos(e.getX());
        this.matrixGUIObject.setMouseOverCoordinates(row, col);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.repaint(100L);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        long rows = this.matrixGUIObject.getRowCount64();
        long cols = this.matrixGUIObject.getColumnCount64();
        long minRow = this.matrixGUIObject.getRowSelectionModel().getMinSelectionIndex64();
        long maxRow = this.matrixGUIObject.getRowSelectionModel().getMaxSelectionIndex64();
        long minCol = this.matrixGUIObject.getColumnSelectionModel().getMinSelectionIndex64();
        long maxCol = this.matrixGUIObject.getColumnSelectionModel().getMaxSelectionIndex64();
        if (e.getKeyCode() == 65 && (e.getModifiers() & 2) != 0) {
            this.matrixGUIObject.getColumnSelectionModel().setSelectionInterval(0L, cols - 1L);
            this.matrixGUIObject.getRowSelectionModel().setSelectionInterval(0L, rows - 1L);
        } else if (e.getKeyCode() == 38 && minRow > 0L) {
            this.matrixGUIObject.getRowSelectionModel().setSelectionInterval(minRow - 1L, maxRow - 1L);
        } else if (e.getKeyCode() == 40 && maxRow < rows - 1L) {
            this.matrixGUIObject.getRowSelectionModel().setSelectionInterval(minRow + 1L, maxRow + 1L);
        } else if (e.getKeyCode() == 37 && minCol > 0L) {
            this.matrixGUIObject.getColumnSelectionModel().setSelectionInterval(minCol - 1L, maxCol - 1L);
        } else if (e.getKeyCode() == 39 && maxCol < cols - 1L) {
            this.matrixGUIObject.getColumnSelectionModel().setSelectionInterval(minCol + 1L, maxCol + 1L);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

