/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.menu;

import java.awt.event.ActionEvent;
import java.net.SocketException;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.ujmp.core.util.JMathLib;
import org.ujmp.core.util.matrices.AvailableProcessorsMatrix;
import org.ujmp.core.util.matrices.FileFormatMatrix;
import org.ujmp.core.util.matrices.LocalhostMatrix;
import org.ujmp.core.util.matrices.MatrixLibraries;
import org.ujmp.core.util.matrices.MemoryUsageMatrix;
import org.ujmp.core.util.matrices.OperatingSystemMatrix;
import org.ujmp.core.util.matrices.RandomSeedMatrix;
import org.ujmp.core.util.matrices.RunningThreadsMatrix;
import org.ujmp.core.util.matrices.SystemEnvironmentMatrix;
import org.ujmp.core.util.matrices.SystemPropertiesMatrix;
import org.ujmp.core.util.matrices.SystemTimeMatrix;
import org.ujmp.core.util.matrices.UJMPPluginsMatrix;
import org.ujmp.gui.actions.ShowInFrameAction;
import org.ujmp.gui.util.MatrixUIDefaults;

public class UJMPToolsMenu
extends JMenu {
    private static final long serialVersionUID = 853886481708901509L;

    public UJMPToolsMenu(JComponent component) {
        super("Tools");
        this.setMnemonic(84);
        this.add(new JMenuItem(new ShowInFrameAction(component, "UJMP Plugins", UJMPPluginsMatrix.class)));
        this.add(new LocalhostAction());
        this.add(new MatrixLibrariesAction());
        this.add(new JSeparator());
        this.add(new JMenuItem(new ShowInFrameAction(component, "Supported File Formats", FileFormatMatrix.class)));
        this.add(new JMenuItem(new ShowInFrameAction(component, "System Properties", SystemPropertiesMatrix.class)));
        this.add(new JMenuItem(new ShowInFrameAction(component, "System Environment", SystemEnvironmentMatrix.class)));
        this.add(new JMenuItem(new ShowInFrameAction(component, "UI Defaults", MatrixUIDefaults.class)));
        this.add(new JSeparator());
        this.add(new JMenuItem(new ShowInFrameAction(component, "Memory Usage", MemoryUsageMatrix.class)));
        this.add(new JMenuItem(new ShowInFrameAction(component, "Running Threads", RunningThreadsMatrix.class)));
        this.add(new JMenuItem(new ShowInFrameAction(component, "System Time", SystemTimeMatrix.class)));
        this.add(new JMenuItem(new ShowInFrameAction(component, "Random Seed", RandomSeedMatrix.class)));
        this.add(new JMenuItem(new ShowInFrameAction(component, "Available Processors", AvailableProcessorsMatrix.class)));
        this.add(new JMenuItem(new ShowInFrameAction(component, "Operating System", OperatingSystemMatrix.class)));
        if (JMathLib.isAvailable()) {
            this.add(new JSeparator());
            this.add(new JMathLibAction());
        }
    }

    class LocalhostAction
    extends AbstractAction {
        private static final long serialVersionUID = 1730034739534995562L;

        public LocalhostAction() {
            this.putValue("Name", "Localhost");
            this.putValue("ShortDescription", "Show data on localhost");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                LocalhostMatrix.getInstance().showGUI();
            }
            catch (SocketException e1) {
                e1.printStackTrace();
            }
        }
    }

    class MatrixLibrariesAction
    extends AbstractAction {
        private static final long serialVersionUID = 5469558464204854759L;

        public MatrixLibrariesAction() {
            this.putValue("Name", "Matrix Libraries");
            this.putValue("ShortDescription", "Show overview of matrix libraries in a new window");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new MatrixLibraries().showGUI();
        }
    }

    class JMathLibAction
    extends AbstractAction {
        private static final long serialVersionUID = 1895232937545702538L;

        public JMathLibAction() {
            this.putValue("Name", "JMathLib");
            this.putValue("ShortDescription", "Show JMathlib in a new Window");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMathLib.showGUI();
        }
    }
}

