/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.clipboard;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import org.ujmp.core.Matrix;

public class MatrixSelection
implements Transferable,
ClipboardOwner,
Serializable {
    private static final long serialVersionUID = -8462961141636462510L;
    public static final int STRING = 0;
    public static final int IMAGE = 1;
    public static final int MATRIX = 2;
    private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor};
    private String stringData = null;

    public MatrixSelection(Matrix matrix) throws IOException {
        this.stringData = matrix.exportTo().string().asDenseCSV();
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(flavors[0])) {
            return this.stringData;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

