/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.gui.actions.PrintAction;
import org.ujmp.gui.io.ExportJPEG;
import org.ujmp.gui.io.ExportPDF;
import org.ujmp.gui.io.ExportPNG;
import org.ujmp.gui.util.GUIUtil;

public class PanelActions
extends ArrayList<JComponent> {
    private static final long serialVersionUID = 4269896034756524809L;
    private final JComponent component;
    public final Action exportToPdfAction = new AbstractAction("Export to PDF...", UIManager.getIcon("JDMP.icon.pdf")){
        private static final long serialVersionUID = -7413294854080175036L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportPDF.save(ExportPDF.selectFile(), PanelActions.this.component);
        }
    };
    public final Action exportToJpgAction = new AbstractAction("Export to JPG...", UIManager.getIcon("JDMP.icon.image")){
        private static final long serialVersionUID = 2903870037000412488L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportJPEG.save(ExportJPEG.selectFile(), (Component)PanelActions.this.component, GUIUtil.getInt("Export width:", 1, 10000));
        }
    };
    public final Action exportToPngAction = new AbstractAction("Export to PNG...", UIManager.getIcon("JDMP.icon.image")){
        private static final long serialVersionUID = 667245834772891667L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportPNG.save(ExportPNG.selectFile(), (Component)PanelActions.this.component, GUIUtil.getInt("Export width:", 1, 10000));
        }
    };

    public PanelActions(JComponent c, GUIObject o) {
        this.component = c;
        this.add(new JMenuItem(this.exportToPngAction));
        this.add(new JMenuItem(this.exportToJpgAction));
        JMenuItem mi = new JMenuItem(this.exportToPdfAction);
        this.add(mi);
        if (!ExportPDF.isSupported()) {
            mi.setEnabled(false);
            mi.setToolTipText("iText library not found in classpath");
        }
        this.add(new JSeparator());
        this.add(new JMenuItem(new PrintAction(c, o)));
    }
}

