/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.actions;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.ujmp.core.Matrix;
import org.ujmp.core.filematrix.FileFormat;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.gui.actions.AbstractObjectAction;

public class ImportMatrixFromFileAction
extends AbstractObjectAction {
    private static final long serialVersionUID = 8110915004887885053L;

    public ImportMatrixFromFileAction(JComponent c, GUIObject m) {
        super(c, m);
        this.putValue("Name", "from File...");
        this.putValue("ShortDescription", "import a matrix from a location on disk");
        this.putValue("MnemonicKey", 70);
    }

    @Override
    public Object call() {
        try {
            File file = null;
            FileFormat fileFormat = null;
            JFileChooser chooser = new JFileChooser();
            for (FileFormat f : FileFormat.values()) {
                chooser.addChoosableFileFilter(f.getFileFilter());
            }
            chooser.setFileFilter(FileFormat.CSV.getFileFilter());
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setDialogTitle("Import");
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                file = chooser.getSelectedFile();
                FileFilter filter = chooser.getFileFilter();
                for (FileFormat f : FileFormat.values()) {
                    if (!filter.equals(f.getFileFilter())) continue;
                    fileFormat = f;
                }
            }
            if (file == null) {
                return null;
            }
            Matrix m = Matrix.Factory.importFrom().file(file).asDenseCSV();
            return m;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

