/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.SwingPropertyChangeSupport;
import org.ujmp.core.interfaces.CoreObject;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.core.interfaces.HasGUIObject;
import org.ujmp.gui.util.TaskQueue;

public abstract class AbstractObjectAction
implements Action,
Callable<Object>,
Serializable {
    private static final long serialVersionUID = -118767390543995981L;
    public static final int ROW = 0;
    public static final int COLUMN = 1;
    public static final int ALL = Integer.MAX_VALUE;
    private transient GUIObject object = null;
    private transient JComponent component = null;
    private transient Icon icon = null;
    private boolean enabled = true;
    protected transient SwingPropertyChangeSupport changeSupport;
    private final transient HashMap<String, Object> arrayTable = new HashMap();

    public AbstractObjectAction(JComponent c, GUIObject o) {
        this.setGUIObject(o);
        this.component = c;
        this.icon = UIManager.getIcon("UJMP.icon." + this.getClass().getSimpleName());
    }

    public final void setComponent(JComponent component) {
        this.component = component;
    }

    public final void setStatus(String status) {
        TaskQueue.setStatus(status);
    }

    public final void setProgress(double progress) {
        TaskQueue.setProgress(progress);
    }

    public final String toString() {
        return (String)this.getValue("Name") + " (" + this.getValue("ShortDescription") + ")";
    }

    public final GUIObject getGUIObject() {
        return this.object;
    }

    public final CoreObject getCoreObject() {
        if (this.object == null) {
            return null;
        }
        return this.object.getCoreObject();
    }

    public final void setGUIObject(GUIObject o) {
        if (o != null) {
            this.object = o;
        }
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        try {
            Object o = this.call();
            if (o instanceof GUIObject) {
                ((GUIObject)o).showGUI();
            } else if (o instanceof HasGUIObject) {
                ((HasGUIObject)o).showGUI();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final Future<?> executeInBackground() {
        Future<?> f = TaskQueue.submit(this);
        return f;
    }

    @Override
    public abstract Object call();

    public final JComponent getComponent() {
        return this.component;
    }

    @Override
    public Object getValue(String key) {
        if (this.arrayTable == null) {
            return null;
        }
        if ("enabled".equalsIgnoreCase(key)) {
            return this.enabled;
        }
        if (key == "SmallIcon") {
            return this.icon;
        }
        return this.arrayTable.get(key);
    }

    @Override
    public void setEnabled(boolean newValue) {
        this.enabled = newValue;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null || oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void putValue(String key, Object newValue) {
        Object oldValue = null;
        if (key == "enabled") {
            if (newValue == null || !(newValue instanceof Boolean)) {
                newValue = false;
            }
            oldValue = this.enabled;
            this.enabled = (Boolean)newValue;
        } else if (key == "SmallIcon") {
            oldValue = this.icon;
            this.icon = (ImageIcon)newValue;
        } else {
            if (this.arrayTable.containsKey(key)) {
                oldValue = this.arrayTable.get(key);
            }
            if (newValue == null) {
                this.arrayTable.remove(key);
            } else {
                this.arrayTable.put(key, newValue);
            }
        }
        this.firePropertyChange(key, oldValue, newValue);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }
}

