/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.matrices;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.SocketException;
import java.util.Arrays;
import java.util.TreeMap;
import org.ujmp.core.Matrix;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.util.concurrent.BackgroundTask;
import org.ujmp.core.util.concurrent.PFor;
import org.ujmp.core.util.matrices.RemoteHostMatrix;

public class SubnetMatrix
extends DefaultMapMatrix<String, Matrix> {
    private static final long serialVersionUID = -6949479403348183259L;
    private final InterfaceAddress address;

    public SubnetMatrix(InterfaceAddress address) throws SocketException {
        super(new TreeMap());
        this.address = address;
        this.setLabel(address.getAddress() + "/" + address.getNetworkPrefixLength());
        this.put(address.getAddress().getHostAddress(), new RemoteHostMatrix(address.getAddress().getHostAddress()));
        new BackgroundTask(new Object[0]){

            @Override
            public Object run() {
                SubnetMatrix.this.search();
                return null;
            }
        };
    }

    private void search() {
        try {
            final byte[] ip = this.address.getAddress().getAddress();
            if (ip.length != 4 || ip[0] == 127) {
                return;
            }
            new PFor(32, 1, 254){

                @Override
                public void step(int i) {
                    byte[] tmpip = Arrays.copyOf(ip, ip.length);
                    tmpip[3] = (byte)i;
                    try {
                        InetAddress tmpaddress = InetAddress.getByAddress(tmpip);
                        if (tmpaddress.isReachable(3000) && !SubnetMatrix.this.containsKey(tmpaddress.getHostAddress())) {
                            SubnetMatrix.this.put(tmpaddress.getHostAddress(), new RemoteHostMatrix(tmpaddress.getHostAddress()));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Matrix get(Object key) {
        String address;
        Matrix matrix = (Matrix)super.get(key);
        if (matrix == null && key != null && !(address = key.toString()).isEmpty()) {
            matrix = new RemoteHostMatrix(address);
            super.put(String.valueOf(key), matrix);
        }
        return matrix;
    }
}

