/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ujmp.core.filematrix.FileFormat;
import org.ujmp.core.listmatrix.DefaultListMatrix;
import org.ujmp.core.listmatrix.ListMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;
import org.ujmp.core.util.io.IntelligentFileReader;

public class FileUtil {
    public static FileFormat guessFormat(File file) {
        String filename = file.getAbsolutePath();
        String[] components = filename.split("\\.");
        String suffix = components[components.length - 1];
        if (suffix.equalsIgnoreCase("gz") || suffix.equalsIgnoreCase("z") || suffix.equalsIgnoreCase("gzip") || suffix.equalsIgnoreCase(".zip") || suffix.equalsIgnoreCase(".7zip") || suffix.equalsIgnoreCase(".7z")) {
            suffix = components[components.length - 2];
        }
        for (FileFormat f : FileFormat.values()) {
            if (!suffix.equalsIgnoreCase(f.name())) continue;
            return f;
        }
        throw new RuntimeException("could not guess file format: " + suffix);
    }

    public static boolean deleteRecursive(File path) {
        if (path != null && path.exists() && path.isDirectory()) {
            File[] files;
            for (File f : files = path.listFiles()) {
                if (f.isDirectory()) {
                    FileUtil.deleteRecursive(f);
                    continue;
                }
                f.delete();
            }
        }
        if (path != null) {
            boolean successful = path.delete();
            return successful;
        }
        return false;
    }

    public static List<File> getAll(File path) {
        ArrayList<File> all = new ArrayList<File>();
        if (path != null && path.exists()) {
            File[] files;
            for (File f : files = path.listFiles()) {
                if (f.isDirectory()) {
                    all.addAll(FileUtil.getAll(f));
                    continue;
                }
                all.add(f);
            }
        }
        return all;
    }

    public static boolean equalsContent(File file1, File file2) throws IOException {
        int length1;
        VerifyUtil.verifyNotNull(file1, "file1 is null");
        VerifyUtil.verifyNotNull(file2, "file2 is null");
        VerifyUtil.verifyTrue(file1.exists(), "file1 does not exist");
        VerifyUtil.verifyTrue(file2.exists(), "file2 does not exist");
        VerifyUtil.verifyTrue(file1.canRead(), "cannot read file1");
        VerifyUtil.verifyTrue(file2.canRead(), "cannot read file2");
        if (file1.length() != file2.length()) {
            return false;
        }
        int bufferSize = 8192;
        byte[] data1 = new byte[8192];
        byte[] data2 = new byte[8192];
        boolean areEqual = true;
        BufferedInputStream in1 = new BufferedInputStream(new FileInputStream(file1));
        BufferedInputStream in2 = new BufferedInputStream(new FileInputStream(file2));
        do {
            int length2;
            if ((length1 = in1.read(data1, 0, 8192)) != (length2 = in2.read(data2, 0, 8192))) {
                areEqual = false;
            } else {
                if (Arrays.equals(data1, data2)) continue;
                areEqual = false;
            }
            break;
        } while (length1 >= 8192);
        in1.close();
        in2.close();
        return areEqual;
    }

    public static boolean move(File source, File target) {
        VerifyUtil.verifyNotNull(source, "source file is null");
        VerifyUtil.verifyNotNull(target, "target file is null");
        VerifyUtil.verifyTrue(source.canRead(), "cannot read source file");
        VerifyUtil.verifyTrue(source.exists(), "source file does not exist");
        VerifyUtil.verifyFalse(target.exists(), "target file exists");
        return source.renameTo(target);
    }

    public static String loadToString(File file) {
        return IntelligentFileReader.load(file);
    }

    public static byte[] getBytes(File file) {
        return IntelligentFileReader.readBytes(file);
    }

    public static void copyFile(File source, File target) throws IOException {
        VerifyUtil.verifyNotNull(source, "source file is null");
        VerifyUtil.verifyNotNull(target, "target file is null");
        VerifyUtil.verifyTrue(source.canRead(), "cannot read source file");
        VerifyUtil.verifyTrue(source.exists(), "source file does not exist");
        VerifyUtil.verifyFalse(target.exists(), "target file exists");
        FileInputStream fis = new FileInputStream(source);
        FileOutputStream fos = new FileOutputStream(target);
        FileChannel inChannel = fis.getChannel();
        FileChannel outChannel = fos.getChannel();
        long maxCount = 67076096L;
        long size = inChannel.size();
        try {
            for (long position = 0L; position < size; position += inChannel.transferTo(position, 67076096L, outChannel)) {
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static String md5Sum(File file) throws NoSuchAlgorithmException, IOException {
        return MathUtil.md5(file);
    }

    public static List<List<File>> findDuplicates(File path) throws Exception {
        return FileUtil.findDuplicates(path, new HashMap<String, List<File>>());
    }

    private static List<List<File>> findDuplicates(File path, Map<String, List<File>> md5Map) throws Exception {
        File[] files;
        ArrayList<List<File>> list = new ArrayList<List<File>>();
        for (File file : files = path.listFiles()) {
            if (file.isDirectory()) {
                List<List<File>> subDirList = FileUtil.findDuplicates(file);
                list.addAll(subDirList);
                continue;
            }
            System.out.print(file);
            String md5 = FileUtil.md5Sum(file);
            System.out.println(" [" + md5 + "]");
            List<File> similarFiles = md5Map.get(md5);
            if (similarFiles == null) {
                similarFiles = new LinkedList<File>();
                md5Map.put(md5, similarFiles);
            }
            if (!similarFiles.isEmpty()) {
                System.out.println("   " + similarFiles.size() + " files with same md5");
                for (File similarFile : similarFiles) {
                    if (!FileUtil.equalsContent(file, similarFile)) continue;
                    System.out.println("   match found: " + similarFile);
                    LinkedList<File> set = new LinkedList<File>();
                    set.add(file);
                    set.add(similarFile);
                    list.add(set);
                }
            }
            similarFiles.add(file);
        }
        return list;
    }

    public static int countFiles(File path) {
        int count = 0;
        File[] files = path.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    count += FileUtil.countFiles(f);
                    continue;
                }
                ++count;
            }
        }
        return count;
    }

    public static ListMatrix<File> listRecursive(File path) {
        DefaultListMatrix<File> list = new DefaultListMatrix<File>();
        File[] files = path.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    list.addAll(FileUtil.listRecursive(f));
                    continue;
                }
                list.add(f);
            }
        }
        return list;
    }

    public static final File appendExtension(File file, String newExtension) {
        String name = file.getAbsolutePath().concat(newExtension);
        return new File(name);
    }
}

