/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.text;

import java.util.Arrays;
import java.util.Collection;
import org.ujmp.core.listmatrix.DefaultListMatrix;
import org.ujmp.core.text.TextSentence;
import org.ujmp.core.text.TextToken;
import org.ujmp.core.text.TextUtil;

public class DefaultTextSentence
extends DefaultListMatrix<TextToken>
implements TextSentence {
    private static final long serialVersionUID = -1411406267646623488L;
    private static int sentenceId = 1;

    public DefaultTextSentence(String sentence) {
        this(TextUtil.convertSentenceToTextTokens(sentence));
    }

    public DefaultTextSentence(TextToken ... textTokens) {
        this((Collection<TextToken>)Arrays.asList(textTokens));
    }

    public DefaultTextSentence(Collection<TextToken> textTokens) {
        this.setMetaData("Id", "Sentence" + sentenceId++);
        this.addAll(textTokens);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TextToken token : this) {
            int i = 0;
            sb.append(token.getText());
            String tag = token.getTag();
            if (!"n/a".equals(tag)) {
                sb.append(" [" + tag + "]");
            }
            if (i++ >= this.size() - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    @Override
    public String toJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("  {\n");
        sb.append("    \"Type\": \"Sentence\",\n");
        sb.append("    \"Id\": ");
        sb.append("\"");
        sb.append(this.getMetaData("Id"));
        sb.append("\",\n");
        sb.append("    \"Tokens\":\n");
        sb.append("    [\n");
        int i = 0;
        for (TextToken token : this) {
            sb.append(token.toJson());
            if (i++ >= this.size() - 1) continue;
            sb.append(",\n");
        }
        sb.append("\n    ]\n");
        sb.append("  }");
        return sb.toString();
    }

    @Override
    public boolean setTag(String token, String tag) {
        boolean tokenFound = false;
        for (TextToken text : this) {
            if (!token.equals(text.getText())) continue;
            if (tokenFound) {
                throw new RuntimeException("multiple matching tokens found");
            }
            text.setTag(tag);
            tokenFound = true;
        }
        return tokenFound;
    }
}

