/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.util.Collection;
import java.util.List;
import org.ujmp.core.Matrix;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.StringUtil;

public class Deletion
extends AbstractObjectCalculation {
    private static final long serialVersionUID = 3714270132906708701L;
    private long[][] selection = null;

    public Deletion(Matrix m, String deletionString) {
        this(m, StringUtil.parseSelection(deletionString, m.getSize()));
    }

    public Deletion(Matrix m, Collection<? extends Number> ... deletion) {
        super(m);
        List<Long> rows = MathUtil.sequenceListLong(0L, this.getSource().getRowCount());
        List<Long> columns = MathUtil.sequenceListLong(0L, this.getSource().getColumnCount());
        for (Number number : deletion[0]) {
            rows.remove(number.longValue());
        }
        for (Number number : deletion[1]) {
            columns.remove(number.longValue());
        }
        this.selection = new long[2][];
        this.selection[0] = MathUtil.collectionToLongArray(rows);
        this.selection[1] = MathUtil.collectionToLongArray(columns);
    }

    public Deletion(Matrix m, long[] ... deletion) {
        super(m);
        List<Long> rows = MathUtil.sequenceListLong(0L, this.getSource().getRowCount());
        List<Long> columns = MathUtil.sequenceListLong(0L, this.getSource().getColumnCount());
        if (deletion != null && deletion[0] != null) {
            for (int r = 0; r < deletion[0].length; ++r) {
                rows.remove(deletion[0][r]);
            }
        }
        if (deletion.length > 1 && deletion[1] != null) {
            for (int c = 0; c < deletion[1].length; ++c) {
                columns.remove(deletion[1][c]);
            }
        }
        this.selection = new long[2][];
        this.selection[0] = MathUtil.collectionToLongArray(rows);
        this.selection[1] = MathUtil.collectionToLongArray(columns);
    }

    @Override
    public Object getObject(long ... coordinates) {
        return this.getSource().getAsObject(this.selection[0][(int)coordinates[0]], this.selection[1][(int)coordinates[1]]);
    }

    @Override
    public long[] getSize() {
        return new long[]{this.selection[0].length, this.selection[1].length};
    }
}

