/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.listmatrix.ListMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.objectmatrix.impl.EmptyMatrix;
import org.ujmp.core.util.io.IntelligentFileWriter;

public class ExportMatrixXML {
    private static final String XMLHEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static boolean createXMLHeader = true;
    private static boolean createInfo = true;

    public static void toFile(File file, Matrix matrix, Object ... parameters) throws IOException {
        IntelligentFileWriter writer = new IntelligentFileWriter(file);
        ExportMatrixXML.toWriter((Writer)writer, matrix, parameters);
        writer.close();
    }

    public static void toStream(OutputStream outputStream, Matrix matrix, Object ... parameters) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        ExportMatrixXML.toWriter((Writer)writer, matrix, parameters);
        writer.close();
    }

    public static void toWriter(Writer writer, MapMatrix<?, ?> map, Object ... parameters) throws IOException {
        String EOL = System.getProperty("line.separator");
        writer.write("<map>");
        writer.write(EOL);
        for (Map.Entry e : map.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            writer.write("<" + key + ">");
            writer.write(String.valueOf(value));
            writer.write("</" + key + ">");
            writer.write(EOL);
        }
        writer.write("</map>");
        writer.write(EOL);
    }

    public static void toWriter(Writer writer, Matrix matrix, Object ... parameters) throws IOException {
        String EOL = System.getProperty("line.separator");
        if (parameters != null && parameters.length > 0 && parameters[0] instanceof Boolean) {
            createXMLHeader = createXMLHeader;
        }
        if (createXMLHeader) {
            writer.write(XMLHEADER);
            writer.write(EOL);
        }
        if (matrix == null || matrix instanceof EmptyMatrix) {
            writer.write("<emptyMatrix></emptyMatrix>");
            writer.write(EOL);
        } else if (matrix instanceof MapMatrix) {
            ExportMatrixXML.toWriter(writer, (MapMatrix)matrix, parameters);
        } else if (matrix instanceof ListMatrix) {
            ExportMatrixXML.toWriter(writer, (ListMatrix)matrix, parameters);
        } else {
            String size = Coordinates.toString(matrix.getSize());
            String vt = matrix.getValueType().name();
            writer.write("<matrix ");
            writer.write("size=\"");
            writer.write(size);
            writer.write("\" valueType=\"");
            writer.write(vt);
            writer.write("\">");
            writer.write(EOL);
            writer.write("</matrix>");
            writer.write(EOL);
        }
    }
}

